/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.java.artifacts;

import java.util.ArrayList;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactModel;
import net.ssehub.easy.instantiation.core.model.artifactModel.FragmentArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.IArtifactVisitor;
import net.ssehub.easy.instantiation.core.model.artifactModel.representation.Binary;
import net.ssehub.easy.instantiation.core.model.artifactModel.representation.Text;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.ExpressionEvaluator;
import net.ssehub.easy.instantiation.core.model.vilTypes.ArraySet;
import net.ssehub.easy.instantiation.core.model.vilTypes.IStringValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.ReturnGenerics;
import net.ssehub.easy.instantiation.core.model.vilTypes.Set;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.java.artifacts.AbstractJavaStatement;
import net.ssehub.easy.instantiation.java.artifacts.IJavaParent;
import net.ssehub.easy.instantiation.java.artifacts.JavaAnnotation;
import net.ssehub.easy.instantiation.java.artifacts.JavaAssignment;
import net.ssehub.easy.instantiation.java.artifacts.JavaCall;
import net.ssehub.easy.instantiation.java.artifacts.JavaParentFragmentArtifact;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;

public class JavaMethod
extends JavaParentFragmentArtifact {
    private MethodDeclaration methodDeclaration;

    public JavaMethod(MethodDeclaration node, IJavaParent parent) {
        super(parent);
        this.methodDeclaration = node;
    }

    private ArraySet<AbstractJavaStatement> statements() {
        final ArrayList list = new ArrayList();
        this.methodDeclaration.accept(new ASTVisitor(){

            public boolean visit(ExpressionStatement node) {
                if (node.getExpression() instanceof MethodInvocation) {
                    ITypeBinding typeBinding;
                    MethodInvocation methodInvocation = (MethodInvocation)node.getExpression();
                    String methodName = methodInvocation.getName().toString();
                    if (methodInvocation.getExpression() != null && (typeBinding = methodInvocation.getExpression().resolveTypeBinding()) != null) {
                        JavaCall javaCall = new JavaCall(node, methodName, typeBinding, JavaMethod.this);
                        list.add(javaCall);
                    }
                }
                return false;
            }
        });
        return new ArraySet((Object[])list.toArray(new JavaCall[list.size()]), JavaCall.class);
    }

    private ArraySet<AbstractJavaStatement> assignments() {
        final ArrayList list = new ArrayList();
        this.methodDeclaration.accept(new ASTVisitor(){

            public boolean visit(Assignment node) {
                Expression lhs = node.getLeftHandSide();
                ITypeBinding typeBinding = lhs.resolveTypeBinding();
                Expression rhs = node.getRightHandSide();
                if (rhs instanceof ClassInstanceCreation && node.getParent() instanceof ExpressionStatement) {
                    ExpressionStatement parent = (ExpressionStatement)node.getParent();
                    JavaAssignment assignment = new JavaAssignment(JavaMethod.this, parent, lhs.toString(), typeBinding, (ClassInstanceCreation)rhs);
                    list.add(assignment);
                }
                return false;
            }
        });
        return new ArraySet((Object[])list.toArray(new JavaAssignment[list.size()]), JavaAssignment.class);
    }

    @Invisible
    public void deleteStatement(ExpressionEvaluator evaluator) throws VilException {
        TypeDescriptor obj = evaluator.getIteratorVariable().getType();
        ArraySet<AbstractJavaStatement> statements = null;
        if (obj.getTypeClass().isAssignableFrom(JavaCall.class)) {
            statements = this.statements();
        }
        if (obj.getTypeClass().isAssignableFrom(JavaAssignment.class)) {
            statements = this.assignments();
        }
        if (statements != null) {
            for (AbstractJavaStatement statement : statements) {
                Object object = evaluator.evaluate((Object)statement);
                if (object == null || !(object instanceof Boolean) || Boolean.TRUE.booleanValue() != ((Boolean)object).booleanValue()) continue;
                statement.delete();
                this.notifyChanged();
                this.store();
            }
        }
    }

    public void deleteWithCalls() throws VilException {
        this.delete();
    }

    @Override
    public void delete() throws VilException {
        this.methodDeclaration.delete();
        super.delete();
    }

    public String getName() throws VilException {
        return this.methodDeclaration.getName().toString();
    }

    public void rename(String name) throws VilException {
        this.methodDeclaration.setName(this.methodDeclaration.getAST().newSimpleName(name));
        this.notifyChanged();
    }

    public Text getText() throws VilException {
        return Text.CONSTANT_EMPTY;
    }

    public Binary getBinary() throws VilException {
        return Binary.CONSTANT_EMPTY;
    }

    public void accept(IArtifactVisitor visitor) {
        visitor.visitFragmentArtifact((FragmentArtifact)this);
    }

    @ReturnGenerics(value={JavaAnnotation.class})
    public Set<JavaAnnotation> annotations() {
        return this.annotations(this.methodDeclaration.modifiers());
    }

    @Invisible
    MethodDeclaration getMethodDeclaration() {
        return this.methodDeclaration;
    }

    @Invisible
    public String getStringValue(IStringValueProvider.StringComparator comparator) {
        return "method '" + this.getNameSafe() + "'";
    }

    @Override
    @Invisible
    public ArtifactModel getArtifactModel() {
        return this.getParent().getArtifactModel();
    }
}

