/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.java.codeArtifacts;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeAnnotation;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeAnnotationParent;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Comment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;

public class CodeParser {
    static <T> void apply(Supplier<List<?>> supplier, Class<T> cls, Consumer<T> consumer) {
        try {
            List<?> list = supplier.get();
            if (list != null) {
                for (Object o : list) {
                    if (!cls.isInstance(o)) continue;
                    consumer.accept(cls.cast(o));
                }
            }
        }
        catch (UnsupportedOperationException e) {
            EASyLoggerFactory.INSTANCE.getLogger(CodeParser.class, "net.ssehub.easy.instantiation.java").debug("AST list access not supported: " + e.getMessage());
        }
    }

    static <T> T first(List<T> list, T dflt) {
        return CodeParser.get(list, 0, dflt);
    }

    static <T> T get(List<T> list, int pos, T dflt) {
        return pos < list.size() ? list.get(pos) : dflt;
    }

    static void apply(Supplier<Map<?, ?>> supplier, EntryConsumer consumer) {
        try {
            Map<?, ?> map = supplier.get();
            if (map != null) {
                for (Map.Entry<?, ?> p : map.entrySet()) {
                    if (!(p instanceof Map.Entry)) continue;
                    Map.Entry<?, ?> ent = p;
                    consumer.accept(ent.getKey(), ent.getValue());
                }
            }
        }
        catch (UnsupportedOperationException e) {
            EASyLoggerFactory.INSTANCE.getLogger(CodeParser.class, "net.ssehub.easy.instantiation.java").debug("AST map access not supported: " + e.getMessage());
        }
    }

    static void idRest(List<?> fragments, IdRestConsumer consumer) {
        consumer.accept(fragments.get(0).toString(), CodeParser.join(fragments, 1, -1));
    }

    static String join(List<?> fragments, int start, int end) {
        if (end < 0) {
            end = fragments.size();
        }
        Object result = "";
        int i = start;
        while (i < end) {
            if (((String)result).length() > 0) {
                result = (String)result + " ";
            }
            result = (String)result + String.valueOf(fragments.get(i));
            ++i;
        }
        return ((String)result).trim();
    }

    static String stringOf(String value) {
        String result = value.trim();
        if (result.startsWith("\"")) {
            result = result.substring(1);
        }
        if (result.endsWith("\"")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    static <T> void accept(Consumer<T> consumer, T value) {
        if (consumer != null) {
            consumer.accept(value);
        }
    }

    static Map<Integer, Comment> mapComments(CompilationUnit unit) {
        HashMap<Integer, Comment> result = new HashMap<Integer, Comment>();
        if (unit != null) {
            for (Object o : unit.getCommentList()) {
                if (!(o instanceof Comment)) continue;
                Comment c = (Comment)o;
                result.put(c.getStartPosition() + c.getLength(), c);
            }
        }
        return result;
    }

    static String getComment(ASTNode node, Map<Integer, Comment> comments, char[] source) {
        return CodeParser.getComment(CodeParser.getCommentBefore(node, comments), source);
    }

    static String getComment(Comment comment, char[] source) {
        String result = null;
        if (comment != null && comment.isBlockComment()) {
            result = new String(source, comment.getStartPosition() + 2, comment.getLength() - 4).trim();
        }
        return result;
    }

    static Comment getCommentBefore(ASTNode node, Map<Integer, Comment> comments) {
        Comment result = null;
        if (comments != null) {
            int i = 1;
            while (result == null && i <= 3) {
                result = comments.get(node.getStartPosition() - i);
                ++i;
            }
        }
        return result;
    }

    static void visitCommentBefore(ASTNode node, Map<Integer, Comment> comments, ASTVisitor visitor) {
        Comment before = CodeParser.getCommentBefore(node, comments);
        if (before != null) {
            before.accept(visitor);
        }
    }

    static void visitCommentAfter(ASTNode node, Map<Integer, Comment> comments, ASTVisitor visitor) {
        Comment after = CodeParser.getCommentAfter(node, comments);
        if (after != null) {
            after.accept(visitor);
        }
    }

    static Comment getCommentAfter(ASTNode node, Map<Integer, Comment> comments) {
        Comment result = null;
        if (comments != null) {
            int end = node.getStartPosition() + node.getLength();
            int i = 0;
            while (result == null && i <= 1) {
                result = comments.get(end + i);
                ++i;
            }
        }
        return result;
    }

    static void processAnnotations(Supplier<List<?>> supplier, Consumer<Boolean> enabledConsumer, Consumer<String> commentConsumer, JavaCodeAnnotationParent elt) {
        CodeParser.apply(supplier, Annotation.class, an -> {
            String fqt = an.getTypeName().getFullyQualifiedName();
            if ("VTL".equals(fqt)) {
                if (an instanceof NormalAnnotation) {
                    CodeParser.apply(() -> ((NormalAnnotation)an).values(), MemberValuePair.class, v -> {
                        if (v.getValue() != null) {
                            String name = v.getName().getIdentifier();
                            String value = v.getValue().toString();
                            if ("enabled".equals(name)) {
                                CodeParser.accept(enabledConsumer, Boolean.valueOf(value));
                            } else if ("comment".equals(name)) {
                                CodeParser.accept(commentConsumer, CodeParser.stringOf(value));
                            }
                        }
                    });
                }
            } else if (elt != null) {
                JavaCodeAnnotation jca = elt.addAnnotation(fqt);
                CodeParser.apply(() -> an.properties(), (k, v) -> jca.addArgument(k.toString(), v.toString()));
            }
        });
    }

    static interface EntryConsumer {
        public void accept(Object var1, Object var2);
    }

    static interface IdRestConsumer {
        public void accept(String var1, String var2);
    }
}

