/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.java.codeArtifacts;

import net.ssehub.easy.instantiation.core.model.templateModel.CodeWriter;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationMeta;
import net.ssehub.easy.instantiation.java.codeArtifacts.IJavaCodeElement;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeConstructorCall;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeExpression;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeImportScope;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeMethodCall;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeStatement;

public class JavaCodeAssignment
extends JavaCodeStatement {
    private String variableName;
    private String operator;
    private JavaCodeExpression expression;

    public JavaCodeAssignment(IJavaCodeElement parent, String variableName, JavaCodeExpression expression) {
        this(parent, variableName, "=", expression);
    }

    public JavaCodeAssignment(IJavaCodeElement parent, String variableName, String operator, JavaCodeExpression expression) {
        super(parent);
        this.variableName = variableName;
        this.operator = operator;
        this.expression = expression;
        if (expression != null) {
            this.expression.setParent(this);
        }
    }

    public JavaCodeMethodCall addCall(String methodName) {
        return this.addCall(methodName, JavaCodeImportScope.NONE);
    }

    public JavaCodeMethodCall addCall(String methodName, JavaCodeImportScope scope) {
        this.expression = new JavaCodeMethodCall(this, methodName, scope, false, "");
        return (JavaCodeMethodCall)this.expression;
    }

    @OperationMeta(name={"callQualified"})
    public JavaCodeMethodCall addCallQualified(String methodName) {
        return this.addCall(methodName, JavaCodeImportScope.METHOD_CLASS_IMPORT);
    }

    public JavaCodeConstructorCall addNew(String cls) {
        this.expression = new JavaCodeConstructorCall(this, cls, false, "");
        return (JavaCodeConstructorCall)this.expression;
    }

    @Override
    public void store(CodeWriter out) {
        out.printIndent();
        out.print(this.variableName);
        out.print(" ");
        out.print(this.operator);
        out.print(" ");
        if (this.expression != null) {
            this.expression.store(out);
        }
        out.println(";");
    }

    @Override
    @Invisible
    public void setParent(IJavaCodeElement parent) {
        super.setParent(parent);
        if (this.expression != null) {
            this.expression.setParent(this);
        }
    }
}

