/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.java.codeArtifacts;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.templateModel.CodeWriter;
import net.ssehub.easy.instantiation.core.model.vilTypes.Conversion;
import net.ssehub.easy.instantiation.core.model.vilTypes.IVilType;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationMeta;
import net.ssehub.easy.instantiation.java.codeArtifacts.AST2ArtifactVisitor;
import net.ssehub.easy.instantiation.java.codeArtifacts.DummyJavaCodeElement;
import net.ssehub.easy.instantiation.java.codeArtifacts.IJavaCodeElement;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeAlternative;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeAssignment;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeBlockInterface;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeClass;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeDoLoop;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeEmptyLine;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeExpression;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeExpressionStatement;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeForLoop;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeImportScope;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeMethodCall;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeReturn;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeSingleLineComment;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeStatement;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeSwitch;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeSynchronizedBlock;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeText;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeThrow;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeTryBlock;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeTypeSpecification;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeVariableDeclaration;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeWhileLoop;

public class JavaCodeBlock
extends JavaCodeStatement
implements JavaCodeBlockInterface {
    private List<IJavaCodeElement> elements = new ArrayList<IJavaCodeElement>();
    private boolean outputWhitespaceBefore;
    private boolean outputLnAfter;
    private boolean isLambdaBlock;
    private boolean isStatic;
    private boolean withBrackets;
    private boolean indentBefore;

    public JavaCodeBlock(IJavaCodeElement parent, boolean outputWhitespaceBefore, boolean outputLnAfter) {
        this(parent, outputWhitespaceBefore, outputLnAfter, false, true, false);
    }

    public JavaCodeBlock(IJavaCodeElement parent, boolean outputWhitespaceBefore, boolean outputLnAfter, boolean isStatic, boolean withBrackets) {
        this(parent, outputWhitespaceBefore, outputLnAfter, isStatic, withBrackets, false);
    }

    public JavaCodeBlock(IJavaCodeElement parent, boolean outputWhitespaceBefore, boolean outputLnAfter, boolean isStatic, boolean withBrackets, boolean isLambdaBlock) {
        super(parent);
        this.outputWhitespaceBefore = isStatic ? true : outputWhitespaceBefore;
        this.outputLnAfter = outputLnAfter;
        this.isStatic = isStatic;
        this.withBrackets = isStatic ? true : withBrackets;
        this.isLambdaBlock = isLambdaBlock;
    }

    public static JavaCodeBlock create() {
        return JavaCodeBlock.create(false, false, false, true);
    }

    @Invisible
    @Conversion
    public static JavaCodeBlock convert(Object text) throws VilException {
        JavaCodeBlock result = null;
        Object tmp = IVilType.convertVilValue((Object)text);
        if (tmp != null) {
            result = JavaCodeBlock.create(text.toString(), AST2ArtifactVisitor.vilExceptionConsumer());
        }
        return result;
    }

    private static JavaCodeBlock create(String text, AST2ArtifactVisitor.ProblemConsumer problem) throws VilException {
        return AST2ArtifactVisitor.parseStatements(text, problem).getBlock();
    }

    public static JavaCodeBlock create(String text) throws VilException {
        return JavaCodeBlock.create(text, AST2ArtifactVisitor.logConsumer());
    }

    public static JavaCodeBlock create(boolean outputWhitespaceBefore, boolean outputLnAfter, boolean isStatic, boolean withBrackets) {
        return new JavaCodeBlock(new DummyJavaCodeElement(), outputWhitespaceBefore, outputLnAfter, isStatic, withBrackets);
    }

    protected JavaCodeClass getParentClass() {
        JavaCodeClass result = null;
        if (this.getParent() instanceof JavaCodeClass) {
            result = (JavaCodeClass)this.getParent();
        } else if (this.getParent() instanceof JavaCodeBlock) {
            result = ((JavaCodeBlock)this.getParent()).getParentClass();
        } else {
            JavaCodeClass iter = JavaCodeClass.getParentCodeClass(this);
            if (iter != null) {
                result = iter;
            }
        }
        return result;
    }

    protected <E extends IJavaCodeElement> E addElement(E element) {
        this.elements.add(element);
        return element;
    }

    protected <E extends IJavaCodeElement> E add(E element, int position) {
        this.elements.add(position, element);
        return element;
    }

    @Invisible
    public JavaCodeBlock indentBefore(boolean indentBefore) {
        this.indentBefore = indentBefore;
        return this;
    }

    protected Stream<IJavaCodeElement> elementsStream() {
        return this.elements.stream();
    }

    protected int getElementsSize() {
        return this.elements.size();
    }

    @Override
    public JavaCodeBlock add(String text) {
        return this.add(text, false);
    }

    @Override
    public JavaCodeBlock addAsStatement(String text) {
        return this.add(text, true);
    }

    private JavaCodeBlock add(String text, boolean asStatement) {
        if (text != null && ((String)text).length() > 0) {
            if (asStatement && !((String)text).endsWith(";")) {
                text = (String)text + ";";
            }
            this.elements.add(new JavaCodeText((String)text, true, true));
        }
        return this;
    }

    @Override
    public JavaCodeBlock add(JavaCodeStatement stmt) {
        if (!stmt.isEmpty()) {
            this.elements.add(stmt);
        }
        return this;
    }

    @Override
    public JavaCodeBlock addRaw(String text, boolean indent) {
        if (text != null && text.length() > 0) {
            this.elements.add(new JavaCodeText(text, indent, true));
        }
        return this;
    }

    @Override
    @OperationMeta(name={"addDoLoop", "do"})
    public JavaCodeDoLoop addDoLoop(String condition) {
        return IJavaCodeElement.add(this.elements, new JavaCodeDoLoop(this, condition));
    }

    @Override
    @OperationMeta(name={"addWhileLoop", "while"})
    public JavaCodeWhileLoop addWhileLoop(String condition) {
        return IJavaCodeElement.add(this.elements, new JavaCodeWhileLoop(this, condition));
    }

    @Override
    @OperationMeta(name={"addForLoop", "for"})
    public JavaCodeForLoop addForLoop(String type, String variableName, String expression) {
        return this.addForLoop(new JavaCodeTypeSpecification(type, this.getParentClass()), variableName, expression);
    }

    JavaCodeForLoop addForLoop(JavaCodeTypeSpecification type, String variableName, String expression) {
        return IJavaCodeElement.add(this.elements, new JavaCodeForLoop(this, type, variableName, expression));
    }

    @Override
    @OperationMeta(name={"addForLoop", "for"})
    public JavaCodeForLoop addForLoop(String type, String variableName, String initializer, String condition, String update) {
        return this.addForLoop(new JavaCodeTypeSpecification(type, this.getParentClass()), variableName, initializer, condition, update);
    }

    JavaCodeForLoop addForLoop(JavaCodeTypeSpecification type, String variableName, String initializer, String condition, String update) {
        return IJavaCodeElement.add(this.elements, new JavaCodeForLoop((IJavaCodeElement)this, type, variableName, initializer, condition, update));
    }

    @Override
    @OperationMeta(name={"addIf", "if"})
    public JavaCodeAlternative addIf(String condition) {
        return IJavaCodeElement.add(this.elements, new JavaCodeAlternative(this, condition));
    }

    @Override
    @OperationMeta(name={"addThrow", "throw"})
    public JavaCodeThrow addThrow(JavaCodeExpression expression) {
        return IJavaCodeElement.add(this.elements, new JavaCodeThrow(this, expression));
    }

    @Override
    @OperationMeta(name={"addSwitch", "switch"})
    public JavaCodeSwitch addSwitch(JavaCodeExpression expression) {
        return IJavaCodeElement.add(this.elements, new JavaCodeSwitch(this, expression));
    }

    @Override
    @OperationMeta(name={"addSynchronized", "synchronized"})
    public JavaCodeSynchronizedBlock addSynchronized(JavaCodeExpression objEx) {
        return IJavaCodeElement.add(this.elements, new JavaCodeSynchronizedBlock(this, objEx));
    }

    @Override
    @OperationMeta(name={"addTry", "try"})
    public JavaCodeTryBlock addTry() {
        return IJavaCodeElement.add(this.elements, new JavaCodeTryBlock(this));
    }

    @Override
    public JavaCodeExpressionStatement addPostfixIncrement(String variable) {
        return this.addPostfix(variable, true);
    }

    @Override
    public JavaCodeExpressionStatement addPostfixDecrement(String variable) {
        return this.addPostfix(variable, false);
    }

    private JavaCodeExpressionStatement addPostfix(String variable, boolean increment) {
        return IJavaCodeElement.add(this.elements, JavaCodeExpressionStatement.createPostfixStatement(this, variable, increment));
    }

    @Override
    @OperationMeta(name={"addAssignment", "addAssign", "assign"})
    public JavaCodeAssignment addAssignment(String variable) {
        return this.addAssignment(variable, "=", null);
    }

    @Override
    @OperationMeta(name={"addAssignment", "addAssign", "assign"})
    public JavaCodeAssignment addAssignment(String variable, JavaCodeExpression expression) {
        return this.addAssignment(variable, "=", expression);
    }

    @Override
    @OperationMeta(name={"addAssignment", "addAssign", "assign"})
    public JavaCodeAssignment addAssignment(String variable, String operator, JavaCodeExpression expression) {
        return IJavaCodeElement.add(this.elements, new JavaCodeAssignment(this, variable, operator, expression));
    }

    @Override
    @OperationMeta(name={"addEmptyLine", "emptyLine"})
    public JavaCodeBlock addEmptyLine() {
        IJavaCodeElement.add(this.elements, new JavaCodeEmptyLine(this));
        return this;
    }

    @Override
    @OperationMeta(name={"addSLComment", "SLComment"})
    public JavaCodeBlock addSLComment(String text) {
        IJavaCodeElement.add(this.elements, new JavaCodeSingleLineComment(this, text));
        return this;
    }

    @Override
    @OperationMeta(name={"addSuperCall", "super"})
    public JavaCodeMethodCall addSuperCall() {
        return this.addCall("super");
    }

    @Override
    @OperationMeta(name={"addThisCall", "this"})
    public JavaCodeMethodCall addThisCall() {
        return this.addCall("this");
    }

    @Override
    @OperationMeta(name={"addSystemOutPrintlnCall", "SystemOutPrintln", "sysoutprintln"})
    public JavaCodeMethodCall addSystemOutPrintlnCall() {
        return this.addCall("System.out.println");
    }

    @OperationMeta(name={"addBreak", "break"})
    public JavaCodeBlock addBreak() {
        this.add("break;");
        return this;
    }

    @OperationMeta(name={"addContinue", "continue"})
    public JavaCodeBlock addContinue() {
        this.add("continue;");
        return this;
    }

    public JavaCodeMethodCall addJunitAssertCall(String methodName) {
        return this.addCall("org.junit.Assert." + methodName, JavaCodeImportScope.CLASS);
    }

    @Override
    @OperationMeta(name={"addCall", "call"})
    public JavaCodeMethodCall addCall(String methodName) {
        return this.addCall(methodName, JavaCodeImportScope.NONE);
    }

    @Override
    @OperationMeta(name={"addCall", "call"})
    public JavaCodeMethodCall addCall(String methodName, JavaCodeImportScope scope) {
        return IJavaCodeElement.add(this.elements, new JavaCodeMethodCall(this, methodName, scope, true, ";" + System.lineSeparator()));
    }

    @Override
    @OperationMeta(name={"callQualified"})
    public JavaCodeMethodCall addCallQualified(String methodName) {
        return this.addCall(methodName, JavaCodeImportScope.METHOD_CLASS_IMPORT);
    }

    @Override
    @OperationMeta(name={"addVariable", "var"})
    public JavaCodeVariableDeclaration addVariable(String type, String variableName, JavaCodeExpression initializer) {
        return this.addVariable(type, variableName, false, initializer);
    }

    JavaCodeVariableDeclaration addVariable(JavaCodeTypeSpecification type, String variableName, JavaCodeExpression initializer) {
        return this.addVariable(type, variableName, false, initializer);
    }

    @Override
    @OperationMeta(name={"addVariable", "var"})
    public JavaCodeVariableDeclaration addVariable(String type, String variableName, boolean isFinal, JavaCodeExpression initializer) {
        return IJavaCodeElement.add(this.elements, this.createVariable(type, variableName, isFinal, initializer));
    }

    JavaCodeVariableDeclaration addVariable(JavaCodeTypeSpecification type, String variableName, boolean isFinal, JavaCodeExpression initializer) {
        return IJavaCodeElement.add(this.elements, new JavaCodeVariableDeclaration(this, type, variableName, isFinal, initializer));
    }

    @Override
    public JavaCodeVariableDeclaration createVariable(String type, String variableName, JavaCodeExpression initializer) {
        return this.createVariable(type, variableName, false, initializer);
    }

    @Override
    public JavaCodeVariableDeclaration createVariable(String type, String variableName, boolean isFinal, JavaCodeExpression initializer) {
        JavaCodeTypeSpecification t = type == null || type.length() == 0 ? null : new JavaCodeTypeSpecification(type, this.getParentClass());
        return new JavaCodeVariableDeclaration(this, t, variableName, isFinal, initializer);
    }

    @OperationMeta(name={"addReturn", "return"})
    public JavaCodeBlock addReturn(JavaCodeExpression valueEx) {
        IJavaCodeElement.add(this.elements, new JavaCodeReturn(this, valueEx));
        return this;
    }

    public JavaCodeBlock addBlock(boolean outputWhitespaceBefore, boolean outputLnAfter, boolean isStatic, boolean withBrackets) {
        return IJavaCodeElement.add(this.elements, new JavaCodeBlock(this, outputWhitespaceBefore, outputLnAfter, isStatic, withBrackets));
    }

    public JavaCodeBlock addBlock(JavaCodeBlock block) {
        block.setParent(this);
        return IJavaCodeElement.add(this.elements, block);
    }

    @Override
    @Invisible
    public void transferElementsTo(JavaCodeBlockInterface block) {
        if (block != this) {
            for (IJavaCodeElement e : this.elements) {
                block.add(e);
                e.setParent(block);
            }
            this.elements.clear();
        }
    }

    @Override
    @Invisible
    public void setParent(IJavaCodeElement parent) {
        super.setParent(parent);
        this.elements.forEach(e -> e.setParent(this));
    }

    @Override
    @Invisible
    public void add(IJavaCodeElement element) {
        this.elements.add(element);
    }

    @Override
    public JavaCodeBlock addAll(JavaCodeBlockInterface block) {
        block.transferElementsTo(this);
        return this;
    }

    @Override
    public JavaCodeBlock parse(String text) throws VilException {
        this.addAll(JavaCodeBlock.create(text));
        return this;
    }

    public JavaCodeBlock setBlock(JavaCodeBlock block) {
        this.elements.clear();
        for (IJavaCodeElement e : block.elements) {
            e.setParent(this);
            this.elements.add(e);
        }
        return this;
    }

    @Override
    @Invisible
    public void store(CodeWriter out) {
        if (this.indentBefore) {
            out.printIndent();
        }
        if (this.withBrackets) {
            if (this.isStatic) {
                out.print("static");
            }
            if (this.outputWhitespaceBefore) {
                out.print(" ");
            }
            out.print("{");
            if (!this.isLambdaBlock) {
                out.println();
            }
        } else if (this.outputWhitespaceBefore) {
            out.print(" ");
        }
        if (this.elements.size() > 0) {
            if (this.isLambdaBlock) {
                out.println();
            }
            out.increaseIndent();
            for (IJavaCodeElement e : this.elements) {
                e.store(out);
            }
            this.storeBeforeBlockEnd(out);
            out.decreaseIndent();
        }
        if (this.withBrackets) {
            if (this.isLambdaBlock && this.elements.size() == 0) {
                out.print("}");
            } else {
                out.printwi("}");
            }
            if (this.outputLnAfter) {
                out.println();
            }
        }
    }

    protected void storeBeforeBlockEnd(CodeWriter out) {
    }

    @Override
    public int getElementCount() {
        int result = this.withBrackets ? 2 : 0;
        for (IJavaCodeElement a : this.elements) {
            result += a.getElementCount();
        }
        return result;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public JavaCodeBlock setStatic(boolean isStatic) {
        this.isStatic = isStatic;
        return this;
    }

    public JavaCodeBlock setStatic() {
        return this.setStatic(true);
    }

    @Override
    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public JavaCodeBlock replaceVariable(String oldName, String newName) {
        this.elements.forEach(e -> {
            IJavaCodeElement iJavaCodeElement = e.replaceVariable(oldName, newName);
        });
        return this;
    }

    @Override
    public JavaCodeBlock replaceMethod(String oldName, String newName) {
        this.elements.forEach(e -> {
            JavaCodeBlock javaCodeBlock = this.replaceMethod(oldName, newName);
        });
        return this;
    }

    protected boolean contains(IJavaCodeElement elt) {
        return this.elements.contains(elt);
    }

    protected boolean withBrackets() {
        return this.withBrackets;
    }
}

