/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.java.codeArtifacts;

import net.ssehub.easy.instantiation.core.model.templateModel.CodeWriter;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.java.codeArtifacts.IJavaCodeElement;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeExpression;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeParsedExpression;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeTypeSpecification;

public class JavaCodeCastExpression
extends JavaCodeParsedExpression {
    private String typeName;
    private JavaCodeTypeSpecification type;
    private JavaCodeExpression valueEx;

    public JavaCodeCastExpression(IJavaCodeElement parent, String type, JavaCodeExpression valueEx) {
        super(parent);
        this.typeName = type;
        this.valueEx = valueEx;
        this.updateType();
    }

    public static JavaCodeCastExpression create(String type, JavaCodeExpression valueEx) {
        return new JavaCodeCastExpression(null, type, valueEx);
    }

    private void updateType() {
        if (this.getParent() != null) {
            this.type = new JavaCodeTypeSpecification(this.typeName, this.getParent());
        }
    }

    @Override
    @Invisible
    public void setParent(IJavaCodeElement parent) {
        super.setParent(parent);
        this.updateType();
        JavaCodeCastExpression.setParent(this.valueEx, this);
    }

    @Override
    public void store(CodeWriter out) {
        if (this.typeName.length() > 0) {
            out.print("(");
            if (this.type != null) {
                out.print(this.type.getOutputType());
            } else {
                out.print(this.typeName);
            }
            out.print(") ");
        }
        this.valueEx.store(out);
    }

    @Override
    public boolean isEmpty() {
        return this.typeName.length() > 0 ? false : this.valueEx.isEmpty();
    }
}

