/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.java.codeArtifacts;

import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.instantiation.core.model.templateModel.CodeWriter;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.java.codeArtifacts.IJavaCodeElement;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeBlock;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeTypeSpecification;

public class JavaCodeForLoop
extends JavaCodeBlock {
    private JavaCodeTypeSpecification type;
    private LoopVariable variable;
    private List<LoopVariable> furtherVariables = null;
    private String condition;
    private List<String> updates;

    public JavaCodeForLoop(IJavaCodeElement parent, JavaCodeTypeSpecification type, String variableName, String expression) {
        super(parent, true, true);
        this.type = type;
        this.variable = new LoopVariable(variableName, expression == null ? "" : expression);
    }

    public JavaCodeForLoop(IJavaCodeElement parent, JavaCodeTypeSpecification type, String variableName, String initializer, String condition, String update) {
        super(parent, true, true);
        this.type = type;
        this.variable = new LoopVariable(variableName, initializer);
        this.condition = condition;
        this.addUpdate(update);
    }

    public JavaCodeForLoop addUpdate(String update) {
        if (update != null && update.length() > 0) {
            if (this.updates == null) {
                this.updates = new ArrayList<String>();
            }
            this.updates.add(update);
        }
        return this;
    }

    public JavaCodeForLoop addLoopVariable(String name, String initializer) {
        if (name != null && name.length() > 0) {
            if (this.furtherVariables == null) {
                this.furtherVariables = new ArrayList<LoopVariable>();
            }
            this.furtherVariables.add(new LoopVariable(name, initializer));
        }
        return this;
    }

    @Override
    @Invisible
    public void store(CodeWriter out) {
        out.printwi("for (");
        boolean hasVariable = this.variable.hasVariable();
        if (hasVariable) {
            this.type.store(out);
            out.print(" ");
            out.print(this.variable.name);
        }
        if (this.updates == null) {
            out.print(" : ");
            out.print(this.variable.initializer);
        } else {
            if (hasVariable && this.variable.hasInitializer()) {
                out.print(" = ");
                out.print(this.variable.initializer);
            }
            if (this.furtherVariables != null) {
                for (LoopVariable v : this.furtherVariables) {
                    out.print(", ");
                    out.print(v.name);
                    if (!v.hasInitializer()) continue;
                    out.print(" = ");
                    out.print(v.initializer);
                }
            }
            out.print(";");
            if (this.condition != null) {
                out.print(" ");
                out.print(this.condition);
            }
            out.print(";");
            if (this.updates != null) {
                out.print(" ");
                boolean first = true;
                for (String u : this.updates) {
                    if (!first) {
                        out.print(", ");
                    }
                    out.print(u);
                    first = false;
                }
            }
        }
        out.print(")");
        super.store(out);
    }

    private static class LoopVariable {
        private String name;
        private String initializer;

        private LoopVariable(String name, String initializer) {
            this.name = name;
            this.initializer = initializer;
        }

        private boolean hasVariable() {
            return this.name != null && !this.name.isEmpty();
        }

        private boolean hasInitializer() {
            return this.initializer != null && !this.initializer.isEmpty();
        }
    }
}

