/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.java.codeArtifacts;

import net.ssehub.easy.instantiation.core.model.templateModel.CodeWriter;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.java.codeArtifacts.IJavaCodeElement;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeArgumentListExpression;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeExpression;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeParenthesisExpression;

public class JavaCodeOperatorExpression
extends JavaCodeExpression {
    private String operator;
    private JavaCodeExpression first;
    private JavaCodeExpression second;

    protected JavaCodeOperatorExpression(IJavaCodeElement parent, JavaCodeExpression first, String operator, JavaCodeExpression second) {
        super(parent);
        this.operator = operator.trim();
        this.first = first;
        this.second = second;
    }

    public static JavaCodeOperatorExpression create(JavaCodeExpression first, String operator, JavaCodeExpression second) {
        return new JavaCodeOperatorExpression(null, first, operator, second);
    }

    public static JavaCodeOperatorExpression create(String operator, JavaCodeArgumentListExpression operands) {
        return JavaCodeOperatorExpression.create(operator, operands, false);
    }

    public static JavaCodeOperatorExpression create(String operator, JavaCodeArgumentListExpression operands, boolean addParentheses) {
        JavaCodeOperatorExpression result = null;
        JavaCodeOperatorExpression prev = null;
        for (IJavaCodeElement op : operands.arguments()) {
            if (!(op instanceof JavaCodeExpression)) continue;
            JavaCodeOperatorExpression tmp = new JavaCodeOperatorExpression(null, (JavaCodeExpression)op, operator, null);
            if (result == null) {
                result = tmp;
                prev = tmp;
                continue;
            }
            prev.second = addParentheses ? new JavaCodeParenthesisExpression(result, tmp) : tmp;
            prev = tmp;
        }
        return result;
    }

    @Override
    @Invisible
    public void setParent(IJavaCodeElement parent) {
        super.setParent(parent);
        JavaCodeOperatorExpression.setParent(this.first, this);
        JavaCodeOperatorExpression.setParent(this.second, this);
    }

    @Override
    public void store(CodeWriter out) {
        this.first.store(out);
        if (this.second != null) {
            out.print(" ");
            out.print(this.operator);
            out.print(" ");
            this.second.store(out);
        }
    }

    @Override
    public JavaCodeOperatorExpression replaceVariable(String oldName, String newName) {
        this.first.replaceVariable(oldName, newName);
        if (this.second != null) {
            this.second.replaceVariable(oldName, newName);
        }
        return this;
    }

    @Override
    public JavaCodeOperatorExpression replaceMethod(String oldName, String newName) {
        this.first.replaceMethod(oldName, newName);
        if (this.second != null) {
            this.second.replaceMethod(oldName, newName);
        }
        return this;
    }
}

