/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.java.codeArtifacts;

import net.ssehub.easy.instantiation.core.model.templateModel.CodeWriter;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.java.codeArtifacts.IJavaCodeElement;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeExpression;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeParsedExpression;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeTextExpression;

public class JavaCodeTernaryExpression
extends JavaCodeParsedExpression {
    private JavaCodeExpression condition;
    private JavaCodeExpression ifEx;
    private JavaCodeExpression elseEx;

    protected JavaCodeTernaryExpression(IJavaCodeElement parent, String condition, String ifEx, String elseEx) {
        super(parent);
        this.condition = new JavaCodeTextExpression(this, condition);
        this.ifEx = new JavaCodeTextExpression(this, ifEx);
        this.elseEx = new JavaCodeTextExpression(this, elseEx);
    }

    protected JavaCodeTernaryExpression(IJavaCodeElement parent, JavaCodeExpression condition, JavaCodeExpression ifEx, JavaCodeExpression elseEx) {
        super(parent);
        this.condition = condition;
        this.ifEx = ifEx;
        this.elseEx = elseEx;
    }

    public static JavaCodeTernaryExpression create(JavaCodeExpression condition, JavaCodeExpression ifEx, JavaCodeExpression elseEx) {
        return new JavaCodeTernaryExpression(null, condition, ifEx, elseEx);
    }

    public void setIf(JavaCodeExpression ex) {
        ex.setParent(this);
        this.ifEx = ex;
    }

    public void setElseEx(JavaCodeExpression ex) {
        ex.setParent(this);
        this.elseEx = ex;
    }

    @Override
    @Invisible
    public void setParent(IJavaCodeElement parent) {
        super.setParent(parent);
        JavaCodeTernaryExpression.setParent(this.ifEx, this);
        JavaCodeTernaryExpression.setParent(this.elseEx, this);
    }

    @Override
    public void store(CodeWriter out) {
        this.condition.store(out);
        out.print(" ? ");
        this.ifEx.store(out);
        out.print(" : ");
        this.elseEx.store(out);
    }
}

