/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.java.codeArtifacts;

import net.ssehub.easy.instantiation.core.model.templateModel.CodeWriter;
import net.ssehub.easy.instantiation.core.model.vilTypes.IVilType;
import net.ssehub.easy.instantiation.java.codeArtifacts.IJavaCodeElement;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeParsedExpression;

public class JavaCodeTextExpression
extends JavaCodeParsedExpression {
    private Object text;

    protected JavaCodeTextExpression(IJavaCodeElement parent, Object text) {
        super(parent);
        this.text = text;
    }

    public static JavaCodeTextExpression create(Object text) {
        if (text instanceof IJavaCodeElement) {
            text = ((IJavaCodeElement)text).toCode();
        }
        return new JavaCodeTextExpression(null, IVilType.convertVilValue((Object)text));
    }

    @Override
    public void store(CodeWriter out) {
        if (this.text != null) {
            out.print(this.text.toString());
        }
    }

    @Override
    public boolean isEmpty() {
        return this.text == null || this.text.toString().length() == 0;
    }

    @Override
    public JavaCodeTextExpression replaceVariable(String oldName, String newName) {
        if (this.text != null) {
            this.text = this.text.toString().replace(oldName, newName);
        }
        return this;
    }

    JavaCodeTextExpression append(String text) {
        if (text != null) {
            if (this.text == null) {
                this.text = "";
            }
            this.text = text.toString() + " " + text;
        }
        return this;
    }
}

