/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.java.codeArtifacts;

import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.instantiation.core.model.templateModel.CodeWriter;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationMeta;
import net.ssehub.easy.instantiation.java.codeArtifacts.IJavaCodeElement;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeBlock;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeExpression;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeTypeSpecification;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeVariableDeclaration;

public class JavaCodeTryBlock
extends JavaCodeBlock {
    private List<JavaCodeCatchBlock> catches = new ArrayList<JavaCodeCatchBlock>();
    private JavaCodeBlock finallyBlock;
    private String tryDecl;
    private List<JavaCodeVariableDeclaration> tryDecls;

    public JavaCodeTryBlock(IJavaCodeElement parent) {
        super(parent, true, false);
    }

    JavaCodeCatchBlock addCatch(JavaCodeTypeSpecification type, String variableName) {
        return IJavaCodeElement.add(this.catches, new JavaCodeCatchBlock(this, type, variableName));
    }

    @OperationMeta(name={"addCatch", "catch"})
    public JavaCodeCatchBlock addCatch(String type, String variableName) {
        return this.addCatch(new JavaCodeTypeSpecification(type, this.getParentClass()), variableName);
    }

    @OperationMeta(name={"addFinally", "finally"})
    public JavaCodeBlock addFinally() {
        this.finallyBlock = new JavaCodeBlock(this, true, false);
        return this.finallyBlock;
    }

    @OperationMeta(name={"addResource", "resource"})
    public JavaCodeTryBlock addResource(String tryDecl) {
        this.tryDecl = tryDecl;
        return this;
    }

    @OperationMeta(name={"addResource", "resource"})
    public JavaCodeVariableDeclaration addResource(String type, String variableName, JavaCodeExpression initializer) {
        if (this.tryDecls == null) {
            this.tryDecls = new ArrayList<JavaCodeVariableDeclaration>();
        }
        JavaCodeTypeSpecification t = type == null ? null : new JavaCodeTypeSpecification(type, this.getParentClass());
        return IJavaCodeElement.add(this.tryDecls, new JavaCodeVariableDeclaration(this, t, variableName, false, initializer, true));
    }

    @Override
    @Invisible
    public void store(CodeWriter out) {
        out.printwi("try");
        if (this.tryDecls != null || this.tryDecl != null) {
            out.print(" (");
            if (this.tryDecl != null) {
                out.print(this.tryDecl);
            } else {
                IJavaCodeElement.storeList(this.tryDecls, "; ", out);
            }
            out.print(")");
        }
        super.store(out);
        for (JavaCodeCatchBlock c : this.catches) {
            c.store(out);
        }
        if (this.finallyBlock != null) {
            out.print(" finally");
            this.finallyBlock.store(out);
        }
        out.println();
    }

    @Override
    @Invisible
    public void setParent(IJavaCodeElement parent) {
        super.setParent(parent);
        if (this.catches != null) {
            this.catches.forEach(e -> e.setParent(this));
        }
        if (this.tryDecls != null) {
            this.tryDecls.forEach(e -> e.setParent(this));
        }
        if (this.finallyBlock != null) {
            this.finallyBlock.setParent(this);
        }
    }

    public class JavaCodeCatchBlock
    extends JavaCodeBlock {
        private List<JavaCodeTypeSpecification> types;
        private String variableName;

        private JavaCodeCatchBlock(IJavaCodeElement parent, JavaCodeTypeSpecification type, String variableName) {
            super(parent, true, false, false, true);
            this.types = new ArrayList<JavaCodeTypeSpecification>();
            this.types.add(type);
            this.variableName = variableName;
        }

        public void addType(String type) {
            this.types.add(new JavaCodeTypeSpecification(type, this.getParentClass()));
        }

        void addType(JavaCodeTypeSpecification type) {
            this.types.add(type);
        }

        @Override
        @Invisible
        public void store(CodeWriter out) {
            out.print(" catch (");
            IJavaCodeElement.storeList(this.types, "|", out);
            out.print(" ");
            out.print(this.variableName);
            out.print(")");
            super.store(out);
        }

        @Override
        @Invisible
        public void setParent(IJavaCodeElement parent) {
            super.setParent(parent);
            this.types.forEach(e -> e.setParent(this));
        }
    }
}

