/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.java.codeArtifacts;

import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.instantiation.core.model.templateModel.CodeToStringWriter;
import net.ssehub.easy.instantiation.core.model.templateModel.CodeWriter;
import net.ssehub.easy.instantiation.core.model.vilTypes.IStringValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.java.codeArtifacts.IJavaCodeArtifact;
import net.ssehub.easy.instantiation.java.codeArtifacts.IJavaCodeElement;
import net.ssehub.easy.instantiation.java.codeArtifacts.IJavaCodeTypeSpecification;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeClass;
import org.eclipse.jdt.core.dom.Type;

public class JavaCodeTypeSpecification
implements IJavaCodeElement,
IJavaCodeTypeSpecification {
    public static final JavaCodeTypeSpecification VOID = new JavaCodeTypeSpecification();
    private String origType;
    private String type;
    private List<JavaCodeTypeSpecification> generics;
    private String arrays;
    private JavaCodeClass enclosing;
    private boolean varArg;

    private JavaCodeTypeSpecification() {
        this("void", JavaCodeClass.EMPTY);
    }

    protected JavaCodeTypeSpecification(String type, IJavaCodeElement element) {
        this(type, JavaCodeClass.getParentCodeClass(element));
    }

    protected JavaCodeTypeSpecification(String type, JavaCodeClass enclosing) {
        this.enclosing = enclosing;
        this.origType = type;
        this.type = type;
        int startPos = type.indexOf("<");
        int endPos = type.lastIndexOf(">");
        if (startPos > 0 && endPos > 0) {
            String gen = type.substring(startPos, endPos + 1).trim();
            this.type = type.substring(0, startPos) + this.type.substring(endPos + 1).trim();
            this.generics = JavaCodeTypeSpecification.parseGenerics(gen, enclosing);
            if (this.generics == null) {
                this.generics = new ArrayList<JavaCodeTypeSpecification>();
            }
        }
        startPos = this.type.indexOf("[");
        endPos = this.type.lastIndexOf("]");
        if (startPos > 0 && endPos > 0) {
            this.arrays = this.type.substring(startPos, endPos + 1).replaceAll("\\s+", "");
            this.type = this.type.substring(0, startPos) + this.type.substring(endPos + 1);
        }
        if (enclosing != null && this.getArtifact() != null) {
            this.getArtifact().validateType(this);
        }
    }

    protected JavaCodeTypeSpecification(JavaCodeTypeSpecification type, JavaCodeClass enclosing) {
        this.enclosing = enclosing;
        this.type = type.type;
        this.arrays = type.arrays;
        if (type.generics != null) {
            this.generics = new ArrayList<JavaCodeTypeSpecification>(type.generics);
        }
    }

    public static JavaCodeTypeSpecification create(String type) {
        return new JavaCodeTypeSpecification(type, null);
    }

    public static JavaCodeTypeSpecification create(Type type) {
        JavaCodeTypeSpecification result = null;
        if (type != null) {
            result = JavaCodeTypeSpecification.create(type.toString());
        }
        return result;
    }

    static JavaCodeTypeSpecification toClassType(String cls, IJavaCodeElement element) {
        JavaCodeTypeSpecification result = null;
        if (cls != null && cls.length() > 0) {
            if (cls.endsWith(".class")) {
                cls = cls.substring(0, cls.length() - 6);
            }
            result = new JavaCodeTypeSpecification(cls, element);
        }
        return result;
    }

    public static List<JavaCodeTypeSpecification> parseGenerics(String text, JavaCodeClass enclosing) {
        ArrayList<JavaCodeTypeSpecification> result = null;
        int nested = -1;
        int lastPos = -1;
        int endGen = text.length();
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            switch (c) {
                case '<': {
                    if (++nested != 0) break;
                    lastPos = i + 1;
                    break;
                }
                case '>': {
                    if (nested == 0) {
                        endGen = i;
                    }
                    --nested;
                    break;
                }
                case ',': {
                    if (nested != 0) break;
                    if (result == null) {
                        result = new ArrayList();
                    }
                    result.add(new JavaCodeTypeSpecification(text.substring(lastPos, i).trim(), enclosing));
                    lastPos = i + 1;
                    break;
                }
            }
            ++i;
        }
        if (lastPos > 0 && lastPos < endGen) {
            if (result == null) {
                result = new ArrayList<JavaCodeTypeSpecification>();
            }
            result.add(new JavaCodeTypeSpecification(text.substring(lastPos, endGen).trim(), enclosing));
        }
        return result;
    }

    static JavaCodeTypeSpecification create(String type, JavaCodeClass enclosing) {
        JavaCodeTypeSpecification result = VOID.getType().equals(type) || type == null || type.length() == 0 ? VOID : new JavaCodeTypeSpecification(type, enclosing);
        return result;
    }

    public String getType() {
        return this.type;
    }

    public void addGeneric(JavaCodeTypeSpecification generic) {
        if (this.generics == null) {
            this.generics = new ArrayList<JavaCodeTypeSpecification>();
        }
        this.generics.add(generic);
    }

    @Override
    @Invisible
    public IJavaCodeArtifact getArtifact() {
        return this.enclosing.getArtifact();
    }

    @Invisible
    public JavaCodeClass getEnclosing() {
        return this.enclosing;
    }

    @Override
    @Invisible
    public void store(CodeWriter out) {
        out.print(this.type);
        if (this.generics != null) {
            out.print("<");
            int g = 0;
            while (g < this.generics.size()) {
                if (g > 0) {
                    out.print(", ");
                }
                this.generics.get(g).store(out);
                ++g;
            }
            out.print(">");
        }
        if (this.arrays != null) {
            out.print(this.arrays);
        }
        if (this.varArg) {
            out.print("...");
        }
    }

    public static boolean isVoid(JavaCodeTypeSpecification type) {
        return type == VOID;
    }

    @Override
    @Invisible(inherit=true)
    public String getTracerStringValue(IStringValueProvider.StringComparator comparator) {
        return this.getClass().getSimpleName() + " " + this.type;
    }

    @Override
    public String getOutputTypeName() {
        return this.type;
    }

    public String getOutputType() {
        CodeToStringWriter out = new CodeToStringWriter();
        this.store((CodeWriter)out);
        return out.getString();
    }

    @Override
    public String getFullName() {
        return this.origType;
    }

    @Override
    public void setOutputTypeName(String typeName) {
        this.type = typeName;
    }

    @Override
    @Invisible(inherit=true)
    public void setVarArg(boolean varArg) {
        this.varArg = varArg;
    }

    @Override
    public int getGenericCount() {
        return this.generics == null ? 0 : this.generics.size();
    }

    @Override
    public IJavaCodeTypeSpecification getGeneric(int index) {
        if (this.generics == null) {
            throw new IndexOutOfBoundsException(index);
        }
        return this.generics.get(index);
    }

    @Override
    public IJavaCodeElement getParent() {
        return this.enclosing;
    }

    @Override
    @Invisible
    public void setParent(IJavaCodeElement parent) {
        JavaCodeClass.setParent(parent, p -> {
            JavaCodeClass javaCodeClass = this.enclosing = p;
        });
        if (this.enclosing != null) {
            this.getArtifact().validateType(this);
        }
    }
}

