/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.java.codeArtifacts;

import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.instantiation.core.model.templateModel.CodeWriter;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationMeta;
import net.ssehub.easy.instantiation.java.codeArtifacts.IJavaCodeElement;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeAnnotation;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeAnonymousClass;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeCastExpression;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeClass;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeConstructorCall;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeExpression;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeImportScope;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeMethodCall;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeNewArrayExpression;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeStatement;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeTextExpression;
import net.ssehub.easy.instantiation.java.codeArtifacts.JavaCodeTypeSpecification;

public class JavaCodeVariableDeclaration
extends JavaCodeStatement {
    private JavaCodeTypeSpecification type;
    private String variableName;
    private boolean isFinal;
    private JavaCodeExpression initEx;
    private boolean asResource;
    private List<JavaCodeAnnotation> annotations;

    public JavaCodeVariableDeclaration(IJavaCodeElement parent, JavaCodeTypeSpecification type, String variableName, boolean isFinal, JavaCodeExpression initializer) {
        this(parent, type, variableName, isFinal, initializer, false);
    }

    public JavaCodeVariableDeclaration(IJavaCodeElement parent, JavaCodeTypeSpecification type, String variableName, boolean isFinal, JavaCodeExpression initializer, boolean asResource) {
        super(parent);
        this.type = type;
        this.variableName = variableName;
        this.isFinal = isFinal;
        if (initializer != null && !initializer.isEmpty()) {
            this.initEx = initializer;
            this.initEx.setParent(this);
        }
        this.asResource = asResource;
    }

    @OperationMeta(name={"addInitializer", "initializer"})
    public JavaCodeVariableDeclaration addInitializer(JavaCodeExpression initializer) {
        this.initEx = initializer;
        this.initEx.setParent(this);
        return this;
    }

    @OperationMeta(name={"addInitializer", "initializer"})
    public JavaCodeVariableDeclaration addInitializer(String initializer) {
        return this.setInitializer(initializer);
    }

    public JavaCodeVariableDeclaration setInitializer(String initializer) {
        if (initializer != null && initializer.length() > 0) {
            this.initEx = new JavaCodeTextExpression(this, initializer);
        }
        return this;
    }

    public JavaCodeVariableDeclaration setFinal() {
        return this.setFinal(true);
    }

    public JavaCodeVariableDeclaration setFinal(boolean isFinal) {
        this.isFinal = isFinal;
        return this;
    }

    public JavaCodeExpression getInitializer() {
        return this.initEx;
    }

    @OperationMeta(name={"addCall", "call"})
    public JavaCodeMethodCall addCall(String methodName) {
        return this.addCall(methodName, JavaCodeImportScope.NONE);
    }

    @OperationMeta(name={"addCall", "call"})
    public JavaCodeMethodCall addCall(String methodName, JavaCodeImportScope scope) {
        this.initEx = new JavaCodeMethodCall(this, methodName, scope, false, "");
        return (JavaCodeMethodCall)this.initEx;
    }

    public JavaCodeConstructorCall addNew(String cls) {
        this.initEx = new JavaCodeConstructorCall(this, cls, false, "");
        return (JavaCodeConstructorCall)this.initEx;
    }

    @OperationMeta(name={"addNewArray", "newArray"})
    public JavaCodeNewArrayExpression addNewArray(String type) {
        this.initEx = new JavaCodeNewArrayExpression(this, type);
        return (JavaCodeNewArrayExpression)this.initEx;
    }

    public JavaCodeAnonymousClass addAnonymous(String cls) {
        JavaCodeAnonymousClass ano = new JavaCodeAnonymousClass(cls, JavaCodeClass.getParentCodeClass(this));
        this.initEx = JavaCodeAnonymousClass.toExpression(ano);
        return ano;
    }

    public JavaCodeCastExpression addCast(String cls, JavaCodeExpression initEx) {
        initEx = new JavaCodeCastExpression(this, cls, initEx);
        return (JavaCodeCastExpression)initEx;
    }

    @OperationMeta(name={"addAnnotation", "annotate"})
    public JavaCodeAnnotation addAnnotation(String type) {
        return this.addAnnotation(type, null);
    }

    @OperationMeta(name={"addSuppressWarningsAnnotation", "suppressWarnings"})
    public JavaCodeAnnotation addSuppressWarningsAnnotation() {
        return this.addAnnotation(SuppressWarnings.class.getSimpleName());
    }

    @OperationMeta(name={"addSuppressWarningsUncheckedAnnotation", "suppressWarningsUnchecked"})
    public JavaCodeAnnotation addSuppressWarningsUncheckedAnnotation() {
        return this.addSuppressWarningsAnnotation().addStringArgument("unchecked");
    }

    @OperationMeta(name={"addAnnotation", "annotate"})
    public JavaCodeAnnotation addAnnotation(String type, String nested) {
        if (this.annotations == null) {
            this.annotations = new ArrayList<JavaCodeAnnotation>();
        }
        return IJavaCodeElement.add(this.annotations, new JavaCodeAnnotation(new JavaCodeTypeSpecification(type, JavaCodeClass.getParentCodeClass(this)), nested, this));
    }

    @Override
    public void store(CodeWriter out) {
        if (this.annotations != null) {
            for (JavaCodeAnnotation a : this.annotations) {
                a.store(out);
            }
        }
        if (!this.asResource) {
            out.printIndent();
        }
        if (this.isFinal) {
            out.print("final ");
        }
        if (this.type == null) {
            out.print("var ");
        } else {
            this.type.store(out);
            out.print(" ");
        }
        out.print(this.variableName);
        if (this.initEx != null) {
            out.print(" = ");
            this.initEx.store(out);
        }
        if (!this.asResource) {
            out.println(";");
        }
    }

    @Override
    @Invisible
    public void storeAsQualifier(CodeWriter out) {
        out.print(this.variableName);
    }

    public String getName() {
        return this.variableName;
    }

    @Override
    @Invisible
    public void setParent(IJavaCodeElement parent) {
        super.setParent(parent);
        if (this.type != null) {
            this.type.setParent(this);
        }
        if (this.initEx != null) {
            this.initEx.setParent(this);
        }
    }

    @Override
    public JavaCodeVariableDeclaration replaceVariable(String oldName, String newName) {
        if (this.variableName.equals(oldName)) {
            this.variableName = newName;
        }
        return this;
    }
}

