/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hildesheim.sse.easy.loader;

import de.uni_hildesheim.sse.easy.loader.ILoader;
import de.uni_hildesheim.sse.easy.loader.StartupInfo;
import java.util.List;

public abstract class AbstractStartupInfoLoader
implements ILoader {
    private boolean verbose = false;
    private List<StartupInfo> startupSequence;
    private ClassLoader loader = AbstractStartupInfoLoader.class.getClassLoader();

    protected AbstractStartupInfoLoader(List<StartupInfo> startupSequence) {
        this.setStartupSequence(startupSequence);
    }

    protected void setStartupSequence(List<StartupInfo> startupSequence) {
        this.startupSequence = startupSequence;
    }

    @Override
    public void startup() {
        boolean verbose = this.isVerbose();
        for (StartupInfo info : this.startupSequence) {
            info.start(verbose, this.loader);
        }
    }

    @Override
    public void shutdown() {
        boolean verbose = this.isVerbose();
        for (StartupInfo info : this.startupSequence) {
            info.stop(verbose, this.loader);
        }
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public void setLoader(ClassLoader loader) {
        if (loader != null) {
            this.loader = loader;
        }
    }

    protected ClassLoader getLoader() {
        return this.loader;
    }
}

