/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hildesheim.sse.easy.loader;

import de.uni_hildesheim.sse.easy.loader.AbstractLoader;
import de.uni_hildesheim.sse.easy.loader.CommandExecutionException;
import de.uni_hildesheim.sse.easy.loader.ILoader;
import de.uni_hildesheim.sse.easy.loader.framework.BundleInfo;
import de.uni_hildesheim.sse.easy.loader.framework.BundleRegistry;
import de.uni_hildesheim.sse.easy.loader.framework.Utils;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class Loader
extends AbstractLoader
implements ILoader {
    private List<BundleInfo> data;
    private ClassLoader loader;
    private ClassLoader parentLoader;

    static {
        Loader.initializeRegistry();
    }

    public Loader() {
        this(new File("."));
    }

    public Loader(File base) {
        super(base);
    }

    @Override
    public void startup() {
        this.bootstrap(null);
    }

    public static void main(String[] args) {
        Loader loader = new Loader();
        loader.startup();
        loader.shutdown();
    }

    public void bootstrap(URL jarToExecute) {
        this.bootstrap(null, null, null);
        List<BundleInfo> roots = BundleRegistry.getInstance().getRootBundles();
        ArrayList<URL> urls = new ArrayList<URL>();
        this.data = new ArrayList<BundleInfo>();
        HashSet<BundleInfo> done = new HashSet<BundleInfo>();
        for (BundleInfo info : roots) {
            this.collectBootstrapData(info, urls, this.data, done, "EASy-Producer");
        }
        if (jarToExecute != null) {
            urls.add(jarToExecute);
        }
        this.loadAndInitialize(urls, this.data);
    }

    public void executeCommand(String arg) throws CommandExecutionException {
        try {
            Class<?> cls = this.loader.loadClass("Command");
            Method method = cls.getDeclaredMethod("execute", String.class);
            method.invoke(null, arg);
        }
        catch (ClassNotFoundException e) {
            throw new CommandExecutionException(e);
        }
        catch (NoSuchMethodException e) {
            throw new CommandExecutionException(e);
        }
        catch (InvocationTargetException e) {
            throw new CommandExecutionException(e);
        }
        catch (IllegalAccessException e) {
            throw new CommandExecutionException(e);
        }
    }

    public ClassLoader loadAndInitialize(List<URL> urls, List<BundleInfo> infos) {
        if (!urls.isEmpty()) {
            URL[] urlsArray = Utils.toArray(urls);
            this.loader = this.parentLoader == null ? new URLClassLoader(urlsArray) : new URLClassLoader(urlsArray, this.parentLoader);
            int i = 0;
            while (i < infos.size()) {
                BundleInfo info = infos.get(i);
                System.out.println("activating " + info.getName() + " " + String.valueOf(info.getTag()));
                if (info.getActivatorClassName() != null) {
                    Utils.startBundle(this.loader, info.getActivatorClassName());
                }
                int c = 0;
                while (c < info.getDsClassesCount()) {
                    Utils.activateDsInstance(this.loader, info.getDsClass(c));
                    ++c;
                }
                info.setClassloader(this.loader);
                ++i;
            }
        } else {
            this.loader = this.getClass().getClassLoader();
        }
        return this.loader;
    }

    @Override
    public void shutdown() {
        if (this.loader != null && this.data != null) {
            boolean successful = true;
            int i = 0;
            while (successful && i < this.data.size()) {
                BundleInfo info = this.data.get(i);
                ClassLoader loader = info.getClassloader();
                if (loader != null) {
                    System.out.println("shutting down " + info.getName() + " " + String.valueOf(info.getTag()));
                    int c = 0;
                    while (c < info.getDsClassesCount()) {
                        Utils.deactivateDsInstance(loader, info.getDsClass(c));
                        ++c;
                    }
                    if (info.getActivatorClassName() != null) {
                        Utils.stopBundle(loader, info.getActivatorClassName());
                    }
                }
                ++i;
            }
        }
    }

    private void printBootstrapData(List<URL> urls, List<BundleInfo> instantiate) {
        System.out.println("\nClasspath:");
        for (URL url : urls) {
            System.out.println("  " + String.valueOf(url));
        }
        System.out.print("\nInstantiate");
        System.out.println(":");
        for (BundleInfo data : instantiate) {
            System.out.println("  bundle: " + data.getName());
            if (data.getActivatorClassName() != null) {
                System.out.println("    activator: " + data.getActivatorClassName());
            }
            if (data.getDsClassesCount() <= 0) continue;
            System.out.println("    DS: ");
            int d = 0;
            while (d < data.getDsClassesCount()) {
                System.out.println("      " + data.getDsClass(d));
                ++d;
            }
        }
    }

    @Override
    public void setVerbose(boolean verbose) {
    }

    @Override
    public void setLoader(ClassLoader loader) {
        this.parentLoader = loader;
    }
}

