/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hildesheim.sse.easy.loader;

import de.uni_hildesheim.sse.easy.loader.InitType;
import de.uni_hildesheim.sse.easy.loader.framework.Log;
import de.uni_hildesheim.sse.easy.loader.framework.Utils;

public class StartupInfo {
    private InitType type;
    private String className;

    StartupInfo(InitType type, String className) {
        this.type = type;
        this.className = className;
    }

    public InitType getType() {
        return this.type;
    }

    public String getClassName() {
        return this.className;
    }

    public boolean start(boolean verbose, ClassLoader loader) {
        boolean result;
        if (InitType.ACTIVATOR == this.type) {
            if (verbose) {
                Log.info("START activator " + this.className);
            }
            result = Utils.startBundle(loader, this.className);
        } else if (InitType.DS == this.type) {
            if (verbose) {
                Log.info("START DS " + this.className);
            }
            result = Utils.activateDsInstance(loader, this.className);
        } else {
            result = false;
        }
        return result;
    }

    public boolean stop(boolean verbose, ClassLoader loader) {
        boolean result;
        if (InitType.ACTIVATOR == this.type) {
            if (verbose) {
                Log.info("STOP activator " + this.className);
            }
            result = Utils.stopBundle(loader, this.className);
        } else if (InitType.DS == this.type) {
            if (verbose) {
                Log.info("STOP DS " + this.className);
            }
            result = Utils.deactivateDsInstance(loader, this.className);
        } else {
            result = false;
        }
        return result;
    }

    public String toString() {
        return "StartupInfo(" + String.valueOf((Object)this.type) + ": " + this.className + ")";
    }
}

