/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hildesheim.sse.easy.loader.framework;

import de.uni_hildesheim.sse.easy.loader.framework.BundleException;
import de.uni_hildesheim.sse.easy.loader.framework.Version;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EasyDependency {
    private boolean isMandatory = true;
    private Version versionMin = null;
    private Version versionMax = null;
    private String specificationVersion = "";
    private String bundleSymbolicName = "";
    private Version bundleVersionMin = null;
    private Version bundleVersionMax = null;
    private List<String> reqBundles = new ArrayList<String>();

    public EasyDependency() {
    }

    /*
     * Unable to fully structure code
     */
    public EasyDependency(String info) {
        super();
        information = info.split(";");
        i = 0;
        while (i < information.length) {
            block18: {
                piece = information[i];
                if (piece.toLowerCase().contains("resolution")) {
                    this.isMandatory = piece.toLowerCase().contains("optional") == false;
                } else if (piece.toLowerCase().contains("specification-version")) {
                    this.specificationVersion = piece.split("=")[1];
                } else if (piece.toLowerCase().contains("bundle-symbolic-name")) {
                    this.bundleSymbolicName = piece.split("=")[1];
                } else if (piece.toLowerCase().contains("require-bundle")) {
                    req = piece.split(",");
                    j = 0;
                    while (j < req.length) {
                        this.reqBundles.add(req[j]);
                        ++j;
                    }
                } else if (piece.toLowerCase().contains("bundle-version")) {
                    range = EasyDependency.getRange(piece);
                    try {
                        if (range == null || range.length <= 0) break block18;
                        this.bundleVersionMin = new Version(range[0]);
                        if (range.length > 1) {
                            this.bundleVersionMax = new Version(range[1]);
                        }
                    }
                    catch (BundleException e) {
                        System.out.println("Version Error in EasyDependancy");
                    }
                } else if (piece.toLowerCase().contains("version")) {
                    range = EasyDependency.getRange(piece);
                    try {
                        if (range == null || range.length <= 0) ** GOTO lbl54
                        this.versionMin = new Version(range[0]);
                        if (range.length <= 1) ** GOTO lbl54
                        this.versionMax = new Version(range[1]);
                    }
                    catch (BundleException e) {
                        System.out.println("Version Error in EasyDependancy");
                    }
                }
            }
            ++i;
        }
    }

    public boolean getMandatory() {
        return this.isMandatory;
    }

    public Version getVersionMin() {
        return this.versionMin;
    }

    public Version getVersionMax() {
        return this.versionMax;
    }

    public String getSpecVersion() {
        return this.specificationVersion;
    }

    public Version getBundleVersionMin() {
        return this.bundleVersionMin;
    }

    public Version getBundleVersionMax() {
        return this.bundleVersionMax;
    }

    public String getBundleSymbolicName() {
        return this.bundleSymbolicName;
    }

    public List<String> getRequiredBundles() {
        return this.reqBundles;
    }

    public static void main(String[] args) {
        EasyDependency test = new EasyDependency("ResolUtion:=mandaTORY;specification-version=7;version:=[1.35,1.78];bundle-symbolic-name:=a.test.bundle;bundle-version:=[1.44,1.89]");
        System.out.println("Mandatory: " + test.getMandatory());
        System.out.println("VersionMin: " + String.valueOf(test.getVersionMin()));
        System.out.println("VersionMax: " + String.valueOf(test.getVersionMax()));
        System.out.println("SpecificationVersion: " + test.getSpecVersion());
        System.out.println("BundleVersionMin: " + String.valueOf(test.getBundleVersionMin()));
        System.out.println("BundleVersionMax: " + String.valueOf(test.getBundleVersionMax()));
        System.out.println("BundleSymbolicName: " + test.getBundleSymbolicName());
    }

    public static String[] getRange(String range) {
        Pattern pattern2;
        Matcher matcher2;
        String[] result = null;
        Pattern pattern = Pattern.compile("\\[(.*?)\\]");
        Matcher matcher = pattern.matcher(range);
        if (matcher.find()) {
            String sub = matcher.group(1);
            result = sub.toLowerCase().contains(",") ? sub.split(",") : new String[]{matcher.group(1)};
        }
        if ((result == null || result.length == 0) && (matcher2 = (pattern2 = Pattern.compile("\\[(.*?)\\)")).matcher(range)).find()) {
            String sub = matcher2.group(1);
            result = sub.toLowerCase().contains(",") ? sub.split(",") : new String[]{matcher2.group(1)};
        }
        return result;
    }

    public void setBundleVersionMin(Version min) {
        this.bundleVersionMin = min;
    }

    public void setBundleVersionMax(Version max) {
        this.bundleVersionMax = max;
    }

    public void mergeVersions(EasyDependency other) {
        if (other != null) {
            if (this.bundleVersionMin != null) {
                if (other.getBundleVersionMin() != null && this.bundleVersionMin.compareTo(other.getBundleVersionMin()) == -1) {
                    this.setBundleVersionMin(other.getBundleVersionMin());
                }
            } else {
                this.bundleVersionMin = other.getBundleVersionMin();
            }
            if (this.bundleVersionMax != null) {
                if (other.getBundleVersionMax() != null && this.bundleVersionMax.compareTo(other.getBundleVersionMax()) == -1) {
                    this.setBundleVersionMax(other.getBundleVersionMax());
                }
            } else {
                this.bundleVersionMax = other.getBundleVersionMax();
            }
        }
    }

    public void setName(String name) {
        this.bundleSymbolicName = name;
    }
}

