/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hildesheim.sse.easy.loader.framework;

import de.uni_hildesheim.sse.easy.loader.framework.BundleException;
import de.uni_hildesheim.sse.easy.loader.framework.EasyDependency;
import de.uni_hildesheim.sse.easy.loader.framework.Version;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class Feature {
    private DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    private Document doc;
    private File file;
    private String id;
    private Version version;
    private Map<String, EasyDependency> plugins;
    private List<EasyDependency> requiredFeatures = new ArrayList<EasyDependency>();

    public Feature(File file) {
        this.file = file;
        this.initialize();
    }

    private void initialize() {
        this.load(this.file);
        this.plugins = new HashMap<String, EasyDependency>();
        if (this.doc != null) {
            this.build(this.doc.getDocumentElement());
        }
    }

    private void load(File file) {
        if (file != null && file.length() > 0L) {
            try {
                DocumentBuilder builder = this.factory.newDocumentBuilder();
                this.doc = builder.parse(file);
            }
            catch (ParserConfigurationException exc) {
                exc.printStackTrace();
            }
            catch (SAXException exc) {
                exc.printStackTrace();
            }
            catch (IOException exc) {
                exc.printStackTrace();
            }
        }
    }

    private void build(Node node) {
        if (node.getNodeName().equals("feature")) {
            this.id = node.getAttributes().getNamedItem("id").getNodeValue();
            try {
                this.version = new Version(node.getAttributes().getNamedItem("version").getNodeValue());
            }
            catch (DOMException e) {
                e.printStackTrace();
            }
            catch (BundleException e) {
                e.printStackTrace();
            }
        }
        if (node.getNodeName().equalsIgnoreCase("import") || node.getNodeName().equalsIgnoreCase("include")) {
            boolean isImport = node.getNodeName().equalsIgnoreCase("import");
            EasyDependency newDependency = new EasyDependency();
            try {
                if (isImport && node.getAttributes().getNamedItem("feature") != null) {
                    newDependency.setName(node.getAttributes().getNamedItem("feature").getNodeValue());
                } else if (!isImport && node.getAttributes().getNamedItem("id") != null) {
                    newDependency.setName(node.getAttributes().getNamedItem("id").getNodeValue());
                }
                if (node.getAttributes().getNamedItem("version") != null) {
                    String vers = node.getAttributes().getNamedItem("version").getNodeValue();
                    String[] versions = EasyDependency.getRange(vers);
                    if (versions != null) {
                        newDependency.setBundleVersionMin(new Version(versions[0]));
                        if (versions.length > 1) {
                            newDependency.setBundleVersionMax(new Version(versions[1]));
                        } else {
                            newDependency.setBundleVersionMax(new Version(versions[0]));
                        }
                    }
                    if (node.getAttributes().getNamedItem("match") != null) {
                        if (node.getAttributes().getNamedItem("match").getNodeValue().equals("greaterThan")) {
                            newDependency.setBundleVersionMax(null);
                        } else if (node.getAttributes().getNamedItem("match").getNodeValue().equals("smallerThan")) {
                            newDependency.setBundleVersionMin(null);
                        }
                    } else {
                        newDependency.setBundleVersionMax(null);
                        newDependency.setBundleVersionMin(null);
                    }
                }
            }
            catch (DOMException e) {
                e.printStackTrace();
            }
            catch (BundleException e) {
                e.printStackTrace();
            }
            this.requiredFeatures.add(newDependency);
        }
        if (node.getNodeName().equals("plugin")) {
            this.plugins.put(node.getAttributes().getNamedItem("id").getNodeValue(), new EasyDependency("bundle-symbolic-name:=" + node.getAttributes().getNamedItem("id").getNodeValue() + ";bundle-version:=[" + node.getAttributes().getNamedItem("version").getNodeValue() + "]"));
        }
        int i = 0;
        while (i < node.getChildNodes().getLength()) {
            this.build(node.getChildNodes().item(i));
            ++i;
        }
    }

    public static void main(String[] args) {
        Feature test = new Feature(new File("C:/Users/Patu/Desktop/feature.xml"));
        System.out.println(test.id);
        System.out.println(test.version.toString());
        Object[] keys = test.plugins.keySet().toArray();
        int i = 0;
        while (i < keys.length) {
            System.out.println(test.plugins.get(keys[i]).getBundleSymbolicName() + " " + String.valueOf(test.plugins.get(keys[i]).getBundleVersionMin()) + " " + String.valueOf(test.plugins.get(keys[i]).getBundleVersionMax()));
            ++i;
        }
    }

    public Map<String, EasyDependency> getDependencies() {
        return this.plugins;
    }

    public List<EasyDependency> getRequirements() {
        return this.requiredFeatures;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return this.id;
    }
}

