/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hildesheim.sse.easy.loader.framework;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;

public class LoaderLog {
    private static Writer writer = new OutputStreamWriter(System.out);

    public static void init(String path) {
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(path), "utf-8"));
        }
        catch (IOException ex) {
            LoaderLog.reportException(ex);
        }
    }

    public static void writeLn(String text) {
        try {
            writer.write(text);
            LoaderLog.skipLine();
        }
        catch (IOException ex) {
            LoaderLog.reportException(ex);
        }
    }

    public static void warn(String text) {
        LoaderLog.stars();
        try {
            writer.write(text);
            LoaderLog.skipLine();
        }
        catch (IOException ex) {
            LoaderLog.reportException(ex);
        }
        LoaderLog.stars();
    }

    public static void info(String text) {
        try {
            writer.write(text);
            LoaderLog.skipLine();
        }
        catch (IOException ex) {
            LoaderLog.reportException(ex);
        }
    }

    public static void writeLn(Throwable throwable) {
        throwable.printStackTrace(new PrintWriter(writer));
    }

    public static void warn(String text, Exception error) {
        LoaderLog.stars();
        try {
            writer.write(text);
            LoaderLog.skipLine();
            writer.write(error.getMessage());
            LoaderLog.skipLine();
        }
        catch (IOException ex) {
            LoaderLog.reportException(ex);
        }
        LoaderLog.stars();
    }

    public static void error(String text) {
        LoaderLog.error(text, null);
    }

    public static void error(String text, Exception cause) {
        LoaderLog.stars();
        try {
            writer.write(text);
            LoaderLog.skipLine();
            if (cause != null) {
                writer.write(cause.getMessage());
                LoaderLog.skipLine();
            }
        }
        catch (IOException ex) {
            LoaderLog.reportException(ex);
        }
        LoaderLog.stars();
    }

    public static void stars() {
        try {
            writer.write("*************************************************************************");
            LoaderLog.skipLine();
        }
        catch (IOException ex) {
            LoaderLog.reportException(ex);
        }
    }

    public static void writeLn(String text, int indent) {
        Object sIndent = "";
        int i = 1;
        while (i <= indent) {
            sIndent = (String)sIndent + " ";
            ++i;
        }
        try {
            writer.write((String)sIndent + text);
            LoaderLog.skipLine();
        }
        catch (IOException ex) {
            LoaderLog.reportException(ex);
        }
    }

    public static void close() {
        try {
            writer.close();
        }
        catch (IOException ex) {
            LoaderLog.reportException(ex);
        }
    }

    public static void skipLine() {
        try {
            writer.write(System.getProperty("line.separator"));
        }
        catch (IOException ex) {
            LoaderLog.reportException(ex);
        }
    }

    public static void line() {
        try {
            LoaderLog.skipLine();
            writer.write("----------------------------------------------------------------");
            LoaderLog.skipLine();
            LoaderLog.skipLine();
        }
        catch (IOException ex) {
            LoaderLog.reportException(ex);
        }
    }

    private static void reportException(Exception ex) {
        System.out.println(ex.getMessage());
    }
}

