/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.core.mgmt;

import java.io.File;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.modelManagement.IModelLoader;
import net.ssehub.easy.basics.modelManagement.ModelInfo;
import net.ssehub.easy.basics.modelManagement.ModelLocations;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.instantiation.core.model.buildlangModel.BuildModel;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Script;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.execution.Executor;
import net.ssehub.easy.instantiation.core.model.execution.TracerFactory;
import net.ssehub.easy.instantiation.core.model.templateModel.TemplateModel;
import net.ssehub.easy.instantiation.core.model.tracing.ConsoleTracerFactory;
import net.ssehub.easy.producer.core.persistence.PersistenceUtils;
import net.ssehub.easy.reasoning.core.frontend.ReasonerFrontend;
import net.ssehub.easy.reasoning.core.reasoner.Message;
import net.ssehub.easy.reasoning.core.reasoner.ReasonerConfiguration;
import net.ssehub.easy.reasoning.core.reasoner.ReasoningResult;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.management.VarModel;
import net.ssehub.easy.varModel.model.Project;

public class EasyExecutor {
    private File base;
    private List<File> ivmlFolder = new ArrayList<File>();
    private File vilFolder;
    private File vtlFolder;
    private File vilSource;
    private File vilTarget;
    private String ivmlModelName;
    private String vilModelName;
    private String vilStartRuleName;
    private Map<String, Object> vilArguments;
    private Configuration cfg;
    private ProgressObserver observer = ProgressObserver.NO_OBSERVER;
    private ReasonerConfiguration rCfg;
    private TracerFactory tracerFactory = ConsoleTracerFactory.INSTANCE;
    private net.ssehub.easy.producer.core.persistence.Configuration easyCfg;
    private Logger logger = new Logger(){
        private EASyLoggerFactory.EASyLogger logger = EASyLoggerFactory.INSTANCE.getLogger(EasyExecutor.class, "net.ssehub.easy.producer.core");

        @Override
        public void warn(String text) {
            this.logger.warn(text);
        }

        @Override
        public void error(String text) {
            this.logger.error(text);
        }

        @Override
        public void info(String text) {
            this.logger.info(text);
        }
    };

    public EasyExecutor() {
        this.rCfg = new ReasonerConfiguration();
    }

    public EasyExecutor(File project, File modelFolder, String modelName) {
        this.base = project;
        this.ivmlFolder.add(modelFolder);
        this.ivmlModelName = modelName;
        this.vilFolder = modelFolder;
        this.vilModelName = modelName;
        this.vtlFolder = modelFolder;
        this.vilSource = project;
        this.vilTarget = project;
        this.rCfg = new ReasonerConfiguration();
    }

    public EasyExecutor setProjectBase(File base) {
        this.base = base;
        return this;
    }

    public EasyExecutor setupByProject(boolean fromFileOnly) {
        this.easyCfg = PersistenceUtils.getConfiguration(this.base);
        if (fromFileOnly && !this.easyCfg.isFromFile()) {
            this.easyCfg = null;
        }
        return this;
    }

    public EasyExecutor setIvmlFolder(File ivmlFolder) {
        if (this.ivmlFolder.size() > 0) {
            this.ivmlFolder.set(0, ivmlFolder);
        } else {
            this.ivmlFolder.add(ivmlFolder);
        }
        return this;
    }

    public EasyExecutor prependIvmlFolder(File ivmlFolder) {
        this.ivmlFolder.add(0, ivmlFolder);
        return this;
    }

    public EasyExecutor addIvmlFolder(File ivmlFolder) {
        this.ivmlFolder.add(ivmlFolder);
        return this;
    }

    public EasyExecutor setVilFolder(File vilFolder) {
        this.vilFolder = vilFolder;
        return this;
    }

    public EasyExecutor setVtlFolder(File vtlFolder) {
        this.vtlFolder = vtlFolder;
        return this;
    }

    public EasyExecutor setVilSource(File vilSource) {
        this.vilSource = vilSource;
        return this;
    }

    public EasyExecutor setVilTarget(File vilTarget) {
        this.vilTarget = vilTarget;
        return this;
    }

    public EasyExecutor setIvmlModelName(String ivmlModelName) {
        this.ivmlModelName = ivmlModelName;
        return this;
    }

    public EasyExecutor setVilModelName(String vilModelName) {
        this.vilModelName = vilModelName;
        return this;
    }

    public EasyExecutor addVilArgument(String name, Object value) {
        if (this.vilArguments == null) {
            this.vilArguments = new HashMap<String, Object>();
        }
        this.vilArguments.put(name, value);
        return this;
    }

    public EasyExecutor setVilStartRuleName(String vilStartRuleName) {
        this.vilStartRuleName = vilStartRuleName;
        return this;
    }

    public EasyExecutor setProgressObserver(ProgressObserver observer) {
        this.observer = observer;
        return this;
    }

    public EasyExecutor setReasonerConfiguration(ReasonerConfiguration rCfg) {
        if (rCfg != null) {
            this.rCfg = rCfg;
        }
        return this;
    }

    public EasyExecutor setReasoningProjectFilter(Predicate<Project> projectFilter) {
        this.rCfg.setProjectFilter(projectFilter);
        return this;
    }

    public EasyExecutor setTracerFactory(TracerFactory tracerFactory) {
        this.tracerFactory = tracerFactory;
        return this;
    }

    public EasyExecutor setLogger(Logger logger) {
        this.logger = logger;
        return this;
    }

    public void setupLocations() throws ModelManagementException {
        if (this.easyCfg != null) {
            this.logger.info("Setting up locations from EASy-Setup");
            PersistenceUtils.processLocation(this.easyCfg, true, false, this.observer);
        } else {
            ModelLocations.Location primary = null;
            for (File f : this.ivmlFolder) {
                this.logger.info("Setting IVML location " + String.valueOf(f));
                ModelLocations.Location loc = VarModel.INSTANCE.locations().addLocation(f, this.observer);
                if (primary == null) {
                    primary = loc;
                    continue;
                }
                primary.addDependentLocation(loc);
            }
            this.logger.info("Setting VIL location " + String.valueOf(this.vilFolder));
            BuildModel.INSTANCE.locations().addLocation(this.vilFolder, this.observer);
            this.logger.info("Setting VTL location " + String.valueOf(this.vtlFolder));
            TemplateModel.INSTANCE.locations().addLocation(this.vtlFolder, this.observer);
        }
    }

    public Configuration loadIvmlModel() throws ModelManagementException {
        this.logger.info("Loading model: " + this.ivmlModelName);
        List models = VarModel.INSTANCE.availableModels().getModelInfo(this.ivmlModelName);
        if (models != null && !models.isEmpty()) {
            ModelInfo prjInfo = (ModelInfo)models.get(0);
            Project prj = (Project)VarModel.INSTANCE.load(prjInfo);
            this.logger.info("Creating configuration instance: " + this.ivmlModelName);
            this.cfg = new Configuration(prj);
        } else {
            this.logger.error("No model found: " + this.ivmlModelName);
            for (File folder : this.ivmlFolder) {
                IModelLoader loader = VarModel.INSTANCE.loaders().getDefaultLoader();
                loader.scan(folder, (IModelLoader.IModelInfoHolder)new IModelLoader.IModelInfoHolder<Project>(){

                    public boolean isKnown(URI uri, IModelLoader<Project> loader) {
                        return false;
                    }

                    public void error(String message) {
                        EasyExecutor.this.logger.error(message);
                    }

                    public void addResult(ModelInfo<Project> toAdd) {
                    }
                });
            }
        }
        return this.cfg;
    }

    public ReasoningResult propagateOnIvmlModel() {
        if (this.cfg != null) {
            this.logger.info("Reasoning by propagation on model " + this.ivmlModelName);
            return ReasonerFrontend.getInstance().propagate(this.cfg, this.rCfg, this.observer);
        }
        throw new IllegalStateException("No IVML model loaded / configuration available.");
    }

    public void executeVil() throws ModelManagementException, VilException {
        if (this.cfg != null) {
            this.logger.info("Loading VIL script: " + this.vilModelName);
            List vil = BuildModel.INSTANCE.availableModels().getModelInfo(this.vilModelName);
            if (vil != null && !vil.isEmpty()) {
                ModelInfo vilInfo = (ModelInfo)vil.get(0);
                Script script = (Script)BuildModel.INSTANCE.load(vilInfo);
                if (this.tracerFactory != null) {
                    TracerFactory.setInstance((TracerFactory)this.tracerFactory);
                }
                TracerFactory.registerProgressObserver((ProgressObserver)this.observer);
                this.logger.info("Executing VIL script: " + this.vilModelName);
                Executor exec = new Executor(script).addBase(this.base).addSource(this.vilSource).addConfiguration(this.cfg).addTarget(this.vilTarget);
                if (this.vilArguments != null) {
                    for (Map.Entry<String, Object> ent : this.vilArguments.entrySet()) {
                        exec.addCustomArgument(ent.getKey(), ent.getValue());
                    }
                }
                if (this.vilStartRuleName != null) {
                    exec.addStartRuleName(this.vilStartRuleName);
                }
                try {
                    exec.execute();
                }
                catch (VilException e) {
                    this.logger.error("VIL execution failed: " + e.getMessage());
                }
                TracerFactory.unregisterProgressObserver((ProgressObserver)this.observer);
            } else {
                this.logger.error("No VIL script found: " + this.vilModelName);
            }
        } else {
            throw new IllegalStateException("No IVML model loaded / configuration available.");
        }
    }

    public void discardLocations() throws ModelManagementException {
        if (this.easyCfg != null) {
            this.logger.info("Discarding locations from EASy-Setup");
            PersistenceUtils.processLocation(this.easyCfg, false, false, this.observer);
        } else {
            this.logger.info("Discarding VTL location " + String.valueOf(this.vtlFolder));
            TemplateModel.INSTANCE.locations().removeLocation(this.vtlFolder, this.observer);
            this.logger.info("Discarding VIL location " + String.valueOf(this.vilFolder));
            BuildModel.INSTANCE.locations().removeLocation(this.vilFolder, this.observer);
            int f = this.ivmlFolder.size() - 1;
            while (f >= 0) {
                File folder = this.ivmlFolder.get(f);
                this.logger.info("Discarding IVML location " + String.valueOf(folder));
                VarModel.INSTANCE.locations().removeLocation(folder, this.observer);
                --f;
            }
        }
    }

    public void clearModels() {
        TemplateModel.INSTANCE.clear();
        BuildModel.INSTANCE.clear();
        VarModel.INSTANCE.clear();
    }

    public EasyExecutor execute() throws ModelManagementException, VilException {
        this.setupLocations();
        this.loadIvmlModel();
        this.propagateOnIvmlModel();
        this.executeVil();
        this.discardLocations();
        return this;
    }

    public Configuration getConfiguration() {
        return this.cfg;
    }

    public void setConfiguration(Configuration cfg) {
        this.cfg = cfg;
    }

    public static void printConfiguration(Configuration cfg) {
        EasyExecutor.printConfiguration(System.out, cfg);
    }

    public static void printConfiguration(PrintStream out, Configuration cfg) {
        Configuration.printConfig((PrintStream)out, (Configuration)cfg);
    }

    public void printConfiguration(PrintStream out) {
        EasyExecutor.printConfiguration(out, this.cfg);
    }

    public void printConfiguration() {
        this.printConfiguration(System.out);
    }

    public static void printReasoningMessages(ReasoningResult rRes, PrintStream out) {
        int m = 0;
        while (m < rRes.getMessageCount()) {
            Message msg = rRes.getMessage(m);
            out.println(msg.getDescription());
            out.println(msg.getConflictComments());
            out.println(msg.getConflictSuggestions());
            ++m;
        }
    }

    public static void printReasoningMessages(ReasoningResult rRes) {
        EasyExecutor.printReasoningMessages(rRes, System.out);
    }

    public static interface Logger {
        public void warn(String var1);

        public void error(String var1);

        public void info(String var1);
    }
}

