/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.core.persistence;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import net.ssehub.easy.basics.modelManagement.Version;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Script;
import net.ssehub.easy.producer.core.mgmt.GenericProductLineProject;
import net.ssehub.easy.producer.core.mgmt.PLPInfo;
import net.ssehub.easy.producer.core.mgmt.SPLsManager;
import net.ssehub.easy.producer.core.persistence.Configuration;
import net.ssehub.easy.producer.core.persistence.PersistenceException;
import net.ssehub.easy.producer.core.persistence.PersistenceUtils;
import net.ssehub.easy.producer.core.persistence.datatypes.Entity;
import net.ssehub.easy.producer.core.persistence.datatypes.IPersistencer;
import net.ssehub.easy.producer.core.persistence.datatypes.IProjectCreationResult;
import net.ssehub.easy.producer.core.persistence.datatypes.Model;
import net.ssehub.easy.producer.core.persistence.datatypes.ModelType;
import net.ssehub.easy.producer.core.persistence.datatypes.PathEnvironment;
import net.ssehub.easy.producer.core.persistence.datatypes.PersistentProject;
import net.ssehub.easy.producer.core.persistence.standard.PersistenceConstants;
import net.ssehub.easy.producer.core.persistence.standard.Persistencer;
import net.ssehub.easy.producer.core.varMod.container.ProjectContainer;
import net.ssehub.easy.producer.core.varMod.container.ScriptContainer;
import net.ssehub.easy.reasoning.core.reasoner.AttributeException;
import net.ssehub.easy.reasoning.core.reasoner.AttributeValues;
import net.ssehub.easy.reasoning.core.reasoner.ReasonerConfiguration;
import net.ssehub.easy.varModel.model.Project;

public class EASyPersistencer
implements PersistenceConstants {
    private IPersistencer persistencer;

    public EASyPersistencer(File projectFolder) {
        PathEnvironment pathEnv = new PathEnvironment(projectFolder.getParentFile());
        File ivmlFolder = PersistenceUtils.getLocationFile(projectFolder, Configuration.PathKind.IVML);
        this.persistencer = new Persistencer(pathEnv, projectFolder, ivmlFolder.getAbsolutePath(), ProgressObserver.NO_OBSERVER);
    }

    protected EASyPersistencer(IPersistencer persistencer) {
        this.persistencer = persistencer;
    }

    public void refreshConfiguration() {
        File ivmlFolder = PersistenceUtils.getLocationFile(this.getProjectFolder(), Configuration.PathKind.IVML);
        this.persistencer.setStorageFolder(ivmlFolder);
    }

    public PathEnvironment getPathEnvironment() {
        return this.persistencer.getPathEnvironment();
    }

    public File getProjectFolder() {
        return this.persistencer.getProjectFolder();
    }

    public File getEasyConfigFile() {
        return this.persistencer.getEasyConfigFile();
    }

    public PLPInfo load() throws PersistenceException {
        PLPInfo plp = null;
        PersistentProject project = this.persistencer.load();
        plp = this.persistentProject2PLP(project);
        PersistenceUtils.refreshModels(plp);
        return plp;
    }

    public static void refreshModels(PLPInfo plp) {
        PersistenceUtils.refreshModels(plp);
    }

    public static File projectPath(PLPInfo plp) {
        Configuration config = PersistenceUtils.getConfiguration(plp.getProjectLocation());
        File configFolder = config.getPathFile(Configuration.PathKind.IVML, 0);
        String filename = PersistenceUtils.ivmlFileLocation(plp.getProject(), configFolder.getAbsolutePath());
        return new File(filename);
    }

    protected GenericProductLineProject createPLP(String projectID, String projectName, ProjectContainer project, File projectLocation, ScriptContainer mainBuildScript) {
        return new GenericProductLineProject(projectID, projectName, project, projectLocation, mainBuildScript);
    }

    private PLPInfo persistentProject2PLP(PersistentProject project) throws PersistenceException {
        PLPInfo plp = null;
        Model model = project.getModel(ModelType.ROOT);
        String projectID = model.getEntity(0).getAttributes().get("id");
        String projectname = project.getName();
        plp = SPLsManager.INSTANCE.getPLP(projectID);
        if (plp == null || plp.isPreliminary()) {
            File location = project.getLocation();
            ProjectContainer varModel = project.getProject();
            plp = this.createPLP(projectID, projectname, varModel, location, project.getMainBuildScript());
        }
        int i = 0;
        while (i < project.getModelCount()) {
            model = project.getModel(i);
            switch (model.getModelType()) {
                case PREDECESSORS: {
                    plp.getMemberController().setPredecessors(this.model2Relatives(model));
                    break;
                }
                case SUCCESSORS: {
                    plp.getMemberController().setSuccessors(this.model2Relatives(model));
                    break;
                }
                case INSTANTIATORS: {
                    break;
                }
                case REASONERS: {
                    this.createReasonerConfiguration(plp, model);
                    break;
                }
                case SETTINGS: {
                    if (model.getEntityCount() <= 0) break;
                    String debug = model.getEntity(0).getAttributeValue("debug");
                    plp.setSaveDebugInformation(Boolean.valueOf(debug));
                    break;
                }
            }
            ++i;
        }
        if (plp.getProject() != null && plp.getReasonerConfig().getAttributeValues() != null) {
            try {
                plp.getReasonerConfig().getAttributeValues().resolveUsing(plp.getProject(), true);
            }
            catch (AttributeException attributeException) {
                // empty catch block
            }
        }
        return plp;
    }

    private void createReasonerConfiguration(PLPInfo plp, Model model) {
        ReasonerConfiguration reasonerConfig = new ReasonerConfiguration();
        int i = 0;
        while (i < model.getEntityCount()) {
            Entity entity = model.getEntity(i);
            if (entity.getAttributeValue("timeout") != null) {
                reasonerConfig.setTimeout(Integer.valueOf(entity.getAttributeValue("timeout")).intValue());
            }
            if (entity.getAttributeValue("attribute") != null) {
                String attribute = entity.getAttributeValue("attribute");
                String values = entity.getAttributeValue("values");
                if (values != null) {
                    ArrayList<String> attributeValues = new ArrayList<String>();
                    StringTokenizer tokens = new StringTokenizer(values, ";");
                    while (tokens.hasMoreTokens()) {
                        attributeValues.add(tokens.nextToken());
                    }
                    AttributeValues attributes = reasonerConfig.getAttributeValues();
                    if (attributes == null) {
                        attributes = new AttributeValues();
                        reasonerConfig.setAttributeValues(attributes);
                    }
                    attributes.addUnresolved(attribute, attributeValues);
                }
            }
            ++i;
        }
        plp.setReasonerConfig(reasonerConfig);
    }

    private List<PLPInfo> model2Relatives(Model model) {
        LinkedList<PLPInfo> relatives = new LinkedList<PLPInfo>();
        int j = 0;
        while (j < model.getEntityCount()) {
            Entity entity = model.getEntity(j);
            String id = entity.getAttributeValue("id");
            String memberName = entity.getAttributeValue("name");
            String version = entity.getAttributeValue("version");
            String tmp = entity.getAttributeFileString("location");
            File location = tmp != null ? this.persistencer.getPathEnvironment().makeAbsolute(tmp) : null;
            PLPInfo info = SPLsManager.INSTANCE.getPLP(id);
            if (info == null) {
                info = new PLPInfo(id, memberName, version, location);
                SPLsManager.INSTANCE.addPLP(info);
            }
            relatives.add(info);
            ++j;
        }
        return relatives;
    }

    public void save(PLPInfo plp) throws PersistenceException {
        this.persistencer.save(plp);
    }

    public String getProjectID() {
        return this.persistencer.getProjectID();
    }

    public IProjectCreationResult createProject(String projectName, File parentFolder, String projectID, boolean lazy) throws PersistenceException {
        File ivmlFolder = PersistenceUtils.getLocationFile(this.persistencer.getProjectFolder(), Configuration.PathKind.IVML);
        ivmlFolder.mkdirs();
        IProjectCreationResult result = this.persistencer.createProject(projectName, parentFolder, projectID, lazy);
        return result;
    }

    public GenericProductLineProject populateEasyProject(IProjectCreationResult pcr) {
        return this.populateEasyProject(pcr.getProjectID(), pcr.getProjectFolder().getName(), pcr.getProjectFolder(), pcr.getVarModel());
    }

    public GenericProductLineProject populateEasyProject(String projectID, String projectName, File projectFolder, Project ivmlModel) {
        Script mainBuildScript = new Script(projectName, Script.createDefaultParameter());
        Version version = ivmlModel.getVersion();
        if (version != null) {
            mainBuildScript.setVersion(version);
        }
        Configuration location = PersistenceUtils.getConfiguration(projectFolder);
        ProjectContainer varModel = new ProjectContainer(ivmlModel, location);
        ScriptContainer instantiationModel = new ScriptContainer(mainBuildScript, location);
        instantiationModel.setEdited(true);
        return this.createPLP(projectID, projectName, varModel, projectFolder, instantiationModel);
    }
}

