/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.core.varMod.container;

import java.io.File;
import net.ssehub.easy.instantiation.core.model.buildlangModel.AbstractRule;
import net.ssehub.easy.instantiation.core.model.buildlangModel.BuildModel;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Rule;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Script;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.producer.core.persistence.Configuration;
import net.ssehub.easy.producer.core.varMod.container.ModelContainer;
import net.ssehub.easy.producer.core.varMod.container.SemanticErrorDescription;

public class ScriptContainer
extends ModelContainer<Script> {
    private boolean wasEdited;

    public ScriptContainer(Script script, Configuration location) {
        this(script, (SemanticErrorDescription)null, location);
    }

    public ScriptContainer(Script script, SemanticErrorDescription description, Configuration location) {
        this(script, description, location, false);
    }

    public ScriptContainer(Script script, SemanticErrorDescription description, Configuration location, boolean newlyCreated) {
        super(script, description, BuildModel.INSTANCE, location);
        this.wasEdited = newlyCreated;
    }

    public boolean isTransformable() {
        boolean transformable = false;
        Script buildScript = (Script)this.getModel();
        if (buildScript != null) {
            try {
                AbstractRule startRule = buildScript.determineStartRule("main");
                transformable = startRule.getBodyElementCount() > 0 || startRule.hasCondition(Rule.Side.RHS) || startRule.hasCondition(Rule.Side.LHS);
            }
            catch (VilException vilException) {
                // empty catch block
            }
        }
        return transformable;
    }

    @Override
    public File getLocation() {
        return this.getLocation(Configuration.PathKind.VIL);
    }

    @Override
    public boolean isSaveable() {
        return super.isSaveable() && this.wasEdited();
    }

    private boolean wasEdited() {
        return this.wasEdited;
    }

    public void setEdited(boolean wasEdited) {
        this.wasEdited = wasEdited;
    }
}

