/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hildesheim.sse.buildLanguageTranslation;

import de.uni_hildesheim.sse.BuildLangModelUtility;
import de.uni_hildesheim.sse.vil.buildlang.vilBuildLanguage.Alternative;
import de.uni_hildesheim.sse.vil.buildlang.vilBuildLanguage.For;
import de.uni_hildesheim.sse.vil.buildlang.vilBuildLanguage.Instantiate;
import de.uni_hildesheim.sse.vil.buildlang.vilBuildLanguage.Join;
import de.uni_hildesheim.sse.vil.buildlang.vilBuildLanguage.JoinVariable;
import de.uni_hildesheim.sse.vil.buildlang.vilBuildLanguage.LoopVariable;
import de.uni_hildesheim.sse.vil.buildlang.vilBuildLanguage.Map;
import de.uni_hildesheim.sse.vil.buildlang.vilBuildLanguage.PrimaryExpression;
import de.uni_hildesheim.sse.vil.buildlang.vilBuildLanguage.RuleElement;
import de.uni_hildesheim.sse.vil.buildlang.vilBuildLanguage.RuleElementBlock;
import de.uni_hildesheim.sse.vil.buildlang.vilBuildLanguage.StatementOrBlock;
import de.uni_hildesheim.sse.vil.buildlang.vilBuildLanguage.SystemExecution;
import de.uni_hildesheim.sse.vil.buildlang.vilBuildLanguage.VilBuildLanguagePackage;
import de.uni_hildesheim.sse.vil.buildlang.vilBuildLanguage.While;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.Call;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.ExpressionDslPackage;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.ExpressionStatement;
import de.uni_hildesheim.sse.vil.expressions.expressionDsl.NamedArgument;
import de.uni_hildesheim.sse.vil.expressions.translation.ExpressionTranslator;
import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.basics.messages.IIdentifiable;
import net.ssehub.easy.basics.messages.IMessageHandler;
import net.ssehub.easy.basics.modelManagement.IVersionRestriction;
import net.ssehub.easy.basics.modelManagement.RestrictionEvaluationException;
import net.ssehub.easy.dslCore.translation.IMessageReceiver;
import net.ssehub.easy.dslCore.translation.MessageHandler;
import net.ssehub.easy.dslCore.translation.MessageReceiver;
import net.ssehub.easy.dslCore.translation.StringUtils;
import net.ssehub.easy.dslCore.translation.TranslatorException;
import net.ssehub.easy.instantiation.core.model.buildlangModel.AlternativeExpression;
import net.ssehub.easy.instantiation.core.model.buildlangModel.ExpressionVersionRestriction;
import net.ssehub.easy.instantiation.core.model.buildlangModel.ForStatement;
import net.ssehub.easy.instantiation.core.model.buildlangModel.IRuleBlock;
import net.ssehub.easy.instantiation.core.model.buildlangModel.IRuleElement;
import net.ssehub.easy.instantiation.core.model.buildlangModel.ImplicitVariableDeclaration;
import net.ssehub.easy.instantiation.core.model.buildlangModel.InstantiateExpression;
import net.ssehub.easy.instantiation.core.model.buildlangModel.JoinExpression;
import net.ssehub.easy.instantiation.core.model.buildlangModel.JoinVariableDeclaration;
import net.ssehub.easy.instantiation.core.model.buildlangModel.MapExpression;
import net.ssehub.easy.instantiation.core.model.buildlangModel.NestedRuleBlock;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Resolver;
import net.ssehub.easy.instantiation.core.model.buildlangModel.SimpleStatementBlock;
import net.ssehub.easy.instantiation.core.model.buildlangModel.StrategyCallExpression;
import net.ssehub.easy.instantiation.core.model.buildlangModel.VariableDeclaration;
import net.ssehub.easy.instantiation.core.model.buildlangModel.WhileStatement;
import net.ssehub.easy.instantiation.core.model.common.ModelCallExpression;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.AbstractCallExpression;
import net.ssehub.easy.instantiation.core.model.expressions.CallArgument;
import net.ssehub.easy.instantiation.core.model.expressions.CallExpression;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.expressions.ExpressionVersionRestrictionValidator;
import net.ssehub.easy.instantiation.core.model.expressions.IExpressionVisitor;
import net.ssehub.easy.instantiation.core.model.expressions.IResolvable;
import net.ssehub.easy.instantiation.core.model.expressions.ResolvableOperationCallExpression;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlTypes;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ExpressionTranslator
extends de.uni_hildesheim.sse.vil.expressions.translation.ExpressionTranslator<VariableDeclaration, Resolver, net.ssehub.easy.instantiation.core.model.buildlangModel.ExpressionStatement> {
    public Expression processPrimaryExpression(de.uni_hildesheim.sse.vil.expressions.expressionDsl.PrimaryExpression ex, Resolver resolver) throws TranslatorException {
        Expression result = null;
        if (ex != null) {
            result = super.processPrimaryExpression(ex, (net.ssehub.easy.instantiation.core.model.expressions.Resolver)resolver);
            PrimaryExpression pEx = (PrimaryExpression)ex;
            SystemExecution systemEx = pEx.getSysEx();
            if (systemEx != null) {
                result = this.processCall(null, systemEx.getCall(), ExpressionTranslator.CallType.SYSTEM, null, resolver);
                result = this.processSubCalls(result, systemEx.getCalls(), (net.ssehub.easy.instantiation.core.model.expressions.Resolver)resolver);
            }
            if (pEx.getJoin() != null) {
                result = this.processJoin(pEx.getJoin(), resolver);
            }
            if (pEx.getMap() != null) {
                result = this.processMap(pEx.getMap(), resolver);
            }
            if (pEx.getInstantiate() != null) {
                result = this.processInstantiate(pEx.getInstantiate(), resolver);
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private InstantiateExpression processInstantiate(Instantiate inst, Resolver resolver) throws TranslatorException {
        ArrayList<CallArgument> arguments = new ArrayList<CallArgument>();
        if (inst.getParam() != null) {
            for (NamedArgument param : inst.getParam().getParam()) {
                arguments.add(new CallArgument(param.getName(), this.processExpression(param.getEx(), (net.ssehub.easy.instantiation.core.model.expressions.Resolver)resolver)));
            }
        }
        CallArgument[] args = new CallArgument[arguments.size()];
        arguments.toArray(args);
        VariableDeclaration var = null;
        if (inst.getProject() != null) {
            var = (VariableDeclaration)resolver.resolve(inst.getProject(), false, (EObject)inst, (EStructuralFeature)VilBuildLanguagePackage.Literals.INSTANTIATE__PROJECT, (IMessageReceiver)this);
            if (var == null) throw new TranslatorException("cannot resolve " + inst.getProject(), (EObject)inst, (EStructuralFeature)VilBuildLanguagePackage.Literals.INSTANTIATE__PROJECT, 70002);
            if (!IvmlTypes.projectType().isAssignableFrom(var.getType())) {
                throw new TranslatorException(inst.getProject() + " is not of type Project", (EObject)inst, (EStructuralFeature)VilBuildLanguagePackage.Literals.INSTANTIATE__PROJECT, 20203);
            }
        } else if (StringUtils.convertString((String)inst.getRuleName()).length() == 0) {
            throw new TranslatorException("the rule name must not be empty", (EObject)inst, (EStructuralFeature)VilBuildLanguagePackage.Literals.INSTANTIATE__PROJECT, 20207);
        }
        try {
            if (inst.getProject() == null) return new InstantiateExpression(StringUtils.convertString((String)inst.getRuleName()), args);
            IVersionRestriction vRestrict = null;
            if (inst.getVersionSpec() == null) return new InstantiateExpression(var, vRestrict, null, args);
            this.warnVersionRestrictions(inst.getVersionSpec());
            vRestrict = this.processRestriction(inst.getProject(), inst.getVersionSpec(), (net.ssehub.easy.instantiation.core.model.expressions.Resolver)resolver);
            return new InstantiateExpression(var, vRestrict, null, args);
        }
        catch (VilException e) {
            throw new TranslatorException((IIdentifiable)e, (EObject)inst, (EStructuralFeature)VilBuildLanguagePackage.Literals.INSTANTIATE__PARAM);
        }
    }

    private AlternativeExpression processAlternative(Alternative alt, Resolver resolver) throws TranslatorException {
        try {
            Expression cond = this.processExpression(alt.getExpr(), (net.ssehub.easy.instantiation.core.model.expressions.Resolver)resolver);
            cond = this.assertBooleanExpression(cond, alt, (EStructuralFeature)VilBuildLanguagePackage.Literals.ALTERNATIVE__EXPR);
            resolver.pushLevel();
            IRuleBlock ifBlock = this.resolveStatementOrBlock(alt.getIf(), resolver);
            resolver.popLevel();
            resolver.pushLevel();
            IRuleBlock elseBlock = this.resolveStatementOrBlock(alt.getElse(), resolver);
            resolver.popLevel();
            return new AlternativeExpression(cond, ifBlock, elseBlock);
        }
        catch (VilException e) {
            throw new TranslatorException((IIdentifiable)e, (EObject)alt, (EStructuralFeature)VilBuildLanguagePackage.Literals.ALTERNATIVE__IF);
        }
    }

    private WhileStatement processWhileStatement(While stmt, Resolver resolver) throws TranslatorException {
        Expression expr = this.processExpression(stmt.getExpr(), (net.ssehub.easy.instantiation.core.model.expressions.Resolver)resolver);
        expr = this.assertBooleanExpression(expr, stmt, (EStructuralFeature)VilBuildLanguagePackage.Literals.MAP__EXPR);
        resolver.pushLevel();
        IRuleElement[] block = this.resolveBlock(stmt.getBlock(), resolver);
        resolver.popLevel();
        try {
            return new WhileStatement(expr, block);
        }
        catch (VilException e) {
            throw new TranslatorException((IIdentifiable)e, (EObject)stmt, (EStructuralFeature)VilBuildLanguagePackage.Literals.WHILE__EXPR);
        }
    }

    private ForStatement processForStatement(For stmt, Resolver resolver) throws TranslatorException {
        Expression expr = this.processExpression(stmt.getExpr(), (net.ssehub.easy.instantiation.core.model.expressions.Resolver)resolver);
        TypeDescriptor type = null;
        try {
            type = expr.inferType();
        }
        catch (VilException e) {
            throw new TranslatorException((IIdentifiable)e, (EObject)stmt, (EStructuralFeature)VilBuildLanguagePackage.Literals.FOR__EXPR);
        }
        if (!type.isCollection() && !type.isIterator()) {
            OperationDescriptor conversion = type.getConversionToSequence();
            if (conversion == null) {
                throw new TranslatorException("for must run over collection", (EObject)stmt, (EStructuralFeature)VilBuildLanguagePackage.Literals.FOR__EXPR, 20203);
            }
            type = conversion.getReturnType();
        }
        EList<LoopVariable> vars = stmt.getVar();
        if (type.getGenericParameterCount() != vars.size()) {
            throw new TranslatorException("number of for variables does not comply with expression", (EObject)stmt, (EStructuralFeature)VilBuildLanguagePackage.Literals.FOR__EXPR, 20203);
        }
        int vSize = vars.size();
        VariableDeclaration[] mapVars = new VariableDeclaration[vSize];
        TypeDescriptor[] givenTypes = TypeDescriptor.createArray((int)vSize);
        int i = 0;
        while (i < vars.size()) {
            LoopVariable mv = (LoopVariable)vars.get(i);
            TypeDescriptor varType = type.getGenericParameterType(i);
            if (mv.getType() != null) {
                givenTypes[i] = this.processType(mv.getType(), (net.ssehub.easy.instantiation.core.model.expressions.Resolver)resolver);
                if (!givenTypes[i].isAssignableFrom(varType) && varType.findConversion(varType, givenTypes[i]) == null) {
                    throw new TranslatorException("explicitly given type '" + givenTypes[i].getVilName() + "'of for iterator variable '" + mv.getVar() + "' does not match inferred type '" + varType.getVilName() + "'", (EObject)mv, (EStructuralFeature)VilBuildLanguagePackage.Literals.LOOP_VARIABLE__TYPE, 20203);
                }
                varType = givenTypes[i];
            }
            mapVars[i] = new VariableDeclaration(mv.getVar(), varType);
            ++i;
        }
        resolver.pushLevel();
        resolver.add((IResolvable[])mapVars);
        IRuleElement[] block = this.resolveBlock(stmt.getBlock(), resolver);
        resolver.popLevel();
        try {
            return new ForStatement(mapVars, expr, block, givenTypes, stmt.getSeparator().equals(":"));
        }
        catch (VilException e) {
            throw new TranslatorException((IIdentifiable)e, (EObject)stmt, (EStructuralFeature)VilBuildLanguagePackage.Literals.FOR__VAR);
        }
    }

    private MapExpression processMap(Map map, Resolver resolver) throws TranslatorException {
        Expression expr = this.processExpression(map.getExpr(), (net.ssehub.easy.instantiation.core.model.expressions.Resolver)resolver);
        TypeDescriptor type = null;
        try {
            type = expr.inferType();
        }
        catch (VilException e) {
            throw new TranslatorException((IIdentifiable)e, (EObject)map, (EStructuralFeature)VilBuildLanguagePackage.Literals.MAP__EXPR);
        }
        if (!type.isCollection() && !type.isIterator()) {
            OperationDescriptor conversion = type.getConversionToSequence();
            if (conversion == null) {
                throw new TranslatorException("map must run over collection", (EObject)map, (EStructuralFeature)VilBuildLanguagePackage.Literals.MAP__EXPR, 20203);
            }
            type = conversion.getReturnType();
        }
        EList<LoopVariable> vars = map.getVar();
        if (type.getGenericParameterCount() != vars.size()) {
            throw new TranslatorException("number of map variables does not comply with expression", (EObject)map, (EStructuralFeature)VilBuildLanguagePackage.Literals.MAP__EXPR, 20203);
        }
        int vSize = vars.size();
        VariableDeclaration[] mapVars = new VariableDeclaration[vSize];
        TypeDescriptor[] givenTypes = TypeDescriptor.createArray((int)vSize);
        int i = 0;
        while (i < vars.size()) {
            LoopVariable mv = (LoopVariable)vars.get(i);
            TypeDescriptor varType = type.getGenericParameterType(i);
            if (mv.getType() != null) {
                givenTypes[i] = this.processType(mv.getType(), (net.ssehub.easy.instantiation.core.model.expressions.Resolver)resolver);
                if (!givenTypes[i].isAssignableFrom(varType) && varType.findConversion(varType, givenTypes[i]) == null) {
                    throw new TranslatorException("explicitly given type '" + givenTypes[i].getVilName() + "'of map variable '" + mv.getVar() + "' does not match inferred type '" + varType.getVilName() + "'", (EObject)mv, (EStructuralFeature)VilBuildLanguagePackage.Literals.LOOP_VARIABLE__TYPE, 20203);
                }
                varType = givenTypes[i];
            }
            mapVars[i] = new VariableDeclaration(mv.getVar(), varType);
            ++i;
        }
        resolver.pushLevel();
        resolver.limitVariablesOnCurrentLevel();
        resolver.add((IResolvable[])mapVars);
        IRuleElement[] block = this.resolveBlock(map.getBlock(), resolver);
        resolver.popLevel();
        try {
            return new MapExpression(mapVars, expr, block, givenTypes, map.getSeparator().equals(":"));
        }
        catch (VilException e) {
            throw new TranslatorException((IIdentifiable)e, (EObject)map, (EStructuralFeature)VilBuildLanguagePackage.Literals.MAP__VAR);
        }
    }

    private IRuleBlock resolveStatementOrBlock(StatementOrBlock part, Resolver resolver) throws TranslatorException {
        NestedRuleBlock result = null;
        if (part != null) {
            if (part.getBlock() != null) {
                result = new NestedRuleBlock(this.resolveBlock(part.getBlock(), resolver));
            } else if (part.getExStmt() != null) {
                result = new SimpleStatementBlock((IRuleElement)this.processExpressionStatement(part.getExStmt(), resolver));
            }
        }
        return result;
    }

    public IRuleElement[] resolveBlock(RuleElementBlock block, Resolver resolver) {
        IRuleElement[] result = null;
        if (block != null && block.getElements() != null) {
            result = this.resolveBlock((List<? extends RuleElement>)block.getElements(), resolver);
        }
        return result;
    }

    public IRuleElement[] resolveBlock(List<? extends RuleElement> block, Resolver resolver) {
        IRuleElement[] result = null;
        if (block != null) {
            ArrayList<Object> tmp = new ArrayList<Object>();
            for (RuleElement ruleElement : block) {
                try {
                    if (ruleElement.getExprStmt() != null) {
                        tmp.add(this.processExpressionStatement(ruleElement.getExprStmt(), resolver));
                        continue;
                    }
                    if (ruleElement.getVarDecl() != null) {
                        tmp.add((IRuleElement)this.processVariableDeclaration(ruleElement.getVarDecl(), (net.ssehub.easy.instantiation.core.model.expressions.Resolver)resolver));
                        continue;
                    }
                    if (ruleElement.getFor() != null) {
                        tmp.add(this.processForStatement(ruleElement.getFor(), resolver));
                        continue;
                    }
                    if (ruleElement.getWhile() != null) {
                        tmp.add(this.processWhileStatement(ruleElement.getWhile(), resolver));
                        continue;
                    }
                    IRuleElement rElt = this.resolveRuleElement(ruleElement, resolver);
                    if (rElt == null) continue;
                    tmp.add(rElt);
                }
                catch (TranslatorException e) {
                    this.error(e);
                }
            }
            if (!tmp.isEmpty()) {
                result = new IRuleElement[tmp.size()];
                tmp.toArray(result);
            }
        }
        return result;
    }

    protected IRuleElement resolveRuleElement(RuleElement elt, Resolver resolver) throws TranslatorException {
        return null;
    }

    protected net.ssehub.easy.instantiation.core.model.buildlangModel.ExpressionStatement createExpressionStatement(Expression expression, Resolver resolver) {
        return new net.ssehub.easy.instantiation.core.model.buildlangModel.ExpressionStatement(expression);
    }

    public net.ssehub.easy.instantiation.core.model.buildlangModel.ExpressionStatement processExpressionStatement(de.uni_hildesheim.sse.vil.buildlang.vilBuildLanguage.ExpressionStatement expr, Resolver resolver) throws TranslatorException {
        net.ssehub.easy.instantiation.core.model.buildlangModel.ExpressionStatement result = expr.getAlt() != null ? this.createExpressionStatement((Expression)this.processAlternative(expr.getAlt(), resolver), resolver) : (net.ssehub.easy.instantiation.core.model.buildlangModel.ExpressionStatement)super.processExpressionStatement((ExpressionStatement)expr, (net.ssehub.easy.instantiation.core.model.expressions.Resolver)resolver);
        return result;
    }

    protected JoinExpression processJoin(Join join, Resolver resolver) throws TranslatorException {
        JoinVariableDeclaration[] vars = new JoinVariableDeclaration[]{this.processJoinVariable(join.getVar1(), resolver), this.processJoinVariable(join.getVar2(), resolver)};
        Expression condition = null;
        if (join.getCondition() != null) {
            resolver.pushLevel();
            int i = 0;
            while (i < vars.length) {
                resolver.add((IResolvable)vars[i]);
                ++i;
            }
            try {
                condition = this.processExpression(join.getCondition(), (net.ssehub.easy.instantiation.core.model.expressions.Resolver)resolver);
            }
            finally {
                resolver.popLevel();
            }
        }
        try {
            return new JoinExpression(vars, condition);
        }
        catch (VilException e) {
            throw new TranslatorException((IIdentifiable)e, (EObject)join, (EStructuralFeature)VilBuildLanguagePackage.Literals.JOIN__CONDITION);
        }
    }

    protected JoinVariableDeclaration processJoinVariable(JoinVariable var, Resolver resolver) throws TranslatorException {
        Expression ex = this.processExpression(var.getExpr(), (net.ssehub.easy.instantiation.core.model.expressions.Resolver)resolver);
        try {
            return new JoinVariableDeclaration(var.getVar(), ex, var.getExcl() != null);
        }
        catch (VilException e) {
            throw new TranslatorException((IIdentifiable)e, (EObject)var, (EStructuralFeature)VilBuildLanguagePackage.Literals.JOIN_VARIABLE__VAR);
        }
    }

    protected Expression processCall(Expression firstParam, Call call, ExpressionTranslator.CallType type, de.uni_hildesheim.sse.vil.expressions.expressionDsl.Expression arrayEx, Resolver resolver) throws TranslatorException {
        VariableDeclaration opVar;
        ModelCallExpression result;
        ArrayList<CallArgument> arguments = new ArrayList<CallArgument>();
        if (firstParam != null) {
            arguments.add(new CallArgument(firstParam));
        }
        List varDecls = this.resolveIteratorDeclarations(call, type, arguments, (net.ssehub.easy.instantiation.core.model.expressions.Resolver)resolver);
        String name = this.resolveCallArguments(call, varDecls, arguments, arrayEx, (net.ssehub.easy.instantiation.core.model.expressions.Resolver)resolver);
        CallArgument[] arg = new CallArgument[arguments.size()];
        arguments.toArray(arg);
        if (ExpressionTranslator.CallType.SYSTEM == type) {
            try {
                VariableDeclaration nameVar = (VariableDeclaration)resolver.resolve(name, false, (EObject)call, (EStructuralFeature)ExpressionDslPackage.Literals.CALL__NAME, (IMessageReceiver)this);
                if (nameVar == null) {
                    throw new TranslatorException("cannot resolve variable " + String.valueOf(nameVar), (EObject)call, (EStructuralFeature)ExpressionDslPackage.Literals.CALL__NAME, 20207);
                }
                result = new StrategyCallExpression(nameVar, arg);
                result.inferType();
            }
            catch (VilException e) {
                throw new TranslatorException((IIdentifiable)e, (EObject)call, (EStructuralFeature)ExpressionDslPackage.Literals.CALL__NAME);
            }
        }
        result = null;
        VilException semanticException = null;
        try {
            result = resolver.createCallExpression(ExpressionTranslator.CallType.SUPER == type, name, arg);
        }
        catch (VilException e) {
            semanticException = e;
        }
        if ((result == null || this.continueResolution(semanticException)) && Resolver.ContextType.RULE_BODY == resolver.getContextType()) {
            try {
                StrategyCallExpression sce = new StrategyCallExpression((Object)resolver.getCurrentModel(), name, arg);
                sce.setTypeRegistry(resolver.getTypeRegistry());
                result = sce;
                semanticException = this.checkSemantics((Expression)result);
            }
            catch (VilException sce) {
                // empty catch block
            }
        }
        if (result == null || this.continueResolution(semanticException)) {
            try {
                result = new CallExpression(null, name, arg);
                semanticException = this.checkSemantics((Expression)result);
            }
            catch (VilException sce) {
                // empty catch block
            }
        }
        if ((result == null || this.continueResolution(semanticException)) && (opVar = (VariableDeclaration)resolver.resolve(name, false)) != null) {
            try {
                result = new ResolvableOperationCallExpression((net.ssehub.easy.instantiation.core.model.common.VariableDeclaration)opVar, arg);
                semanticException = this.checkSemantics((Expression)result);
            }
            catch (VilException vilException) {
                // empty catch block
            }
        }
        if (semanticException != null) {
            throw new TranslatorException((IIdentifiable)semanticException, (EObject)call, (EStructuralFeature)ExpressionDslPackage.Literals.CALL__NAME);
        }
        return this.checkCallExpression((AbstractCallExpression)result, type, call);
    }

    protected VariableDeclaration createVariableDeclaration(String name, TypeDescriptor<?> type, boolean isConstant, Expression expression, Resolver resolver) {
        return new VariableDeclaration(name, type, isConstant, expression);
    }

    protected VariableDeclaration createImplicitVariableDeclaration(String name, TypeDescriptor<?> type, boolean isConstant, Expression expression, Resolver resolver) {
        return new ImplicitVariableDeclaration(name, type, isConstant, expression);
    }

    protected net.ssehub.easy.instantiation.core.model.expressions.ExpressionVersionRestriction createExpressionVersionRestriction(Expression expr, net.ssehub.easy.instantiation.core.model.common.VariableDeclaration decl, EObject cause, EStructuralFeature feature) throws RestrictionEvaluationException {
        try {
            ExpressionVersionRestrictionValidator validator = new ExpressionVersionRestrictionValidator((IMessageHandler)new MessageHandler((MessageReceiver)this, cause, feature));
            expr.accept((IExpressionVisitor)validator);
            return new ExpressionVersionRestriction(expr, decl);
        }
        catch (VilException e) {
            throw new RestrictionEvaluationException(e.getMessage(), e.getId());
        }
    }

    public Expression parseExpression(String expression, Resolver resolver, StringBuilder warnings) throws VilException {
        return BuildLangModelUtility.INSTANCE.createExpression(expression, resolver, warnings);
    }

    protected String cannotAssignHint() {
        return "VIL cannot assign values to configurable elements.";
    }
}

