/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.cstEvaluation;

import net.ssehub.easy.varModel.cstEvaluation.ConstantAccessor;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationAccessor;
import net.ssehub.easy.varModel.cstEvaluation.EvaluatorRegistry;
import net.ssehub.easy.varModel.cstEvaluation.GenericOperations;
import net.ssehub.easy.varModel.cstEvaluation.IOperationEvaluator;
import net.ssehub.easy.varModel.model.datatypes.Enum;
import net.ssehub.easy.varModel.model.datatypes.EnumLiteral;
import net.ssehub.easy.varModel.model.datatypes.IntegerType;
import net.ssehub.easy.varModel.model.datatypes.OrderedEnum;
import net.ssehub.easy.varModel.model.values.BooleanValue;
import net.ssehub.easy.varModel.model.values.EnumValue;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;
import net.ssehub.easy.varModel.model.values.ValueFactory;

public class EnumOperations {
    static final IOperationEvaluator ORDINAL = new IOperationEvaluator(){

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            ConstantAccessor result = null;
            Value val = operand.getValue();
            if (val instanceof EnumValue) {
                EnumValue eVal = (EnumValue)val;
                EnumLiteral lit = eVal.getValue();
                try {
                    Value res = ValueFactory.createValue(IntegerType.TYPE, lit.getOrdinal());
                    result = ((ConstantAccessor)ConstantAccessor.POOL.getInstance()).bind(res, true, operand.getContext());
                }
                catch (ValueDoesNotMatchTypeException valueDoesNotMatchTypeException) {
                    // empty catch block
                }
            }
            return result;
        }
    };

    private EnumOperations() {
    }

    public static final void register() {
        EvaluatorRegistry.registerEvaluator(GenericOperations.TYPE_OF, Enum.TYPE_OF);
        EvaluatorRegistry.registerEvaluator(GenericOperations.EQUALS, Enum.EQUALS);
        EvaluatorRegistry.registerEvaluator(GenericOperations.UNEQUALS, Enum.NOTEQUALS, Enum.NOTEQUALS_ALIAS);
        EvaluatorRegistry.registerEvaluator(GenericOperations.ASSIGNMENT, Enum.ASSIGNMENT);
        EvaluatorRegistry.registerEvaluator(GenericOperations.IS_DEFINED, Enum.IS_DEFINED);
        EvaluatorRegistry.registerEvaluator(GenericOperations.IF_DEFINED, Enum.IF_DEFINED);
        EvaluatorRegistry.registerEvaluator(ORDINAL, Enum.ORDINAL);
        EvaluatorRegistry.registerEvaluator(new EnumComparisonOperation(new BinaryEnumComparisonOperation(){

            @Override
            public boolean evaluate(EnumLiteral e1, EnumLiteral e2) {
                return e1.getOrdinal() > e2.getOrdinal();
            }
        }), OrderedEnum.GREATER);
        EvaluatorRegistry.registerEvaluator(new EnumComparisonOperation(new BinaryEnumComparisonOperation(){

            @Override
            public boolean evaluate(EnumLiteral e1, EnumLiteral e2) {
                return e1.getOrdinal() >= e2.getOrdinal();
            }
        }), OrderedEnum.GREATER_EQUALS);
        EvaluatorRegistry.registerEvaluator(new EnumComparisonOperation(new BinaryEnumComparisonOperation(){

            @Override
            public boolean evaluate(EnumLiteral e1, EnumLiteral e2) {
                return e1.getOrdinal() < e2.getOrdinal();
            }
        }), OrderedEnum.LESS);
        EvaluatorRegistry.registerEvaluator(new EnumComparisonOperation(new BinaryEnumComparisonOperation(){

            @Override
            public boolean evaluate(EnumLiteral e1, EnumLiteral e2) {
                return e1.getOrdinal() <= e2.getOrdinal();
            }
        }), OrderedEnum.LESS_EQUALS);
        EvaluatorRegistry.registerEvaluator(new MinMaxEvaluator(true), OrderedEnum.MIN);
        EvaluatorRegistry.registerEvaluator(new MinMaxEvaluator(false), OrderedEnum.MAX);
    }

    private static interface BinaryEnumComparisonOperation {
        public boolean evaluate(EnumLiteral var1, EnumLiteral var2);
    }

    private static class EnumComparisonOperation
    implements IOperationEvaluator {
        private BinaryEnumComparisonOperation op;

        EnumComparisonOperation(BinaryEnumComparisonOperation op) {
            this.op = op;
        }

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            ConstantAccessor result = null;
            if (1 == arguments.length) {
                Value opVal = operand.getValue();
                Value aVal = arguments[0].getValue();
                if (opVal instanceof EnumValue && aVal instanceof EnumValue && opVal.getType() == aVal.getType()) {
                    boolean tmp = this.op.evaluate(((EnumValue)opVal).getValue(), ((EnumValue)aVal).getValue());
                    BooleanValue rVal = BooleanValue.toBooleanValue(tmp);
                    result = ((ConstantAccessor)ConstantAccessor.POOL.getInstance()).bind(rVal, true, operand.getContext());
                }
            }
            return result;
        }
    }

    static class MinMaxEvaluator
    implements IOperationEvaluator {
        private boolean min;

        private MinMaxEvaluator(boolean min) {
            this.min = min;
        }

        @Override
        public EvaluationAccessor evaluate(EvaluationAccessor operand, EvaluationAccessor[] arguments) {
            ConstantAccessor result = null;
            if (1 == arguments.length) {
                Value opVal = operand.getValue();
                Value aVal = arguments[0].getValue();
                if (opVal instanceof EnumValue && aVal instanceof EnumValue && opVal.getType() == aVal.getType()) {
                    EnumLiteral opLit = ((EnumValue)opVal).getValue();
                    EnumLiteral aLit = ((EnumValue)aVal).getValue();
                    EnumLiteral res = this.min ? (opLit.getOrdinal() <= aLit.getOrdinal() ? opLit : aLit) : (opLit.getOrdinal() >= aLit.getOrdinal() ? opLit : aLit);
                    try {
                        Value resVal = ValueFactory.createValue(opVal.getType(), res);
                        result = ((ConstantAccessor)ConstantAccessor.POOL.getInstance()).bind(resVal, true, operand.getContext());
                    }
                    catch (ValueDoesNotMatchTypeException valueDoesNotMatchTypeException) {
                        // empty catch block
                    }
                }
            }
            return result;
        }
    }
}

