/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.management;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.IModelManagementRepository;
import net.ssehub.easy.basics.modelManagement.ModelInfo;
import net.ssehub.easy.basics.modelManagement.Utils;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.management.CommentResource;
import net.ssehub.easy.varModel.management.VarModel;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.ContainableModelElement;
import net.ssehub.easy.varModel.model.IDecisionVariableContainer;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.ProjectImport;
import net.ssehub.easy.varModel.persistency.StringProvider;

public class ModelCommentsPersistencer {
    private IModelManagementRepository<Project> repository;

    ModelCommentsPersistencer(IModelManagementRepository<Project> repository) {
        this.repository = repository;
    }

    public synchronized boolean storeComments(ModelInfo<Project> info) throws IOException {
        return this.storeComments(info, false);
    }

    public synchronized boolean storeComments(ModelInfo<Project> info, boolean considerImports) throws IOException {
        URI resourceUri;
        boolean done = false;
        Project project = (Project)info.getResolved();
        if (project != null && (resourceUri = info.getCommentsResource()) != null) {
            File resourceFile = new File(resourceUri);
            CommentResource props = new CommentResource();
            int size = project.getElementCount();
            int c = 0;
            while (c < size) {
                ContainableModelElement element = project.getElement(c);
                String qName = element.getQualifiedName();
                if (qName != null) {
                    props.put(qName, element.getComment());
                }
                ++c;
            }
            FileWriter fw = new FileWriter(resourceFile);
            try {
                props.store(fw);
            }
            catch (IOException e) {
                try {
                    fw.close();
                }
                catch (IOException qName) {
                    // empty catch block
                }
                throw e;
            }
            fw.close();
            size = project.getImportsCount();
            int i = 0;
            while (i < size) {
                ProjectImport imp = project.getImport(i);
                if (!imp.isConflict()) {
                    this.storeComments((ModelInfo<Project>)this.repository.getResolvedModelInfo((IModel)((Project)imp.getResolved())));
                }
                ++i;
            }
            done = true;
        }
        return done;
    }

    void loadComments(ModelInfo<Project> info) throws IOException {
        CommentResource props;
        Project project = (Project)info.getResolved();
        if (project != null && (props = ModelCommentsPersistencer.getComments(info)) != null) {
            this.assignCommentsToProject(project, props);
        }
    }

    public static CommentResource getComments(Project project) throws IOException {
        ModelInfo info;
        CommentResource props = null;
        if (project != null && (info = VarModel.INSTANCE.availableModels().getModelInfo((IModel)project)) != null) {
            props = ModelCommentsPersistencer.getComments((ModelInfo<Project>)info);
        }
        return props;
    }

    private static CommentResource getComments(ModelInfo<Project> info) throws IOException {
        File baseFile;
        CommentResource props = null;
        File resourceFile = Utils.toExistingFile((URI)info.getCommentsResource());
        if (resourceFile == null) {
            resourceFile = Utils.toExistingFile((URI)info.getDefaultCommentsResource());
        }
        if ((baseFile = Utils.toExistingFile((URI)info.getBaseCommentsResource())) == null) {
            baseFile = Utils.toExistingFile((URI)info.getDefaultBaseCommentsResource());
        }
        if (resourceFile != null || baseFile != null) {
            props = new CommentResource();
            ModelCommentsPersistencer.readResourceFromFile(props, baseFile);
            ModelCommentsPersistencer.readResourceFromFile(props, resourceFile);
        }
        return props;
    }

    private static void readResourceFromFile(CommentResource resource, File file) throws IOException {
        if (file != null) {
            FileReader fr = new FileReader(file);
            try {
                resource.load(fr);
            }
            catch (IOException e) {
                try {
                    fr.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw e;
            }
            fr.close();
        }
    }

    private void assignCommentsToProject(Project project, CommentResource props) {
        int size = project.getElementCount();
        int c = 0;
        while (c < size) {
            ContainableModelElement element = project.getElement(c);
            this.assignComment(element, props);
            if (element instanceof IDecisionVariableContainer) {
                this.assignComments((IDecisionVariableContainer)((Object)element), props);
            }
            ++c;
        }
    }

    private void assignComments(IDecisionVariableContainer container, CommentResource props) {
        int e = 0;
        while (e < container.getElementCount()) {
            this.assignComment(container.getElement(e), props);
            ++e;
        }
        int a = 0;
        while (a < container.getAssignmentCount()) {
            this.assignComments(container.getAssignment(a), props);
            ++a;
        }
    }

    private void assignComment(ContainableModelElement elt, CommentResource props) {
        String tmp;
        String comment = "";
        String qName = elt.getQualifiedName();
        if (elt instanceof Constraint) {
            qName = ModelCommentsPersistencer.getKey((Constraint)elt);
        }
        if (qName != null && (tmp = props.get(qName)) != null) {
            comment = tmp;
        }
        elt.setComment(comment);
    }

    public static String getKey(Constraint cons) {
        ConstraintSyntaxTree cst;
        String key = "";
        if (cons != null && (cst = cons.getConsSyntax()) != null) {
            key = StringProvider.toIvmlString(cst).replace(" ", "").replace("=", "\\=");
        }
        return key;
    }
}

