/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.varModel.model.filter;

import net.ssehub.easy.varModel.model.AbstractProjectVisitor;
import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.AttributeAssignment;
import net.ssehub.easy.varModel.model.Comment;
import net.ssehub.easy.varModel.model.CompoundAccessStatement;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.FreezeBlock;
import net.ssehub.easy.varModel.model.IFreezable;
import net.ssehub.easy.varModel.model.OperationDefinition;
import net.ssehub.easy.varModel.model.PartialEvaluationBlock;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.ProjectInterface;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.datatypes.Enum;
import net.ssehub.easy.varModel.model.datatypes.EnumLiteral;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.OrderedEnum;
import net.ssehub.easy.varModel.model.datatypes.Reference;
import net.ssehub.easy.varModel.model.datatypes.Sequence;
import net.ssehub.easy.varModel.model.datatypes.Set;
import net.ssehub.easy.varModel.model.filter.FilterType;
import net.ssehub.easy.varModel.persistency.StringProvider;

public class ModelElementTypeFinder
extends AbstractProjectVisitor {
    private static final String DECISION_VARIABLE_TYPE = "DecisionVariableDeclaration";
    private static final String ENUM_TYPE = "enum";
    private static final String COMPOUND_TYPE = "compound";
    private static final String MAPPING_TYPE = "DerivedDatatype";
    private ModelElementDescription elementTypeDescription;
    private Project targetProject;
    private String searchElementName;

    public ModelElementTypeFinder(Project originProject, FilterType filterType) {
        super(originProject, filterType);
        this.targetProject = originProject;
    }

    public ModelElementDescription getDatatypeByElementName(String elementName) {
        ModelElementDescription elementDescription = null;
        if (this.targetProject != null && elementName != null && !elementName.isEmpty()) {
            this.searchElementName = elementName;
            this.targetProject.accept(this);
            elementDescription = this.elementTypeDescription;
        }
        return elementDescription;
    }

    @Override
    public void visitDecisionVariableDeclaration(DecisionVariableDeclaration decl) {
        IDatatype foundType;
        if (decl.getName() != null && decl.getName().equals(this.searchElementName) && (foundType = decl.getType()) != null) {
            String fullType = StringProvider.toIvmlString(foundType);
            this.elementTypeDescription = new ModelElementDescription(this.searchElementName, fullType, ClassType.DECISION_VARIABLE_DECLARATION);
        }
    }

    @Override
    public void visitAttribute(Attribute attribute) {
    }

    @Override
    public void visitConstraint(Constraint constraint) {
    }

    @Override
    public void visitFreezeBlock(FreezeBlock freeze) {
        int freezableCounter = 0;
        boolean matchingFreezableFound = false;
        while (!matchingFreezableFound && freezableCounter < freeze.getFreezableCount()) {
            IFreezable currentFreezable = freeze.getFreezable(freezableCounter);
            if (currentFreezable.getName() != null && currentFreezable.getName().equals(this.searchElementName)) {
                matchingFreezableFound = true;
                IDatatype foundType = currentFreezable.getType();
                if (foundType != null) {
                    this.elementTypeDescription = new ModelElementDescription(this.searchElementName, foundType.getName(), this.getClassTypeFromFreezable(currentFreezable));
                }
            }
            ++freezableCounter;
        }
    }

    private ClassType getClassTypeFromFreezable(IFreezable freezable) {
        ClassType type = null;
        if (freezable instanceof DecisionVariableDeclaration) {
            type = ClassType.DECISION_VARIABLE_DECLARATION;
        } else if (freezable instanceof Project) {
            type = ClassType.PROJECT;
        }
        return type;
    }

    @Override
    public void visitOperationDefinition(OperationDefinition opdef) {
    }

    @Override
    public void visitPartialEvaluationBlock(PartialEvaluationBlock block) {
    }

    @Override
    public void visitProjectInterface(ProjectInterface iface) {
    }

    @Override
    public void visitComment(Comment comment) {
    }

    @Override
    public void visitAttributeAssignment(AttributeAssignment assignment) {
    }

    @Override
    public void visitCompoundAccessStatement(CompoundAccessStatement access) {
    }

    @Override
    public void visitEnum(Enum eenum) {
        if (eenum.getName() != null && eenum.getName().equals(this.searchElementName)) {
            this.elementTypeDescription = new ModelElementDescription(this.searchElementName, ModelElementTypeFinder.toString(ClassType.ENUM), ClassType.ENUM);
        }
    }

    @Override
    public void visitOrderedEnum(OrderedEnum eenum) {
        if (eenum.getName() != null && eenum.getName().equals(this.searchElementName)) {
            this.elementTypeDescription = new ModelElementDescription(this.searchElementName, ModelElementTypeFinder.toString(ClassType.ENUM), ClassType.ENUM);
        }
    }

    @Override
    public void visitCompound(Compound compound) {
        if (compound.getName() != null && compound.getName().equals(this.searchElementName)) {
            this.elementTypeDescription = new ModelElementDescription(this.searchElementName, ModelElementTypeFinder.toString(ClassType.COMPOUND), ClassType.COMPOUND);
        } else {
            int nestedElementCounter = 0;
            while (this.elementTypeDescription == null && nestedElementCounter < compound.getDeclarationCount()) {
                this.visitDecisionVariableDeclaration(compound.getDeclaration(nestedElementCounter));
                ++nestedElementCounter;
            }
        }
    }

    @Override
    public void visitDerivedDatatype(DerivedDatatype datatype) {
        if (datatype.getName() != null && datatype.getName().equals(this.searchElementName)) {
            this.elementTypeDescription = new ModelElementDescription(this.searchElementName, ModelElementTypeFinder.toString(ClassType.MAPPING), ClassType.MAPPING);
        }
    }

    @Override
    public void visitEnumLiteral(EnumLiteral literal) {
    }

    @Override
    public void visitReference(Reference reference) {
    }

    @Override
    public void visitSequence(Sequence sequence) {
    }

    @Override
    public void visitSet(Set set) {
    }

    public static String toString(ClassType type) {
        return switch (type) {
            case ClassType.DECISION_VARIABLE_DECLARATION -> DECISION_VARIABLE_TYPE;
            case ClassType.ENUM -> ENUM_TYPE;
            case ClassType.ORDERED_ENUM -> ENUM_TYPE;
            case ClassType.COMPOUND -> COMPOUND_TYPE;
            case ClassType.MAPPING -> MAPPING_TYPE;
            default -> "";
        };
    }

    public static enum ClassType {
        PROJECT,
        DECISION_VARIABLE_DECLARATION,
        ENUM,
        ORDERED_ENUM,
        COMPOUND,
        MAPPING;

    }

    public class ModelElementDescription {
        private String elementName;
        private String elementType;
        private ClassType elementClass;

        public ModelElementDescription(String name, String type, ClassType clazz) {
            this.elementName = name;
            this.elementType = type;
            this.elementClass = clazz;
        }

        public String getElementName() {
            return this.elementName;
        }

        public String getElementType() {
            return this.elementType;
        }

        public ClassType getElementClass() {
            return this.elementClass;
        }
    }
}

