/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.python.codeArtifacts;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.ssehub.easy.instantiation.core.model.templateModel.CodeWriter;
import net.ssehub.easy.instantiation.core.model.templateModel.Formatting;
import net.ssehub.easy.instantiation.core.model.vilTypes.IStringValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.IVilType;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.python.codeArtifacts.IPythonCodeArtifact;
import net.ssehub.easy.instantiation.python.codeArtifacts.IPythonCodeImport;
import net.ssehub.easy.instantiation.python.codeArtifacts.Storable;

public interface IPythonCodeElement
extends IVilType,
IStringValueProvider,
Storable {
    public static final Comparator<IPythonCodeElement> KEY_COMPARATOR = (e1, e2) -> e1.getSortKey().compareTo(e2.getSortKey());

    public IPythonCodeArtifact getArtifact();

    default public IPythonCodeElement getTopClass() {
        IPythonCodeElement iter = this.getParent();
        if (iter.isBlock()) {
            while (iter.getParent() != null && iter.getParent().isBlock()) {
                iter = iter.getParent();
            }
        }
        while (iter.getParent() != null && iter.getParent().isClass()) {
            iter = iter.getParent();
        }
        return iter;
    }

    public IPythonCodeElement getParent();

    @Invisible(inherit=true)
    public void setParent(IPythonCodeElement var1);

    @Invisible(inherit=true)
    default public void addAll(List<IPythonCodeElement> list) {
        list.add(this);
    }

    @Invisible(inherit=true)
    default public boolean hasPythondocComment() {
        return false;
    }

    @Invisible(inherit=true)
    default public String getSortKey() {
        return "";
    }

    @Invisible(inherit=true)
    default public boolean isAttribute() {
        return false;
    }

    @Invisible(inherit=true)
    default public boolean isClass() {
        return false;
    }

    @Invisible(inherit=true)
    default public boolean isBlock() {
        return false;
    }

    @Invisible(inherit=true)
    default public boolean isEmptyLine() {
        return false;
    }

    @Invisible(inherit=true)
    default public String getTracerStringValue(IStringValueProvider.StringComparator comparator) {
        return this.getClass().getSimpleName();
    }

    @Invisible(inherit=true)
    default public String getStringValue(IStringValueProvider.StringComparator comparator) {
        if (comparator != null) {
            return this.getTracerStringValue(comparator);
        }
        return this.getClass().getSimpleName();
    }

    public static <L, E extends L> E add(List<L> list, E element) {
        list.add(element);
        return element;
    }

    public static <L, E extends L> E add(List<L> list, E element, int pos) {
        list.add(pos, element);
        return element;
    }

    public static String appendWhitespace(String text) {
        if (text.endsWith(" ")) {
            return text;
        }
        return IPythonCodeElement.appendSeparator(text, " ");
    }

    public static String appendSeparator(String text, String separator) {
        if (((String)text).length() > 0) {
            text = (String)text + separator;
        }
        return text;
    }

    public static void storeList(List<? extends IPythonCodeElement> elements, String separator, CodeWriter out) {
        IPythonCodeElement.storeList("", elements, separator, out);
    }

    public static void storeList(String prefix, List<? extends IPythonCodeElement> elements, String separator, CodeWriter out) {
        if (elements != null && elements.size() > 0) {
            if (prefix != null && prefix.length() > 0) {
                out.print(prefix);
            }
            int e = 0;
            while (e < elements.size()) {
                if (e > 0) {
                    out.print(", ");
                }
                elements.get(e).store(out);
                ++e;
            }
        }
    }

    public static String toList(List<String> elements, String separator) {
        Object result = "";
        if (elements != null) {
            int e = 0;
            while (e < elements.size()) {
                if (e > 0) {
                    result = (String)result + ", ";
                }
                result = (String)result + elements.get(e);
                ++e;
            }
        }
        return result;
    }

    public static <T extends IPythonCodeElement> void setParent(IPythonCodeElement parent, Class<T> cls, Consumer<T> setter) {
        if (cls.isInstance(parent)) {
            setter.accept((IPythonCodeElement)cls.cast(parent));
        }
    }

    public static <T extends Enum<T>> T getFormattingArgument(Class<T> cls, String key, T dflt) {
        T result = dflt;
        try {
            result = Enum.valueOf(cls, Formatting.getFormattingConfiguration().getProfileArgument(key, dflt != null ? dflt.name() : ""));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return result;
    }

    public static void sort(List<IPythonCodeElement> list, Comparator<IPythonCodeElement> comparator) {
        if (comparator != null && list != null && list.size() > 0) {
            Collections.sort(list, comparator);
        }
    }

    public static void moveTo(List<IPythonCodeElement> elts, IPythonCodeElement elt, Class<?> cls) {
        IPythonCodeElement.moveTo(elts, elt, (IPythonCodeElement e) -> cls.isInstance(e));
    }

    public static void moveTo(List<IPythonCodeElement> elts, IPythonCodeElement elt, Predicate<IPythonCodeElement> cond) {
        elts.remove(elt);
        int pos = 0;
        int first = 0;
        while (first < elts.size() && !cond.test(elts.get(first))) {
            ++first;
        }
        if (first < elts.size()) {
            pos = first;
            while (pos < elts.size() && cond.test(elts.get(pos))) {
                ++pos;
            }
        }
        elts.add(pos, elt);
    }

    @Invisible
    default public void moveToAttributes(IPythonCodeElement element) {
    }

    @Invisible
    default public void moveToImports(IPythonCodeImport imp) {
    }
}

