/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.python.codeArtifacts;

import net.ssehub.easy.instantiation.core.model.templateModel.CodeWriter;
import net.ssehub.easy.instantiation.python.codeArtifacts.IPythonCodeElement;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeClass;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeConstructorCall;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeFnCall;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeImportScope;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeStmt;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeTypeSpec;

public class PythonCodeAssign
extends PythonCodeStmt {
    private String varName;
    private PythonCodeTypeSpec type;
    private String expr;
    private PythonCodeFnCall call = null;

    public PythonCodeAssign(IPythonCodeElement parent, String varName, String expr) {
        super(parent);
        this.varName = varName;
        this.expr = expr;
    }

    public PythonCodeAssign(IPythonCodeElement parent, String varName, String type, String expr) {
        super(parent);
        this.varName = varName;
        this.expr = expr;
        this.type = new PythonCodeTypeSpec(type, parent);
    }

    public PythonCodeAssign toAttributes() {
        IPythonCodeElement cls = this.getTopClass();
        if (cls != null) {
            cls.moveToAttributes(this);
        }
        return this;
    }

    public PythonCodeAssign toAttributes(boolean apply) {
        if (apply) {
            this.toAttributes();
        }
        return this;
    }

    public PythonCodeFnCall addCall(String fnName) {
        return this.addCall(fnName, PythonCodeImportScope.NONE);
    }

    public PythonCodeFnCall addCall(String fnName, PythonCodeImportScope scope) {
        this.call = new PythonCodeFnCall(this, fnName, scope);
        return this.call;
    }

    public PythonCodeConstructorCall addConstructorCall(String cls) {
        this.call = new PythonCodeConstructorCall(this, cls);
        return (PythonCodeConstructorCall)this.call;
    }

    @Override
    public void store(CodeWriter out) {
        out.printwi(this.varName);
        if (this.type != null) {
            out.print(": ");
            this.type.store(out);
        }
        out.print(" = ");
        if (this.call != null) {
            this.call.store(out);
        } else {
            out.print(this.expr);
        }
        out.println();
    }

    @Override
    public boolean isAttribute() {
        return this.getParent() instanceof PythonCodeClass;
    }
}

