/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.python.codeArtifacts;

import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.instantiation.core.model.templateModel.CodeWriter;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationMeta;
import net.ssehub.easy.instantiation.python.codeArtifacts.IPythonCodeArtifact;
import net.ssehub.easy.instantiation.python.codeArtifacts.IPythonCodeElement;
import net.ssehub.easy.instantiation.python.codeArtifacts.IPythonCodeImport;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeAlternative;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeAssert;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeAssign;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeClass;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeDelete;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeDocComment;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeEnum;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeFnCall;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeForLoop;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeFunction;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeGlobal;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeImport;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeImportScope;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeMatch;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeNonLocal;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeRaise;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeSingleLineComment;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeStmt;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeText;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeTryBlock;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeTypeAlias;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeWhileLoop;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeWith;

public class PythonCodeBlock
extends PythonCodeStmt {
    private List<IPythonCodeElement> elements = new ArrayList<IPythonCodeElement>();
    private IPythonCodeArtifact artifact;

    public PythonCodeBlock(IPythonCodeElement parent) {
        super(parent);
    }

    public PythonCodeBlock(IPythonCodeArtifact artifact) {
        super(null);
        this.artifact = artifact;
    }

    protected <T extends IPythonCodeElement> T addElt(T elt) {
        return IPythonCodeElement.add(this.elements, elt);
    }

    protected <T extends IPythonCodeElement> T addElt(T elt, boolean importToFront) {
        int lastImport = -1;
        if (importToFront && elt instanceof IPythonCodeImport) {
            int e = 0;
            while (e < this.elements.size()) {
                IPythonCodeElement tmp = this.elements.get(e);
                if (tmp instanceof IPythonCodeImport) {
                    lastImport = e;
                }
                ++e;
            }
        }
        T result = lastImport < 0 ? (importToFront ? IPythonCodeElement.add(this.elements, elt, 0) : IPythonCodeElement.add(this.elements, elt)) : IPythonCodeElement.add(this.elements, elt, lastImport + 1);
        return result;
    }

    public void add(String text) {
        this.elements.add(new PythonCodeText(text, true, true));
    }

    public void addRaw(String text, boolean indent) {
        this.elements.add(new PythonCodeText(text, indent, true));
    }

    public void addEmptyLine() {
        this.add("");
    }

    public PythonCodeClass addClass(String name) {
        return this.addElt(new PythonCodeClass(this, name));
    }

    public PythonCodeClass addClass(String name, String comment) {
        return this.addElt(new PythonCodeClass(this, name, comment));
    }

    public PythonCodeEnum addEnum(String name) {
        return this.addElt(new PythonCodeEnum(this, name));
    }

    public PythonCodeEnum addEnum(String name, String comment) {
        return this.addElt(new PythonCodeEnum(this, name, comment));
    }

    public PythonCodeFunction addFunc(String name) {
        return this.addElt(new PythonCodeFunction(this, name));
    }

    public PythonCodeFunction addFunc(String name, String comment) {
        return this.addElt(new PythonCodeFunction(this, name, comment));
    }

    public PythonCodeTypeAlias addTypeAlias(String name, String expr) {
        return this.addElt(new PythonCodeTypeAlias(this, name, expr));
    }

    @OperationMeta(name={"addAssign", "addAssignment", "assign"})
    public PythonCodeAssign addAssign(String varName, String expr) {
        return this.addElt(new PythonCodeAssign(this, varName, expr));
    }

    @OperationMeta(name={"addAssign", "addAssignment", "assign"})
    public PythonCodeAssign addAssign(String varName, String type, String expr) {
        return this.addElt(new PythonCodeAssign(this, varName, type, expr));
    }

    public PythonCodeFnCall addCall(String name) {
        return this.addCall(name, PythonCodeImportScope.NONE);
    }

    public PythonCodeFnCall addSuperCall(String name) {
        return this.addCall("super").addCall(name);
    }

    public PythonCodeFnCall addSuperConstructorCall() {
        return this.addSuperCall("__init__");
    }

    public PythonCodeFnCall addSelfCall(String name) {
        return this.addCall("self." + name);
    }

    public PythonCodeFnCall addCall(String name, PythonCodeImportScope scope) {
        return this.addElt(new PythonCodeFnCall(this, name, scope, true));
    }

    public PythonCodeAlternative addIf(String condition) {
        return this.addElt(new PythonCodeAlternative(this, condition));
    }

    public PythonCodeMatch addMatch(String expr) {
        return this.addElt(new PythonCodeMatch(this, expr));
    }

    public PythonCodeWhileLoop addWhile(String condition) {
        return this.addElt(new PythonCodeWhileLoop(this, condition));
    }

    public PythonCodeForLoop addFor(String element, String array) {
        return this.addElt(new PythonCodeForLoop(this, element, array));
    }

    public PythonCodeForLoop addFor(String element, String rangeStart, String rangeEnd) {
        return this.addElt(new PythonCodeForLoop(this, element, rangeStart, rangeEnd));
    }

    public PythonCodeForLoop addFor(String element, String rangeStart, String rangeEnd, String rangeStep) {
        return this.addElt(new PythonCodeForLoop(this, element, rangeStart, rangeEnd, rangeStep));
    }

    public PythonCodeWith addWith(String expr) {
        return this.addElt(new PythonCodeWith(this, expr));
    }

    public PythonCodeWith addWith(String expr, String varName) {
        return this.addElt(new PythonCodeWith(this, expr, varName));
    }

    public PythonCodeTryBlock addTry() {
        return this.addElt(new PythonCodeTryBlock(this));
    }

    public PythonCodeRaise addRaise(String expression) {
        return this.addElt(new PythonCodeRaise(this, expression));
    }

    public PythonCodeBlock addComment(String comment) {
        this.addElt(new PythonCodeDocComment(comment, this));
        return this;
    }

    public PythonCodeBlock addSLComment(String comment) {
        return this.addSLComment(comment, false);
    }

    public PythonCodeBlock addSLComment(String comment, boolean enclosed) {
        this.addElt(new PythonCodeSingleLineComment(this, comment, enclosed));
        return this;
    }

    public PythonCodeDelete addDelete(String varName) {
        return this.addElt(new PythonCodeDelete(this, varName));
    }

    public PythonCodeNonLocal addNonLocal(String varName) {
        return this.addElt(new PythonCodeNonLocal(this, varName));
    }

    public PythonCodeGlobal addGlobal(String varName) {
        return this.addElt(new PythonCodeGlobal(this, varName));
    }

    public PythonCodeAssert addAssert(String expr) {
        return this.addElt(new PythonCodeAssert(this, expr));
    }

    public PythonCodeAssert addAssert(String expr, String msg) {
        return this.addElt(new PythonCodeAssert(this, expr, msg));
    }

    public void addReturn(String value) {
        this.add("return " + value);
    }

    public void addContinue() {
        this.add("continue");
    }

    public void addBreak() {
        this.add("break");
    }

    public void addPass() {
        this.add("pass");
    }

    public PythonCodeFnCall addPrint() {
        return this.addCall("print");
    }

    public PythonCodeBlock setBlock(PythonCodeBlock block) {
        this.elements.clear();
        for (IPythonCodeElement e : block.elements) {
            e.setParent(this);
            this.elements.add(e);
        }
        return this;
    }

    @Override
    public void store(CodeWriter out) {
        IPythonCodeElement last = null;
        for (IPythonCodeElement e : this.elements) {
            if (e.isClass() && (last == null || !last.isEmptyLine())) {
                out.println();
            }
            e.store(out);
            last = e;
        }
        if (this.elements.isEmpty()) {
            out.printlnwi("pass");
        }
    }

    @Override
    public int getElementCount() {
        int result = 0;
        int e = 0;
        while (e < this.elements.size()) {
            result += this.elements.get(e).getElementCount();
            ++e;
        }
        return result;
    }

    protected PythonCodeClass getParentClass() {
        PythonCodeClass result = null;
        if (this.getParent() instanceof PythonCodeClass) {
            result = (PythonCodeClass)this.getParent();
        } else if (this.getParent() instanceof PythonCodeBlock) {
            result = ((PythonCodeBlock)this.getParent()).getParentClass();
        } else {
            PythonCodeClass iter = PythonCodeClass.getParentCodeClass(this);
            if (iter != null) {
                result = iter;
            }
        }
        return result;
    }

    @Override
    @Invisible
    public IPythonCodeArtifact getArtifact() {
        if (this.artifact == null) {
            return this.getParent().getArtifact();
        }
        return this.artifact;
    }

    @Override
    @Invisible(inherit=true)
    public boolean isBlock() {
        return true;
    }

    @Override
    @Invisible
    public void moveToImports(IPythonCodeImport imp) {
        IPythonCodeElement.moveTo(this.elements, (IPythonCodeElement)imp, PythonCodeImport.class);
    }
}

