/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.python.codeArtifacts;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.ssehub.easy.instantiation.core.model.templateModel.CodeWriter;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationMeta;
import net.ssehub.easy.instantiation.core.model.vilTypes.PseudoString;
import net.ssehub.easy.instantiation.python.codeArtifacts.IPythonCodeElement;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeAssign;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeDocComment;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeElement;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeFunction;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeImportScope;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeSingleLineComment;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeText;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeTypeSpec;

public class PythonCodeClass
extends PythonCodeElement {
    private String name;
    private List<IPythonCodeElement> elements = new ArrayList<IPythonCodeElement>();
    private List<PythonCodeTypeSpec> bases = new ArrayList<PythonCodeTypeSpec>();
    private PythonCodeDocComment comment;

    PythonCodeClass(IPythonCodeElement parent, String name) {
        super(parent);
        this.name = name;
        PythonCodeTypeSpec.create(name, this);
    }

    PythonCodeClass(IPythonCodeElement parent, String name, String comment) {
        super(parent);
        this.name = name;
        this.comment = new PythonCodeDocComment(comment, this);
        PythonCodeTypeSpec.create(name, this);
    }

    public String getName() {
        return this.name;
    }

    public PythonCodeClass add(String text) {
        IPythonCodeElement.add(this.elements, new PythonCodeText(text, true, true));
        return this;
    }

    public PythonCodeClass addEmptyLine() {
        return this.add("");
    }

    public PythonCodeClass addClass(String name) {
        return this.add(new PythonCodeClass(this, name));
    }

    public PythonCodeAssign addAttribute(String name, String initExpr) {
        return this.add(new PythonCodeAssign(this, name, initExpr));
    }

    public PythonCodeAssign addAttribute(String name, String type, String initExpr) {
        return this.add(new PythonCodeAssign(this, name, type, initExpr));
    }

    protected <T extends IPythonCodeElement> T add(T element) {
        return IPythonCodeElement.add(this.elements, element);
    }

    public PythonCodeClass addBase(String type) {
        return this.addBase(type, PythonCodeImportScope.MODULE);
    }

    public PythonCodeClass addBase(String type, PythonCodeImportScope scope) {
        if (type != null && type.length() > 0) {
            this.bases.add(PythonCodeTypeSpec.create(type, this, scope));
        }
        return this;
    }

    @OperationMeta(name={"addMethod", "addFunc"})
    public PythonCodeFunction addMethod(String name) {
        PythonCodeFunction func = this.add(new PythonCodeFunction(this, name));
        func.addParameter("self");
        return func;
    }

    @OperationMeta(name={"addMethod", "addFunc"})
    public PythonCodeFunction addMethod(String name, String comment) {
        PythonCodeFunction func = this.add(new PythonCodeFunction(this, name, comment));
        func.addParameter("self");
        return func;
    }

    public PythonCodeFunction addGetter(String varName) {
        String funcName = "get" + PseudoString.firstToUpperCase((String)varName);
        String funcComment = "Returns the value of " + varName + ".";
        PythonCodeFunction func = this.add(new PythonCodeFunction(this, funcName, funcComment));
        func.addParameter("self");
        func.addReturn("self." + varName, "return value of " + varName);
        return func;
    }

    public PythonCodeFunction addGetter(String varName, String type) {
        String funcName = "get" + PseudoString.firstToUpperCase((String)varName);
        String funcComment = "Returns the value of " + varName + ".";
        PythonCodeFunction func = this.add(new PythonCodeFunction(this, funcName, funcComment));
        func.addParameter("self");
        func.addReturn("self." + varName, "return value of " + varName);
        func.addRetType(type);
        return func;
    }

    public PythonCodeFunction addSetter(String varName) {
        String funcName = "set" + PseudoString.firstToUpperCase((String)varName);
        String funcComment = "Sets the value of " + varName + ".";
        PythonCodeFunction func = this.add(new PythonCodeFunction(this, funcName, funcComment));
        func.addParameter("self");
        func.addParameter(varName, "", "the new value");
        func.addAssign("self." + varName, varName);
        return func;
    }

    public PythonCodeFunction addSetter(String varName, String type) {
        String funcName = "set" + PseudoString.firstToUpperCase((String)varName);
        String funcComment = "Sets the value of " + varName + ".";
        PythonCodeFunction func = this.add(new PythonCodeFunction(this, funcName, funcComment));
        func.addParameter("self");
        func.addParameter(varName, type, "the new value");
        func.addAssign("self." + varName, varName);
        return func;
    }

    public PythonCodeFunction addConstructor() {
        return this.addConstructor(null);
    }

    public PythonCodeFunction addConstructor(String comment) {
        PythonCodeFunction func = this.add(new PythonCodeFunction(this, "__init__", comment));
        func.addParameter("self");
        return func;
    }

    public PythonCodeClass addComment(String comment) {
        this.add(new PythonCodeDocComment(comment, this));
        return this;
    }

    public PythonCodeClass addSLComment(String comment) {
        return this.addSLComment(comment, false);
    }

    public PythonCodeClass addSLComment(String comment, boolean enclosed) {
        this.add(new PythonCodeSingleLineComment(this, comment, enclosed));
        return this;
    }

    static void setParent(IPythonCodeElement parent, Consumer<PythonCodeClass> consumer) {
        IPythonCodeElement.setParent(parent, PythonCodeClass.class, consumer);
    }

    static PythonCodeClass getParentCodeClass(IPythonCodeElement element) {
        if (element == null) {
            return null;
        }
        IPythonCodeElement iter = element.getParent();
        while (iter != null && !(iter instanceof PythonCodeClass)) {
            iter = iter.getParent();
        }
        return iter instanceof PythonCodeClass ? (PythonCodeClass)iter : null;
    }

    @Override
    @Invisible
    public void store(CodeWriter out) {
        out.printwi("class " + this.name);
        if (!this.bases.isEmpty()) {
            IPythonCodeElement.storeList("(", this.bases, ", ", out);
            out.print(")");
        }
        out.println(":");
        out.increaseIndent();
        if (this.comment != null) {
            this.comment.store(out);
            out.println();
        }
        this.storeElements(out);
        out.decreaseIndent();
        out.println();
    }

    @Invisible
    public void storeElements(CodeWriter out) {
        IPythonCodeElement last = null;
        for (IPythonCodeElement e : this.elements) {
            if (last != null && last.isAttribute() && !e.isAttribute()) {
                out.println();
            }
            e.store(out);
            last = e;
        }
        if (this.elements.isEmpty()) {
            out.printlnwi("pass");
        }
    }

    @Override
    public boolean isClass() {
        return true;
    }

    @Override
    @Invisible
    public void moveToAttributes(IPythonCodeElement element) {
        IPythonCodeElement.moveTo(this.elements, element, PythonCodeAssign.class);
    }
}

