/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.python.codeArtifacts;

import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.instantiation.core.model.templateModel.CodeWriter;
import net.ssehub.easy.instantiation.core.model.vilTypes.IStringValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.python.codeArtifacts.IPythonCodeArtifact;
import net.ssehub.easy.instantiation.python.codeArtifacts.IPythonCodeElement;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeDecoratorArg;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeImportScope;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeParamSpec;

public class PythonCodeDecorator
implements IPythonCodeElement {
    private String name;
    private IPythonCodeElement decorated;
    private List<PythonCodeDecoratorArg> args = new ArrayList<PythonCodeDecoratorArg>();

    PythonCodeDecorator(String name, IPythonCodeElement decorated, PythonCodeImportScope scope) {
        this.decorated = decorated;
        this.name = decorated.getArtifact().validateFuncCall(name, scope);
    }

    @Override
    @Invisible(inherit=true)
    public String getTracerStringValue(IStringValueProvider.StringComparator comparator) {
        return this.getClass().getSimpleName();
    }

    public PythonCodeDecorator addArgument(String value) {
        IPythonCodeElement.add(this.args, new PythonCodeDecoratorArg(value, this));
        return this;
    }

    @Override
    public void store(CodeWriter out) {
        this.storeNoLn(out);
        out.println();
    }

    public void storeNoLn(CodeWriter out) {
        out.printwi("@" + this.name);
        if (this.args != null && !this.args.isEmpty()) {
            out.print("(");
            IPythonCodeElement.storeList(this.args, ", ", out);
            out.print(")");
        }
    }

    @Override
    public IPythonCodeArtifact getArtifact() {
        return this.decorated.getArtifact();
    }

    @Override
    public IPythonCodeElement getParent() {
        return this.decorated;
    }

    @Override
    public void setParent(IPythonCodeElement decorated) {
        this.decorated = decorated;
    }

    @Override
    public int getElementCount() {
        return this.decorated instanceof PythonCodeParamSpec ? 0 : 1;
    }
}

