/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.python.codeArtifacts;

import net.ssehub.easy.instantiation.core.model.templateModel.CodeWriter;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.python.codeArtifacts.IPythonCodeElement;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeAlternative;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeAssign;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeClass;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeDocComment;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeForLoop;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeFunction;

public class PythonCodeEnum
extends PythonCodeClass {
    PythonCodeEnum(IPythonCodeElement parent, String name) {
        super(parent, name);
        this.init();
    }

    PythonCodeEnum(IPythonCodeElement parent, String name, String comment) {
        super(parent, name, comment);
        this.init();
    }

    private void init() {
        this.getArtifact().addImport("enum", "Enum");
        this.addBase("Enum");
    }

    public PythonCodeAssign addLiteral(String name, String value) {
        return this.addLiteral(name, value, null);
    }

    public PythonCodeAssign addLiteral(String name, String value, String comment) {
        return this.add(new PythonCodeEnumLiteral(this, name, value, comment));
    }

    public PythonCodeFunction addLiteralByOrdinalFunction(String name) {
        return this.addLiteralByOrdinalFunction(name, "ordinal");
    }

    public PythonCodeFunction addLiteralByOrdinalFunction(String name, String argumentName) {
        PythonCodeFunction f = this.getArtifact().addFunc(name, "Returns an enum literal via its model ordinal.");
        f.addRetType(this.getName(), "the enum literal or Null");
        f.addParameter("ordinal", "int", "the desired ordinal value");
        PythonCodeForLoop l = f.addFor("l", this.getName());
        PythonCodeAlternative i = l.addIf("l.value == ordinal");
        i.addReturn("l");
        f.addReturn("None");
        return f;
    }

    private class PythonCodeEnumLiteral
    extends PythonCodeAssign {
        private PythonCodeDocComment comment;

        private PythonCodeEnumLiteral(IPythonCodeElement parent, String varName, String expr, String comment) {
            super(parent, varName, expr);
            if (expr != null && expr.length() > 0) {
                this.comment = new PythonCodeDocComment(comment, this);
            }
        }

        @Override
        public void store(CodeWriter out) {
            super.store(out);
            if (this.comment != null) {
                this.comment.store(out);
            }
        }

        @Override
        @Invisible
        public boolean isAttribute() {
            return true;
        }
    }
}

