/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.python.codeArtifacts;

import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.instantiation.core.model.templateModel.CodeWriter;
import net.ssehub.easy.instantiation.core.model.vilTypes.IStringValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.python.codeArtifacts.IPythonCodeArtifact;
import net.ssehub.easy.instantiation.python.codeArtifacts.IPythonCodeElement;
import net.ssehub.easy.instantiation.python.codeArtifacts.IPythonCodeImport;

public class PythonCodeImport
implements IPythonCodeImport {
    private String module = "";
    private List<String> names = new ArrayList<String>();
    private String alias = "";
    private IPythonCodeArtifact artifact;
    private boolean isWildcard;

    public PythonCodeImport(IPythonCodeArtifact artifact, String module, boolean explicit) {
        this.module = module;
        this.artifact = artifact;
        this.isWildcard = false;
        artifact.registerImport(this, explicit);
    }

    public PythonCodeImport(IPythonCodeArtifact artifact, String module, String name, boolean explicit) {
        this.names.add(name);
        this.module = module;
        this.artifact = artifact;
        this.isWildcard = name.equals("*");
        artifact.registerImport(this, explicit);
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    public PythonCodeImport toImports() {
        this.artifact.moveToImports(this);
        return this;
    }

    public PythonCodeImport toImports(boolean apply) {
        if (apply) {
            this.toImports();
        }
        return this;
    }

    public PythonCodeImport setAlias(String alias) {
        this.alias = alias;
        return this;
    }

    @Override
    public void store(CodeWriter out) {
        if (!this.names.isEmpty()) {
            out.printlnwi("from " + this.module + " import " + this.getName());
        } else if (!this.alias.isEmpty()) {
            out.printlnwi("import " + this.module + " as " + this.alias);
        } else {
            out.printlnwi("import " + this.module);
        }
    }

    @Override
    public String getName() {
        return IPythonCodeElement.toList(this.names, ",");
    }

    @Override
    public String getModule() {
        return this.module;
    }

    @Override
    @Invisible(inherit=true)
    public String getTracerStringValue(IStringValueProvider.StringComparator comparator) {
        return this.getClass().getSimpleName() + ": " + this.getName();
    }

    @Override
    public boolean isWildcard() {
        return this.isWildcard;
    }

    @Override
    public IPythonCodeArtifact getArtifact() {
        return this.artifact;
    }

    @Override
    public IPythonCodeElement getParent() {
        return null;
    }

    @Override
    public void setParent(IPythonCodeElement parent) {
    }

    @Override
    public boolean match(IPythonCodeImport other) {
        return !(!this.module.equals(other.getModule()) && !this.alias.equals(other.getModule()) || !this.hasName(other.getName()) && !this.isWildcard);
    }

    private boolean hasName(String name) {
        boolean result = name.length() == 0 ? this.names.size() == 0 : this.names.contains(name);
        return result;
    }

    public PythonCodeImport addName(String name) {
        this.names.add(name);
        return this;
    }
}

