/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.python.codeArtifacts;

import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.instantiation.core.model.templateModel.CodeWriter;
import net.ssehub.easy.instantiation.core.model.vilTypes.IStringValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.python.codeArtifacts.IPythonCodeElement;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeBlock;
import net.ssehub.easy.instantiation.python.codeArtifacts.PythonCodeElement;

public class PythonCodeMatch
extends PythonCodeElement {
    private List<PythonCodeCase> cases = new ArrayList<PythonCodeCase>();
    private PythonCodeCase defaultCase;
    private String expr;

    public PythonCodeMatch(IPythonCodeElement parent, String expr) {
        super(parent);
        this.expr = expr;
    }

    public PythonCodeBlock addCase(String expr) {
        PythonCodeCase c = new PythonCodeCase(this, expr);
        if (expr.equals("_")) {
            this.defaultCase = c;
        } else {
            this.cases.add(c);
        }
        return c;
    }

    public PythonCodeBlock addDefault() {
        this.defaultCase = new PythonCodeCase(this);
        return this.defaultCase;
    }

    @Override
    public void store(CodeWriter out) {
        out.printlnwi("match " + this.expr + ":");
        out.increaseIndent();
        for (PythonCodeCase c : this.cases) {
            c.store(out);
        }
        if (this.defaultCase != null) {
            this.defaultCase.store(out);
        }
        out.decreaseIndent();
    }

    private class PythonCodeCase
    extends PythonCodeBlock {
        private String condition;

        public PythonCodeCase(IPythonCodeElement parent) {
            this(parent, "_");
        }

        public PythonCodeCase(IPythonCodeElement parent, String condition) {
            super(parent);
            this.condition = condition;
        }

        @Override
        @Invisible(inherit=true)
        public String getTracerStringValue(IStringValueProvider.StringComparator comparator) {
            return this.condition.equals("_") ? "PythonCodeDefault" : "PythonCodeCase";
        }

        @Override
        public void store(CodeWriter out) {
            out.printlnwi("case " + this.condition + ":");
            out.increaseIndent();
            super.store(out);
            out.decreaseIndent();
        }
    }
}

