/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.python.codeArtifacts;

import net.ssehub.easy.instantiation.core.model.templateModel.CodeWriter;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.PseudoString;
import net.ssehub.easy.instantiation.python.codeArtifacts.IPythonCodeArtifact;
import net.ssehub.easy.instantiation.python.codeArtifacts.IPythonCodeElement;

public class PythonCodeText
implements IPythonCodeElement {
    private String rawText;
    private boolean indent;
    private boolean endWithNewline;

    public PythonCodeText(String rawText, boolean indent, boolean endWithNewline) {
        this.rawText = PseudoString.content((String)rawText);
        this.indent = indent;
        this.endWithNewline = endWithNewline;
    }

    @Override
    public void store(CodeWriter out) {
        boolean done = false;
        if (this.indent) {
            done = out.printLinesWi(this.rawText, false, this.endWithNewline);
        }
        if (!done) {
            if (this.indent) {
                out.printIndent();
            }
            out.print(this.rawText);
            if (this.endWithNewline) {
                out.println();
            }
        }
    }

    @Override
    @Invisible
    public IPythonCodeArtifact getArtifact() {
        return null;
    }

    @Override
    public IPythonCodeElement getParent() {
        return null;
    }

    @Override
    @Invisible
    public void setParent(IPythonCodeElement parent) {
    }

    @Override
    public int getElementCount() {
        int lines = this.rawText.length() - this.rawText.replace("\\n", "").length();
        return lines + (this.endWithNewline ? 1 : 0);
    }

    @Override
    public boolean isEmptyLine() {
        return this.rawText != null && this.rawText.isEmpty();
    }
}

