/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.configuration.easyProducer;

import de.iip_ecosphere.platform.configuration.easyProducer.ConfigurationLifecycleDescriptor;
import de.iip_ecosphere.platform.configuration.easyProducer.ConfigurationManager;
import de.iip_ecosphere.platform.configuration.easyProducer.ConfigurationSetup;
import de.iip_ecosphere.platform.configuration.easyProducer.DrawflowGraphFormat;
import de.iip_ecosphere.platform.configuration.easyProducer.EasySetup;
import de.iip_ecosphere.platform.configuration.easyProducer.PlatformInstantiator;
import de.iip_ecosphere.platform.configuration.easyProducer.ivml.AasIvmlMapper;
import de.iip_ecosphere.platform.configuration.easyProducer.ivml.DecisionVariableProvider;
import de.iip_ecosphere.platform.configuration.easyProducer.ivml.DefaultEdge;
import de.iip_ecosphere.platform.configuration.easyProducer.ivml.DefaultGraph;
import de.iip_ecosphere.platform.configuration.easyProducer.ivml.DefaultNode;
import de.iip_ecosphere.platform.configuration.easyProducer.ivml.GraphFormat;
import de.iip_ecosphere.platform.configuration.easyProducer.ivml.IvmlGraphMapper;
import de.iip_ecosphere.platform.configuration.easyProducer.ivml.IvmlUtils;
import de.iip_ecosphere.platform.configuration.easyProducer.serviceMesh.ServiceMeshGraphMapper;
import de.iip_ecosphere.platform.support.CollectionUtils;
import de.iip_ecosphere.platform.support.Endpoint;
import de.iip_ecosphere.platform.support.FileUtils;
import de.iip_ecosphere.platform.support.Server;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.AasFactory;
import de.iip_ecosphere.platform.support.aas.AasServer;
import de.iip_ecosphere.platform.support.aas.InvocablesCreator;
import de.iip_ecosphere.platform.support.aas.Operation;
import de.iip_ecosphere.platform.support.aas.Property;
import de.iip_ecosphere.platform.support.aas.ProtocolServerBuilder;
import de.iip_ecosphere.platform.support.aas.ServerRecipe;
import de.iip_ecosphere.platform.support.aas.SetupSpec;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.aas.SubmodelElementList;
import de.iip_ecosphere.platform.support.iip_aas.AasPartRegistry;
import de.iip_ecosphere.platform.support.json.JsonResultWrapper;
import de.iip_ecosphere.platform.support.json.JsonUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.reasoning.core.reasoner.ReasoningResult;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.IvmlModelQuery;
import net.ssehub.easy.varModel.model.ModelQuery;
import net.ssehub.easy.varModel.model.ModelQueryException;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.ProjectImport;
import net.ssehub.easy.varModel.model.datatypes.IResolutionScope;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import test.de.iip_ecosphere.platform.configuration.easyProducer.AbstractGraphTest;
import test.de.iip_ecosphere.platform.support.aas.TestWithPlugin;

public class AasIvmlMapperTest
extends TestWithPlugin {
    private static final String MODEL_NAME = "PlatformConfiguration";
    private static File ivmlFolder;
    private static File origBase;
    private static File origIvmlMeta;
    private static File origIvmlConfig;
    private static String origIvmlModelName;
    private static Set<String> varNames;

    @Before
    public void setup() {
        super.setup();
        try {
            EasySetup ep = ConfigurationSetup.getSetup().getEasyProducer();
            origBase = ep.getBase();
            origIvmlMeta = ep.getIvmlMetaModelFolder();
            origIvmlConfig = ep.getIvmlConfigFolder();
            origIvmlModelName = ep.getIvmlModelName();
            AasIvmlMapperTest.setupIvmlFiles();
            ep.setBase(ivmlFolder);
            ep.setIvmlMetaModelFolder(ivmlFolder);
            ep.setIvmlConfigFolder(ivmlFolder);
            ep.setIvmlModelName(MODEL_NAME);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    private static void setupIvmlFiles() throws IOException {
        if (null != ivmlFolder) {
            FileUtils.deleteDirectory((File)ivmlFolder);
        }
        ivmlFolder = FileUtils.createTmpFolder((String)"config.config").getCanonicalFile();
        String srcCfg = (origIvmlMeta.toString() + "/cfg/").replace('/', File.separatorChar);
        FileUtils.copyDirectory((File)origIvmlMeta, (File)new File(ivmlFolder, "meta"), f -> !f.toString().startsWith(srcCfg));
        FileUtils.copyDirectory((File)(origIvmlConfig == null ? origBase : origIvmlConfig), (File)ivmlFolder, f -> f.getName().endsWith(".ivml") || f.getName().endsWith(".text"));
        FileUtils.copyDirectory((File)new File(EasySetup.getTestingEasyModelParent(), "src/test/easy/simpleMesh"), (File)ivmlFolder);
        AasIvmlMapperTest.copy(EasySetup.getTestingEasyModelParent() + "/src/test/easy/common", "CommonSetup.ivml", "CommonSetupNoMonUi.ivml");
    }

    private static void copy(String baseFolder, String ... fileNames) throws IOException {
        for (String n : fileNames) {
            FileUtils.copyFile((File)new File(baseFolder, n), (File)new File(ivmlFolder, n));
        }
    }

    @After
    public void shutdown() {
        EasySetup ep = ConfigurationSetup.getSetup().getEasyProducer();
        ep.setBase(origBase);
        ep.setIvmlMetaModelFolder(origIvmlMeta);
        ep.setIvmlConfigFolder(origIvmlConfig);
        ep.setIvmlModelName(origIvmlModelName);
        FileUtils.deleteQuietly((File)ivmlFolder);
        ep.reset();
    }

    @Test
    public void testAasIvmlMapper() throws ExecutionException {
        PlatformInstantiator.NonCleaningInstantiationConfigurer configurer = new PlatformInstantiator.NonCleaningInstantiationConfigurer(MODEL_NAME, ivmlFolder, FileUtils.getTempDirectory());
        DrawflowGraphFormat format = new DrawflowGraphFormat();
        IvmlGraphMapper.IvmlGraph graph = this.assertGraphMesh((PlatformInstantiator.InstantiationConfigurer)configurer, "myApp", 0, s -> {
            Assert.assertNotNull((Object)s.getSubmodelElementCollection("myReceiverService"));
            Assert.assertNotNull((Object)s.getSubmodelElementCollection("mySourceService"));
        }, (GraphFormat)format);
        AbstractGraphTest.TestGraph expected = new AbstractGraphTest.TestGraph();
        AbstractGraphTest.TestNode mySource = new AbstractGraphTest.TestNode();
        mySource.setName("Simple Data Source");
        mySource.setXPos(10);
        mySource.setYPos(10);
        AbstractGraphTest.TestNode myReceiver = new AbstractGraphTest.TestNode();
        myReceiver.setName("Simple Data Receiver");
        myReceiver.setXPos(300);
        myReceiver.setYPos(10);
        AbstractGraphTest.TestEdge myEdge = new AbstractGraphTest.TestEdge((IvmlGraphMapper.IvmlGraphNode)mySource, (IvmlGraphMapper.IvmlGraphNode)myReceiver);
        myEdge.setName("Source->Receiver");
        mySource.addEdge((IvmlGraphMapper.IvmlGraphEdge)myEdge);
        myReceiver.addEdge((IvmlGraphMapper.IvmlGraphEdge)myEdge);
        expected.addNode((IvmlGraphMapper.IvmlGraphNode)mySource);
        expected.addNode((IvmlGraphMapper.IvmlGraphNode)myReceiver);
        AbstractGraphTest.assertGraph((IvmlGraphMapper.IvmlGraph)expected, graph);
    }

    private ConfigurationLifecycleDescriptor startEasy(PlatformInstantiator.InstantiationConfigurer configurer) {
        ConfigurationSetup setup = ConfigurationSetup.getSetup();
        configurer.configure(setup);
        ConfigurationLifecycleDescriptor lcd = configurer.obtainLifecycleDescriptor();
        lcd.startup(new String[0]);
        return lcd;
    }

    private ConfigurationLifecycleDescriptor startEasyValidate(PlatformInstantiator.InstantiationConfigurer configurer) {
        ConfigurationLifecycleDescriptor lcd = this.startEasy(configurer);
        ReasoningResult rRes = ConfigurationManager.validateAndPropagate();
        Assert.assertNotNull((String)"No model loaded", (Object)rRes);
        return lcd;
    }

    private void stopEasy(ConfigurationLifecycleDescriptor lcd) {
        lcd.shutdown();
    }

    private IvmlGraphMapper.IvmlGraph assertGraphMesh(PlatformInstantiator.InstantiationConfigurer configurer, String appName, int netIndex, Consumer<SubmodelElementCollection> servicesAsserter, GraphFormat format) throws ExecutionException {
        ConfigurationLifecycleDescriptor lcd = this.startEasyValidate(configurer);
        AasIvmlMapper mapper = this.getInstance(false);
        mapper.addGraphFormat(format);
        AasPartRegistry.AasSetup aasSetup = AasPartRegistry.AasSetup.createLocalEphemeralSetup(null, (boolean)false);
        AasPartRegistry.setAasSetup((AasPartRegistry.AasSetup)aasSetup);
        ServerRecipe rcp = AasFactory.getInstance().createServerRecipe();
        Endpoint regEndpoint = aasSetup.adaptEndpoint(aasSetup.getRegistryEndpoint());
        System.out.println("ServerHost " + aasSetup.getServerHost() + " " + regEndpoint.toUri());
        ServerRecipe.LocalPersistenceType pType = ServerRecipe.LocalPersistenceType.INMEMORY;
        System.out.println("Starting " + String.valueOf(pType) + " AAS registry on " + regEndpoint.toUri());
        Server registryServer = rcp.createRegistryServer((SetupSpec)aasSetup, (ServerRecipe.PersistenceType)pType, new String[0]);
        registryServer.start();
        Endpoint serverEndpoint = aasSetup.adaptEndpoint(aasSetup.getServerEndpoint());
        System.out.println("ServerHost " + aasSetup.getServerHost() + " " + serverEndpoint.toUri());
        System.out.println("Starting " + String.valueOf(pType) + " AAS server on " + serverEndpoint.toUri());
        AasServer aasServer = rcp.createAasServer((SetupSpec)aasSetup, (ServerRecipe.PersistenceType)pType, new String[0]);
        aasServer.start();
        AasFactory aasFactory = AasFactory.getInstance();
        Aas.AasBuilder aasBuilder = aasFactory.createAasBuilder("Platform", null);
        Submodel.SubmodelBuilder smb = AasPartRegistry.createSubmodelBuilder((Aas.AasBuilder)aasBuilder, (String)"Configuration");
        InvocablesCreator iCreator = aasFactory.createInvocablesCreator((SetupSpec)aasSetup);
        ProtocolServerBuilder psb = aasFactory.createProtocolServerBuilder((SetupSpec)aasSetup);
        mapper.mapByType(smb, iCreator);
        mapper.bindOperations(psb);
        Submodel sm = (Submodel)smb.build();
        Aas aas = (Aas)aasBuilder.build();
        Server implServer = ((Server)psb.build()).start();
        try {
            AasPartRegistry.remoteDeploy((List)CollectionUtils.toList((Object[])new Aas[]{aas}));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String res = this.assertSubmodel(sm, appName, netIndex, servicesAsserter);
        this.stopEasy(lcd);
        implServer.stop(false);
        aasServer.stop(true);
        registryServer.stop(true);
        return format.fromString(res, mapper.getGraphFactory(), (DecisionVariableProvider)mapper);
    }

    private AasIvmlMapper getInstance(boolean adapt) {
        net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Configuration cfg = ConfigurationManager.getVilConfiguration();
        Assert.assertNotNull((String)"No configuration available", (Object)cfg);
        return new MyAasIvmlMapper(() -> cfg, (IvmlGraphMapper)new ServiceMeshGraphMapper(), adapt);
    }

    private String assertSubmodel(Submodel sm, String appName, int netIndex, Consumer<SubmodelElementCollection> servicesAsserter) throws ExecutionException {
        SubmodelElementList sel = sm.getSubmodelElementList("ServiceBase");
        Assert.assertNotNull((Object)sel);
        sel = sm.getSubmodelElementList("Application");
        Assert.assertNotNull((Object)sel);
        SubmodelElementCollection sec = sel.getSubmodelElementCollection(appName);
        Assert.assertNotNull((Object)sec);
        sel = sec.getSubmodelElementList("services");
        Assert.assertNotNull((Object)sel);
        SubmodelElementCollection varSmc = sel.getSubmodelElementCollection("var_" + netIndex);
        Assert.assertNotNull((Object)varSmc);
        Property prop = varSmc.getProperty("varValue");
        Assert.assertNotNull((Object)prop);
        String serviceNetName = prop.getValue().toString();
        Operation op = sm.getOperation("getGraph");
        Assert.assertNotNull((Object)op);
        String res = JsonResultWrapper.fromJson((Object)op.invoke(new Object[]{serviceNetName, "drawflow"}));
        Assert.assertNotNull((Object)res);
        return res;
    }

    @Test
    public void testGetVariable() throws ExecutionException {
        PlatformInstantiator.NonCleaningInstantiationConfigurer configurer = new PlatformInstantiator.NonCleaningInstantiationConfigurer(MODEL_NAME, ivmlFolder, FileUtils.getTempDirectory());
        ConfigurationLifecycleDescriptor lcd = this.startEasyValidate((PlatformInstantiator.InstantiationConfigurer)configurer);
        AasIvmlMapper mapper = this.getInstance(false);
        Assert.assertNotNull((Object)mapper.getVariable("instDir"));
        Assert.assertNull((Object)mapper.getVariable("instDir123"));
        Assert.assertNotNull((Object)mapper.getVariable("IIPEcosphere::instDir"));
        Assert.assertNotNull((Object)mapper.getVariable("aasServer"));
        this.stopEasy(lcd);
    }

    @Test
    public void testChangeValues() throws ExecutionException, IOException {
        PlatformInstantiator.NonCleaningInstantiationConfigurer configurer = new PlatformInstantiator.NonCleaningInstantiationConfigurer(MODEL_NAME, ivmlFolder, FileUtils.getTempDirectory());
        ConfigurationLifecycleDescriptor lcd = this.startEasyValidate((PlatformInstantiator.InstantiationConfigurer)configurer);
        AasIvmlMapper mapper = this.getInstance(false);
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("instDir", "\"/home/iip\"");
        values.put("javaExe", "\"/usr/local/java\"");
        values.put("deviceIdProvider", "HostnameDeviceIdProvider{class=\"a.b.C\", artifact=\"mg.art:art:1.2.3\"}");
        mapper.changeValues(values);
        this.assertStringVar("/home/iip", mapper.getVariable("instDir"));
        this.assertStringVar("/usr/local/java", mapper.getVariable("javaExe"));
        Assert.assertNotNull((Object)mapper.getVariable("deviceIdProvider"));
        this.assertStringVar("a.b.C", mapper.getVariable("deviceIdProvider").getNestedElement("class"));
        this.assertStringVar("mg.art:art:1.2.3", mapper.getVariable("deviceIdProvider.artifact"));
        this.assertIvmlFileChange(MODEL_NAME, false, "instDir", "javaExe", "deviceIdProvider");
        this.stopEasy(lcd);
        AasIvmlMapperTest.setupIvmlFiles();
    }

    @Test
    public void testChangeGraph() throws IOException, ExecutionException {
        PlatformInstantiator.NonCleaningInstantiationConfigurer configurer = new PlatformInstantiator.NonCleaningInstantiationConfigurer(MODEL_NAME, ivmlFolder, FileUtils.getTempDirectory());
        ConfigurationLifecycleDescriptor lcd = this.startEasyValidate((PlatformInstantiator.InstantiationConfigurer)configurer);
        DrawflowGraphFormat drawflowFormat = new DrawflowGraphFormat();
        DefaultGraph graph = new DefaultGraph(null);
        DefaultNode n1 = new DefaultNode(null);
        n1.setName("src");
        graph.addNode((IvmlGraphMapper.IvmlGraphNode)n1);
        DefaultNode n2 = new DefaultNode(null);
        n2.setName("Sink");
        n2.setImpl("snk");
        graph.addNode((IvmlGraphMapper.IvmlGraphNode)n2);
        DefaultEdge e1 = new DefaultEdge(null, (IvmlGraphMapper.IvmlGraphNode)n1, (IvmlGraphMapper.IvmlGraphNode)n2);
        n1.addEdge((IvmlGraphMapper.IvmlGraphEdge)e1);
        n2.addEdge((IvmlGraphMapper.IvmlGraphEdge)e1);
        AasIvmlMapper mapper = this.getInstance(true);
        mapper.addGraphFormat((GraphFormat)drawflowFormat);
        mapper.createVariable("rec1", "RecordType", false, "{}");
        String valueEx = "{id=\"SimpleSource\",name=\"Simple Data Source\",description=\"\",ver=\"0.1.0\",deployable=true,asynchronous=true,class=\"de.iip_ecosphere.platform.test.apps.serviceImpl.SimpleSourceImpl\",artifact=\"de.iip-ecosphere.platform:apps.ServiceImpl:0.4.0\",kind=ServiceKind::SOURCE_SERVICE,output={{type=rec1}}}";
        mapper.createVariable("src", "JavaService", false, valueEx);
        valueEx = "{id=\"SimpleSink\",name=\"Simple Data Sink\",description=\"\",ver=\"0.1.0\",deployable=true,asynchronous=true,class=\"de.iip_ecosphere.platform.test.apps.serviceImpl.SimpleSinkImpl\",artifact=\"de.iip-ecosphere.platform:apps.ServiceImpl:0.4.0\",kind=ServiceKind::SINK_SERVICE,input={{type=rec1}}}";
        mapper.createVariable("snk", "JavaService", false, valueEx);
        valueEx = "{id=\"myApp\",name=\"name\",description=\"\",ver=\"0.1.0\"}";
        mapper.setGraph("myApp", valueEx, "myMesh", drawflowFormat.getName(), drawflowFormat.toString((IvmlGraphMapper.IvmlGraph)graph));
        this.assertIvmlFileChange("AllTypes", false, "rec1");
        this.assertIvmlFileChange("AllServices", false, "src", "snk");
        this.assertIvmlFileChange("meshes/ServiceMeshPartMyMesh", false, "myMesh", "src", "Sink");
        this.assertIvmlFileChange("apps/ApplicationPartMyApp", false, "myApp");
        mapper.deleteGraph("myApp", "myMesh");
        Assert.assertFalse((boolean)this.resolveIvmlFile("meshes/ServiceMeshPartMyAppMyMesh").exists());
        this.assertIvmlFileChange("apps/ApplicationPartMyApp", false, "myApp");
        mapper.deleteGraph("myApp", null);
        Assert.assertFalse((boolean)this.resolveIvmlFile("meshes/ServiceMeshPartMyAppMyMesh").exists());
        Assert.assertFalse((boolean)this.resolveIvmlFile("apps/ApplicationPartMyApp").exists());
        this.stopEasy(lcd);
        AasIvmlMapperTest.setupIvmlFiles();
    }

    @Test
    public void testCreateDeleteVariable() throws IOException, ExecutionException {
        PlatformInstantiator.NonCleaningInstantiationConfigurer configurer = new PlatformInstantiator.NonCleaningInstantiationConfigurer(MODEL_NAME, ivmlFolder, FileUtils.getTempDirectory());
        ConfigurationLifecycleDescriptor lcd = this.startEasyValidate((PlatformInstantiator.InstantiationConfigurer)configurer);
        AasIvmlMapper mapper = this.getInstance(false);
        mapper.createVariable("rec1", "RecordType", false, "{}");
        String valueEx = "{id=\"SimpleSource\",name=\"Simple Data Source\",description=\"\",ver=\"0.1.0\",deployable=true,asynchronous=true,class=\"de.iip_ecosphere.platform.test.apps.serviceImpl.SimpleSourceImpl\",artifact=\"de.iip-ecosphere.platform:apps.ServiceImpl:0.4.0\",kind=ServiceKind::SOURCE_SERVICE,output={{type=rec1}}}";
        mapper.createVariable("test1", "JavaService", false, valueEx);
        this.assertIvmlFileChange("AllTypes", false, "rec1");
        this.assertIvmlFileChange("AllServices", false, "test1");
        mapper.deleteVariable("test1");
        this.assertIvmlFileChange("AllTypes", false, "rec1");
        this.assertIvmlFileChange("AllServices", true, "test1");
        mapper.createVariable("test2", "setOf(Integer)", false, "{25, 27}");
        this.assertIvmlFileChange("AllConstants", false, "test2");
        mapper.deleteVariable("test2");
        this.assertIvmlFileChange("AllConstants", true, "test2");
        this.stopEasy(lcd);
        AasIvmlMapperTest.setupIvmlFiles();
    }

    @Test
    public void testGetTemplates() throws IOException, ExecutionException {
        PlatformInstantiator.NonCleaningInstantiationConfigurer configurer = new PlatformInstantiator.NonCleaningInstantiationConfigurer(MODEL_NAME, ivmlFolder, FileUtils.getTempDirectory());
        ConfigurationLifecycleDescriptor lcd = this.startEasyValidate((PlatformInstantiator.InstantiationConfigurer)configurer);
        AasIvmlMapper mapper = this.getInstance(false);
        String templates = mapper.getTemplates();
        Assert.assertNotNull((Object)templates);
        List templatesList = JsonUtils.listFromJson((Object)templates, String.class);
        Assert.assertNotNull((Object)templatesList);
        Assert.assertTrue((boolean)templatesList.contains("tplApp"));
        this.stopEasy(lcd);
        AasIvmlMapperTest.setupIvmlFiles();
    }

    @Test
    public void testRenameVariable() throws IOException, ExecutionException, ModelQueryException {
        PlatformInstantiator.NonCleaningInstantiationConfigurer configurer = new PlatformInstantiator.NonCleaningInstantiationConfigurer(MODEL_NAME, ivmlFolder, FileUtils.getTempDirectory());
        ConfigurationLifecycleDescriptor lcd = this.startEasyValidate((PlatformInstantiator.InstantiationConfigurer)configurer);
        AasIvmlMapper mapper = this.getInstance(false);
        mapper.renameVariable("myMesh", "myMesh1");
        Configuration cfg = ConfigurationManager.getIvmlConfiguration();
        Project root = cfg.getProject();
        AbstractVariable var = IvmlModelQuery.findVariable((IResolutionScope)root, (String)"myMesh", null);
        Assert.assertNull((Object)var);
        var = IvmlModelQuery.findVariable((IResolutionScope)root, (String)"myMesh1", null);
        Assert.assertNotNull((Object)var);
        Assert.assertEquals((Object)"ServiceMeshPartMyMesh", (Object)var.getProject().getName());
        this.stopEasy(lcd);
        AasIvmlMapperTest.setupIvmlFiles();
    }

    @Test
    public void testInstantiateTemplate() throws IOException, ExecutionException, ModelQueryException {
        PlatformInstantiator.NonCleaningInstantiationConfigurer configurer = new PlatformInstantiator.NonCleaningInstantiationConfigurer(MODEL_NAME, ivmlFolder, FileUtils.getTempDirectory());
        ConfigurationLifecycleDescriptor lcd = this.startEasyValidate((PlatformInstantiator.InstantiationConfigurer)configurer);
        AasIvmlMapper mapper = this.getInstance(false);
        HashMap<String, String> adjustments = new HashMap<String, String>();
        adjustments.put("tplApp.name", "myTestingTemplateApp");
        String appVarName = "testTemplateApp";
        String res = mapper.instantiateTemplate("tplApp", "testTemplateApp", adjustments);
        Assert.assertNotNull((Object)res);
        Assert.assertEquals((Object)"testTemplateApp", (Object)res);
        this.stopEasy(lcd);
        AasIvmlMapperTest.setupIvmlFiles();
    }

    @Test
    public void getOpenTemplateVariables() throws IOException, ExecutionException, ModelQueryException {
        PlatformInstantiator.NonCleaningInstantiationConfigurer configurer = new PlatformInstantiator.NonCleaningInstantiationConfigurer(MODEL_NAME, ivmlFolder, FileUtils.getTempDirectory());
        ConfigurationLifecycleDescriptor lcd = this.startEasyValidate((PlatformInstantiator.InstantiationConfigurer)configurer);
        AasIvmlMapper mapper = this.getInstance(false);
        String openVars = mapper.getOpenTemplateVariables("tplApp");
        Assert.assertNotNull((Object)openVars);
        List openVarsList = JsonUtils.listFromJson((Object)openVars, String.class);
        Assert.assertNotNull((Object)mapper);
        Assert.assertTrue((String)"tplApp.name expected to be open", (boolean)openVarsList.contains("tplApp.name"));
        this.stopEasy(lcd);
        AasIvmlMapperTest.setupIvmlFiles();
    }

    private void assertStringVar(String expected, IDecisionVariable var) {
        Assert.assertNotNull((Object)var);
        Assert.assertEquals((Object)expected, (Object)IvmlUtils.getStringValue((IDecisionVariable)var, (String)""));
    }

    private void assertBooleanVar(boolean expected, IDecisionVariable var) {
        Assert.assertNotNull((Object)var);
        Assert.assertEquals((Object)expected, (Object)IvmlUtils.getBooleanValue((IDecisionVariable)var, (!expected ? 1 : 0) != 0));
    }

    private void assertIntVar(int expected, IDecisionVariable var) {
        Assert.assertNotNull((Object)var);
        Assert.assertEquals((long)expected, (long)IvmlUtils.getIntValue((IDecisionVariable)var, (int)-1));
    }

    private File resolveIvmlFile(String file) {
        if (!((String)file).endsWith(".ivml")) {
            file = (String)file + ".ivml";
        }
        return new File(ivmlFolder, (String)file);
    }

    private void assertIvmlFileChange(String file, boolean invert, String ... expected) {
        if (!((String)file).endsWith(".ivml")) {
            file = (String)file + ".ivml";
        }
        try {
            String contents = FileUtils.readFileToString((File)this.resolveIvmlFile((String)file), (Charset)Charset.defaultCharset());
            for (String e : expected) {
                boolean found = contents.contains(e);
                if (invert) {
                    found = !found;
                }
                Assert.assertTrue((String)("Not found " + Arrays.toString(expected) + " in: " + contents), (boolean)found);
            }
        }
        catch (IOException e) {
            Assert.fail((String)("Cannot read " + (String)file + ": " + e.getMessage()));
        }
    }

    @Test
    public void testGetVariableName() {
        varNames.clear();
        PlatformInstantiator.NonCleaningInstantiationConfigurer configurer = new PlatformInstantiator.NonCleaningInstantiationConfigurer(MODEL_NAME, ivmlFolder, FileUtils.getTempDirectory());
        ConfigurationLifecycleDescriptor lcd = this.startEasyValidate((PlatformInstantiator.InstantiationConfigurer)configurer);
        AasIvmlMapper mapper = this.getInstance(false);
        AasIvmlMapperTest.assertVariableName(mapper.getVariableName("", "", ""));
        AasIvmlMapperTest.assertVariableName(mapper.getVariableName("String", "test my String", "1.01"));
        AasIvmlMapperTest.assertVariableName(mapper.getVariableName("String", "test my String", "1.01"));
        AasIvmlMapperTest.assertVariableName(mapper.getVariableName("String", "test my String", "1.01"));
        this.stopEasy(lcd);
        varNames.clear();
    }

    private static void assertVariableName(String variableName) {
        Assert.assertNotNull((Object)variableName);
        Assert.assertTrue((variableName.length() > 0 ? 1 : 0) != 0);
        boolean hasValidChars = true;
        for (int i = 0; i < variableName.length(); ++i) {
            hasValidChars &= Character.isJavaIdentifierPart(variableName.charAt(i));
        }
        Assert.assertTrue((boolean)hasValidChars);
        Assert.assertTrue((boolean)Character.isJavaIdentifierStart(variableName.charAt(0)));
        Assert.assertFalse((boolean)varNames.contains(variableName));
        varNames.add(variableName);
    }

    static {
        varNames = new HashSet<String>();
    }

    private static class MyAasIvmlMapper
    extends AasIvmlMapper {
        private boolean adapt;

        public MyAasIvmlMapper(Supplier<net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Configuration> cfgSupplier, IvmlGraphMapper graphMapper, boolean adapt) {
            super(cfgSupplier, graphMapper, null);
            this.adapt = adapt;
        }

        protected Project adaptTarget(Project root, Project project) throws ExecutionException {
            String prjName = project.getName();
            if (this.adapt && ("AllServices".equals(prjName) || "AllTypes".equals(prjName))) {
                boolean found = false;
                for (int i = project.getImportsCount() - 1; i >= 0; --i) {
                    ProjectImport imp = project.getImport(i);
                    if (!imp.isWildcard()) continue;
                    project.removeImport(imp);
                    found = true;
                }
                if (found) {
                    try {
                        if ("AllServices".equals(prjName)) {
                            ProjectImport imp = new ProjectImport("AllTypes");
                            imp.setResolved(ModelQuery.findProject((Project)root, (String)"AllTypes"));
                            project.addImport(imp);
                        } else if ("AllTypes".equals(prjName)) {
                            ProjectImport imp = new ProjectImport("IIPEcosphere");
                            imp.setResolved(ModelQuery.findProject((Project)root, (String)"IIPEcosphere"));
                            project.addImport(imp);
                        }
                    }
                    catch (ModelManagementException e) {
                        throw new ExecutionException(e);
                    }
                }
            }
            return project;
        }
    }
}

