/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.configuration.easyProducer.aas;

import de.iip_ecosphere.platform.configuration.easyProducer.aas.AasSpecSummary;
import de.iip_ecosphere.platform.configuration.easyProducer.aas.IvmlWriter;
import de.iip_ecosphere.platform.configuration.easyProducer.aas.RowProcessor;
import de.iip_ecosphere.platform.support.logging.Logger;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ReadExcelFile {
    public static AasSpecSummary read(String fileName) throws IOException {
        FileInputStream fis = new FileInputStream(fileName);
        XSSFWorkbook workbook = null;
        if (fileName.toLowerCase().endsWith("xlsx")) {
            workbook = new XSSFWorkbook((InputStream)fis);
        } else if (fileName.toLowerCase().endsWith("xls")) {
            workbook = new HSSFWorkbook((InputStream)fis);
        }
        DataFormatter fmt = new DataFormatter();
        int numberOfSheets = workbook.getNumberOfSheets();
        RowProcessor rowProcessor = new RowProcessor();
        for (int s = 0; s < numberOfSheets; ++s) {
            Sheet sheet = workbook.getSheetAt(s);
            HashSet<CallSite> merged = new HashSet<CallSite>();
            for (int m = 0; m < sheet.getNumMergedRegions(); ++m) {
                CellRangeAddress cra = sheet.getMergedRegion(m);
                for (int r = cra.getFirstRow(); r <= cra.getLastRow(); ++r) {
                    for (int c = cra.getFirstColumn(); c <= cra.getLastColumn(); ++c) {
                        if (r == cra.getFirstRow() && c == cra.getFirstColumn()) continue;
                        merged.add((CallSite)((Object)(r + "_" + c)));
                    }
                }
            }
            ReadExcelFile.getLogger().info("Processing {}", (Object)sheet.getSheetName());
            Iterator rowIterator = sheet.iterator();
            int rowCount = 0;
            while (rowIterator.hasNext()) {
                Row row = (Row)rowIterator.next();
                rowProcessor.startRow();
                Iterator cellIterator = row.cellIterator();
                int colCount = 0;
                while (cellIterator.hasNext()) {
                    Cell cell = (Cell)cellIterator.next();
                    if (!merged.contains(rowCount + "_" + colCount)) {
                        String data = null;
                        switch (cell.getCellType()) {
                            case STRING: {
                                data = ReadExcelFile.getCellStringValue(cell);
                                break;
                            }
                            case BOOLEAN: {
                                data = String.valueOf(cell.getBooleanCellValue());
                                break;
                            }
                            case BLANK: {
                                data = null;
                                break;
                            }
                            case NUMERIC: {
                                data = fmt.formatCellValue(cell);
                                break;
                            }
                            default: {
                                ReadExcelFile.getLogger().warn("Unexpected XLS cell type: {}", (Object)cell.getCellType());
                            }
                        }
                        rowProcessor.addDataToRow(data);
                    }
                    ++colCount;
                }
                rowProcessor.endRow();
                ++rowCount;
            }
        }
        rowProcessor.readingCompleted();
        fis.close();
        return rowProcessor.getSummary();
    }

    public static void readExcelData(String fileName, String outFile) {
        ReadExcelFile.readExcelData(fileName, outFile, null);
    }

    public static void readExcelData(String fileName, String outFile, String idShortPrefix) {
        try {
            AasSpecSummary result = ReadExcelFile.read(fileName);
            result.printStatistics(System.out);
            IvmlWriter writer = new IvmlWriter(outFile).setNamePrefix(idShortPrefix);
            writer.toIvml(result);
            writer.toIvmlText(result);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static String getCellStringValue(Cell cell) {
        String data;
        RichTextString rts = cell.getRichStringCellValue();
        if (rts instanceof XSSFRichTextString) {
            XSSFRichTextString xrts = (XSSFRichTextString)rts;
            data = xrts.getString();
            if (null != data && data.length() > 0 && data.trim().startsWith("[")) {
                XSSFFont startFont;
                StringBuilder tmp = new StringBuilder(data);
                XSSFFont currentFont = startFont = xrts.getFontAtIndex(0);
                for (int i = 1; i < tmp.length(); ++i) {
                    XSSFFont font = xrts.getFontAtIndex(i);
                    boolean fontDiff = false;
                    if (null == currentFont) {
                        fontDiff = font != null;
                    } else {
                        boolean bl = fontDiff = !currentFont.equals((Object)font);
                    }
                    if (fontDiff) {
                        char c = tmp.charAt(i);
                        if (!startFont.equals((Object)font) && startFont.getFontHeight() - font.getFontHeight() > 1 && Character.isDigit(c)) {
                            tmp.deleteCharAt(i);
                            --i;
                        }
                    }
                    currentFont = font;
                }
                data = tmp.toString();
            }
        } else {
            data = cell.getStringCellValue();
        }
        return data;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(ReadExcelFile.class);
    }

    public static void main(String ... args) {
        if (args.length == 1) {
            ReadExcelFile.readExcelData(args[0], null);
        } else if (args.length >= 2) {
            ReadExcelFile.readExcelData(args[0], args[1], args.length >= 3 ? args[2] : null);
        } else {
            String baseDir = "src/test/resources/idta/";
            ReadExcelFile.readExcelData(baseDir + "2056/IDTA 02056-1-0_Submodel_Data Retention Policies.xlsx", null);
        }
    }
}

