/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.configuration.easyProducer.opcua.data;

import de.iip_ecosphere.platform.configuration.easyProducer.opcua.data.BaseType;
import de.iip_ecosphere.platform.configuration.easyProducer.opcua.data.DataLiteral;
import java.util.ArrayList;

public class DataType
extends BaseType {
    private String documentation;
    private ArrayList<DataLiteral> literals;

    public DataType(String nodeId, String browseName, String displayName, String description, String documentation, ArrayList<DataLiteral> literals) {
        super(nodeId, browseName, displayName, description, false);
        this.documentation = documentation;
        this.literals = literals;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public ArrayList<DataLiteral> getLiterals() {
        return this.literals;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("\tUADataType " + this.getVarName() + " = {\n");
        builder.append("\t\tname = \"" + this.getVarName() + "\",\n");
        builder.append("\t\t" + DataType.formatNodeId(this.getNodeId()) + "\n");
        builder.append("\t\tnodeClass = NodeClass::UADataType,\n");
        builder.append("\t\tbrowseName = \"" + this.getBrowseName() + "\",\n");
        builder.append("\t\tdisplayName = \"" + this.getDisplayname() + "\",\n");
        builder.append("\t\tdescription = \"" + this.getDescription() + "\",\n");
        builder.append("\t\tdocumentation = \"" + this.getDocumentation() + "\"");
        builder.append(",\n\t\tliterals = {\n");
        if (!this.literals.isEmpty()) {
            builder.append("\t\t\t");
            for (DataLiteral l : this.literals) {
                builder.append(l.toString());
                if (l.equals(this.literals.get(this.literals.size() - 1))) {
                    builder.append("\t\t\t}\n");
                    continue;
                }
                builder.append("\t\t\t}, ");
            }
        }
        builder.append("\t\t}\n");
        builder.append("\t};\n\n");
        return builder.toString();
    }
}

