/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.configuration.easyProducer.serviceMesh;

import de.iip_ecosphere.platform.configuration.easyProducer.serviceMesh.ServiceMeshEdge;
import de.iip_ecosphere.platform.configuration.easyProducer.serviceMesh.ServiceMeshGraph;
import de.iip_ecosphere.platform.configuration.easyProducer.serviceMesh.ServiceMeshNode;
import java.util.HashMap;
import java.util.Map;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;

class ServiceMeshGraphWalker {
    private ServiceMeshGraph result;
    private Map<IDecisionVariable, ServiceMeshNode> nodes = new HashMap<IDecisionVariable, ServiceMeshNode>();

    public ServiceMeshGraphWalker(IDecisionVariable var) {
        this.result = new ServiceMeshGraph(var);
        this.traverseNodes(var.getNestedElement("sources"));
    }

    public ServiceMeshGraph getResult() {
        return this.result;
    }

    private void traverseNodes(IDecisionVariable var) {
        if (null != var) {
            for (int n = 0; n < var.getNestedElementsCount(); ++n) {
                IDecisionVariable elt = Configuration.dereference((IDecisionVariable)var.getNestedElement(n));
                ServiceMeshNode node = this.nodes.get(elt);
                if (null != node) continue;
                node = this.createNode(elt);
                this.traverseConnectors(elt.getNestedElement("next"), node);
            }
        }
    }

    private void traverseConnectors(IDecisionVariable var, ServiceMeshNode from) {
        if (null != var) {
            for (int n = 0; n < var.getNestedElementsCount(); ++n) {
                IDecisionVariable conn = Configuration.dereference((IDecisionVariable)var.getNestedElement(n));
                IDecisionVariable next = Configuration.dereference((IDecisionVariable)conn.getNestedElement("next"));
                ServiceMeshNode node = this.nodes.get(next);
                if (null == node) {
                    node = this.createNode(next);
                    this.traverseConnectors(next.getNestedElement("next"), node);
                }
                from.addEdge(new ServiceMeshEdge(conn, from, node));
                node.addEdge(new ServiceMeshEdge(conn, from, node));
            }
        }
    }

    private ServiceMeshNode createNode(IDecisionVariable elt) {
        ServiceMeshNode node = new ServiceMeshNode(elt);
        this.nodes.put(elt, node);
        this.result.addNode(node);
        return node;
    }
}

