/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.configuration.easyProducer;

import de.iip_ecosphere.platform.configuration.easyProducer.ConfigurationSetup;
import de.iip_ecosphere.platform.configuration.easyProducer.DrawflowGraphFormat;
import de.iip_ecosphere.platform.configuration.easyProducer.EasySetup;
import de.iip_ecosphere.platform.configuration.easyProducer.ivml.AasIvmlMapper;
import de.iip_ecosphere.platform.configuration.easyProducer.ivml.IvmlUtils;
import de.iip_ecosphere.platform.configuration.easyProducer.serviceMesh.ServiceMeshGraphMapper;
import de.iip_ecosphere.platform.support.FileUtils;
import de.iip_ecosphere.platform.support.TaskRegistry;
import de.iip_ecosphere.platform.support.identities.IdentityStore;
import de.iip_ecosphere.platform.support.identities.IdentityToken;
import de.iip_ecosphere.platform.support.json.JsonResultWrapper;
import de.iip_ecosphere.platform.support.logging.Logger;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.transport.Transport;
import de.iip_ecosphere.platform.transport.status.ActionType;
import de.iip_ecosphere.platform.transport.status.ActionTypes;
import de.iip_ecosphere.platform.transport.status.StatusMessage;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.basics.progress.BasicProgressObserver;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.NoVariableFilter;
import net.ssehub.easy.producer.core.mgmt.EasyExecutor;
import net.ssehub.easy.reasoning.core.reasoner.ReasoningResult;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.model.ModelQueryException;
import net.ssehub.easy.varModel.model.Project;

public class ConfigurationManager {
    private static EasyExecutor executor;
    private static boolean initialized;
    private static BasicProgressObserver observer;
    private static AasIvmlMapper aasIvmlMapper;
    private static JsonResultWrapper.OperationCompletedListener aasOpListener;
    private static boolean standalone;
    private static OktoProgressMonitor progressMonitor;

    public static TaskRegistry.TaskData setTaskData(TaskRegistry.TaskData taskData) {
        return progressMonitor.setTaskData(taskData);
    }

    static void setExecutor(EasyExecutor instance) {
        executor = instance;
        if (null == instance) {
            initialized = false;
        } else {
            executor.setProgressObserver((ProgressObserver)observer);
        }
    }

    static void setStandalone(boolean isStandalone) {
        standalone = isStandalone;
    }

    static EasyExecutor getExecutor() {
        return executor;
    }

    private static void init() {
        if (!initialized) {
            if (null != executor) {
                try {
                    long start = System.currentTimeMillis();
                    executor.loadIvmlModel();
                    ConfigurationManager.getLogger().info("Loaded EASy-Producer models in {} ms", (Object)(System.currentTimeMillis() - start));
                }
                catch (ModelManagementException e) {
                    ConfigurationManager.getLogger().error("Cannot load EASy-Producer models: " + e.getMessage());
                }
            }
            if (null == aasIvmlMapper) {
                aasIvmlMapper = new AasIvmlMapper(() -> ConfigurationManager.getVilConfiguration(), new ServiceMeshGraphMapper(), null);
                aasIvmlMapper.addGraphFormat(new DrawflowGraphFormat());
            }
            initialized = true;
        }
    }

    public static void reload() {
        if (null != executor) {
            try {
                long start = System.currentTimeMillis();
                executor.discardLocations();
                executor.clearModels();
                executor.setupLocations();
                executor.loadIvmlModel();
                ConfigurationManager.getLogger().info("Reoaded EASy-Producer models in {} ms", (Object)(System.currentTimeMillis() - start));
            }
            catch (ModelManagementException e) {
                ConfigurationManager.getLogger().error("Cannot load EASy-Producer models: " + e.getMessage());
            }
        } else {
            ConfigurationManager.getLogger().error("No executor, cannot reload EASy-Producer models");
        }
    }

    public static Configuration getIvmlConfiguration() {
        ConfigurationManager.init();
        return executor != null ? executor.getConfiguration() : null;
    }

    public static void setupContainerProperties() {
        Configuration cfg = ConfigurationManager.getIvmlConfiguration();
        String containerAuthKeyDecName = "containerManager.authenticationKey";
        try {
            IDecisionVariable varAuthKey = cfg.getDecision("containerManager.authenticationKey", false);
            String authKey = IvmlUtils.getStringValue(varAuthKey, "");
            if (authKey.length() > 0) {
                IdentityToken tok = IdentityStore.getInstance().getToken(authKey, new String[0]);
                if (null != tok && IdentityToken.TokenType.USERNAME == tok.getType()) {
                    System.setProperty("iip.container.user." + authKey, tok.getUserName());
                    System.setProperty("iip.container.password." + authKey, tok.getTokenDataAsString());
                } else {
                    LoggerFactory.getLogger(ConfigurationManager.class).warn("No (username) identity token for key '{}' found. Container deployment may fail", (Object)authKey);
                }
            } else {
                LoggerFactory.getLogger(ConfigurationManager.class).warn("No autentication key/value for decision variable '{}' found. Container deployment may fail", (Object)"containerManager.authenticationKey");
            }
        }
        catch (ModelQueryException e) {
            LoggerFactory.getLogger(ConfigurationManager.class).warn("No decision variable '{}' found. Container deployment may fail. {}", (Object)"containerManager.authenticationKey", (Object)e.getMessage());
        }
    }

    public static net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Configuration getVilConfiguration() {
        ConfigurationManager.init();
        Configuration cfg = ConfigurationManager.getIvmlConfiguration();
        return cfg != null ? new net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Configuration(cfg, NoVariableFilter.INSTANCE) : null;
    }

    public static ReasoningResult validateAndPropagate() {
        return ConfigurationManager.validateAndPropagate(null);
    }

    public static ReasoningResult validateAndPropagate(Predicate<Project> projectFilter) {
        ConfigurationManager.init();
        try {
            if (executor != null) {
                long start = System.currentTimeMillis();
                executor.setReasoningProjectFilter(null == projectFilter ? p -> true : projectFilter);
                ReasoningResult result = executor.propagateOnIvmlModel();
                ConfigurationManager.getLogger().info("EASy-Producer model reasoning done in {} ms", (Object)(System.currentTimeMillis() - start));
                return result;
            }
            return null;
        }
        catch (IllegalStateException e) {
            ConfigurationManager.getLogger().error(e.getMessage());
            return null;
        }
        catch (Throwable e) {
            ConfigurationManager.getLogger().error(e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    public static void cleanGenTarget() throws ExecutionException {
        EasySetup easySetup = ConfigurationSetup.getSetup().getEasyProducer();
        try {
            if (easySetup.getGenTarget().exists()) {
                FileUtils.deleteDirectory((File)easySetup.getGenTarget());
            }
        }
        catch (IOException e) {
            throw new ExecutionException(e);
        }
    }

    public static void instantiate(String startRuleName) throws ExecutionException {
        ConfigurationManager.init();
        if (executor != null) {
            try {
                long start = System.currentTimeMillis();
                executor.setVilStartRuleName(startRuleName);
                executor.executeVil();
                ConfigurationManager.getLogger().info("EASy-Producer instantiation done in {} ms", (Object)(System.currentTimeMillis() - start));
            }
            catch (IllegalStateException | ModelManagementException | VilException e) {
                throw new ExecutionException(e);
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw new ExecutionException(e);
            }
        }
    }

    public static void instantiate() throws ExecutionException {
        ConfigurationManager.instantiate("main");
    }

    public static void setAasIvmlMapper(AasIvmlMapper mapper) {
        if (null != mapper) {
            aasIvmlMapper = mapper;
        }
    }

    public static AasIvmlMapper getAasIvmlMapper() {
        ConfigurationManager.init();
        return aasIvmlMapper;
    }

    public static void setAasOperationCompletedListener(JsonResultWrapper.OperationCompletedListener listener) {
        aasOpListener = listener;
    }

    public static JsonResultWrapper.OperationCompletedListener getAasOperationCompletedListener() {
        return aasOpListener;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(ConfigurationManager.class);
    }

    static {
        initialized = false;
        observer = new BasicProgressObserver();
        standalone = false;
        progressMonitor = new OktoProgressMonitor();
        observer = new BasicProgressObserver();
        observer.register((BasicProgressObserver.IProgressMonitor)progressMonitor);
    }

    private static class OktoProgressMonitor
    implements BasicProgressObserver.IProgressMonitor {
        private String taskName;
        private int maxSteps;
        private int steps;
        private String subTask;
        private int lastSteps = -1;
        private int lastMaxSteps = -1;
        private TaskRegistry.TaskData taskData;

        private OktoProgressMonitor() {
        }

        public void setTaskName(String name) {
        }

        TaskRegistry.TaskData setTaskData(TaskRegistry.TaskData taskData) {
            TaskRegistry.TaskData result = this.taskData;
            this.taskData = taskData;
            return result;
        }

        private void sendStatus() {
            Object heading;
            String[] alias;
            if (null != this.subTask) {
                alias = new String[]{this.taskName, this.subTask};
                heading = this.taskName + "/" + this.subTask;
            } else {
                alias = new String[]{this.taskName};
                heading = this.taskName;
            }
            if (this.lastSteps != this.steps || this.lastMaxSteps != this.maxSteps) {
                int progress = 0;
                if (this.steps > 0 && this.maxSteps > 0) {
                    progress = (int)((double)this.steps / (double)this.maxSteps * 100.0);
                }
                if (!standalone) {
                    StatusMessage msg = new StatusMessage((ActionType)ActionTypes.PROCESS, "Configuration", alias);
                    if (this.taskData != null) {
                        msg.withTask(this.taskData);
                    } else {
                        msg.withTask();
                    }
                    if (this.maxSteps > 0) {
                        msg.withProgress(progress);
                    }
                    msg.withDescription((String)heading);
                    Transport.sendStatus((StatusMessage)msg);
                }
                this.lastSteps = this.steps;
                this.lastMaxSteps = this.maxSteps;
                if (this.steps >= this.maxSteps && null != this.taskData) {
                    TaskRegistry.stopTask((String)this.taskData.getId());
                }
            }
        }

        public void beginTask(String name, int max) {
            if (null != name) {
                this.steps = -1;
                this.subTask = null;
                this.taskName = name;
            }
            this.maxSteps = max;
            this.sendStatus();
        }

        public void worked(int step) {
            this.steps = step;
            this.sendStatus();
        }

        public void subTask(String name) {
            this.subTask = name;
            this.sendStatus();
        }
    }
}

