/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.configuration.easyProducer;

import de.iip_ecosphere.platform.configuration.easyProducer.ConfigurationSetup;
import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.ssehub.easy.varModel.model.ModelElement;
import net.ssehub.easy.varModel.model.Project;

public class ModelInfo {
    private static Map<Project, Boolean> metaProjects = new HashMap<Project, Boolean>();

    public static String getFileName(Project prj) {
        return prj.getName() + ".ivml";
    }

    public static boolean isMetaProject(Project prj) {
        Boolean result = metaProjects.get(prj);
        if (null == result) {
            File base = ConfigurationSetup.getSetup().getEasyProducer().getIvmlMetaModelFolder();
            result = ModelInfo.contains(base, ModelInfo.getFileName(prj));
            metaProjects.put(prj, result);
        }
        return result;
    }

    private static boolean contains(File folder, String file) {
        boolean found = false;
        File[] files = folder.listFiles();
        if (null != files) {
            for (File f : files) {
                if (f.isFile() && f.getName().equals(file)) {
                    found = true;
                    break;
                }
                if (f.isDirectory() && (found = ModelInfo.contains(f, file))) break;
            }
        }
        return found;
    }

    public static boolean hasComment(ModelElement elt) {
        return ModelInfo.getCommentSafe(elt).length() > 0;
    }

    public static String getCommentSafe(ModelElement elt) {
        String result = elt.getComment();
        return null == result ? "" : result;
    }

    public static Locale getLocale() {
        return Locale.getDefault();
    }
}

