/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.configuration.easyProducer.aas;

import de.iip_ecosphere.platform.configuration.easyProducer.aas.AasSmeType;
import de.iip_ecosphere.platform.configuration.easyProducer.aas.AbstractAasElement;
import de.iip_ecosphere.platform.support.logging.Logger;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import java.util.HashSet;
import java.util.Set;

public class AasField
extends AbstractAasElement {
    private static final Set<String> BASIC_TYPES = new HashSet<String>();
    private AasSmeType smeType;
    private boolean isMultiValued;
    private String valueType;
    private String[] exampleValues;
    private String exampleExplanation;
    private int lowerCardinality = Integer.MIN_VALUE;
    private int upperCardinality = Integer.MIN_VALUE;
    private String aspect;

    AasField() {
    }

    AasField(AasField field) {
        super(field);
        this.smeType = field.smeType;
        this.isMultiValued = field.isMultiValued;
        this.valueType = field.valueType;
        if (null != field.exampleValues) {
            this.exampleValues = new String[field.exampleValues.length];
            System.arraycopy(field.exampleValues, 0, this.exampleValues, 0, this.exampleValues.length);
        }
        this.exampleExplanation = field.exampleExplanation;
        this.lowerCardinality = field.lowerCardinality;
        this.upperCardinality = field.upperCardinality;
        this.aspect = field.aspect;
    }

    void setSmeType(AasSmeType smeType) {
        this.smeType = smeType;
    }

    public AasSmeType getSmeType() {
        return this.smeType;
    }

    void setIdShort(String idShort, boolean isMultiValued) {
        this.setIdShort(idShort);
        this.isMultiValued = isMultiValued;
    }

    public boolean isMultiValued() {
        return this.isMultiValued;
    }

    public String getAspect() {
        return this.aspect;
    }

    void setAspect(String aspect) {
        this.aspect = aspect;
    }

    void setValueType(String valueType) {
        this.valueType = valueType;
    }

    public boolean hasValueType() {
        return this.valueType != null && this.valueType.length() > 0;
    }

    void setExampleValues(String ... value) {
        this.exampleValues = value;
    }

    public String[] getExampleValues() {
        return this.exampleValues;
    }

    void setExampleExplanation(String exampleExplanation) {
        this.exampleExplanation = exampleExplanation;
    }

    public String getExampleExplanation() {
        return this.exampleExplanation;
    }

    void setCardinality(int lowerUpper) {
        this.setCardinality(lowerUpper, lowerUpper);
    }

    void setCardinality(int lowerCardinality, int upperCardinality) {
        this.lowerCardinality = lowerCardinality;
        this.upperCardinality = upperCardinality;
    }

    public int getLowerCardinality() {
        return this.lowerCardinality;
    }

    public int getUpperCardinality() {
        return this.upperCardinality;
    }

    public boolean hasCardinality() {
        return this.lowerCardinality == Integer.MIN_VALUE || this.upperCardinality == Integer.MIN_VALUE;
    }

    public String getValueType() {
        return this.valueType;
    }

    public static boolean isBasicType(String type) {
        return BASIC_TYPES.contains(type);
    }

    static String mapPropertyType(String valueType, String dflt) {
        String result = null;
        if (valueType != null && valueType.length() > 0) {
            switch (valueType) {
                case "listofProperties<string>": 
                case "xs:string": 
                case "String": 
                case "string": 
                case "STRING": {
                    result = "StringType";
                    break;
                }
                case "Decimal": 
                case "int": 
                case "integer": 
                case "Integer(count)": 
                case "Integer (count)": 
                case "INTEGER_COUNT": 
                case "xs:integer": 
                case "xs:int": 
                case "Integer": {
                    result = "IntegerType";
                    break;
                }
                case "LONG": 
                case "xs:long": 
                case "long": {
                    result = "LongType";
                    break;
                }
                case "Float": 
                case "float": {
                    result = "FloatType";
                    break;
                }
                case "xs:double": 
                case "Double": 
                case "double": 
                case "Real": 
                case "REAL_MEASURE": 
                case "real": {
                    result = "DoubleType";
                    break;
                }
                case "STRING_TRANSLATABLE": {
                    result = "AasMultiLangStringType";
                    break;
                }
                case "unsignedShort": {
                    result = "UnsignedInteger16Type";
                    break;
                }
                case "unsignedInt": {
                    result = "UnsignedInteger32Type";
                    break;
                }
                case "xs:unsignedLong": 
                case "unsignedLong": {
                    result = "UnsignedInteger64Type";
                    break;
                }
                case "xs:boolean": 
                case "boolean": 
                case "Boolean": {
                    result = "BooleanType";
                    break;
                }
                case "xs:anyURI": 
                case "anyURI": {
                    result = "AasAnyURIType";
                    break;
                }
                case "file": {
                    result = "AasFileResourceType";
                    break;
                }
                case "Blob": {
                    result = "AasBlobType";
                    break;
                }
                case "LangStringSet": 
                case "langString": {
                    result = "AasLangStringType";
                    break;
                }
                case "dateTimeStamp": 
                case "TIMESTSAMP": 
                case "Date": 
                case "dateTime": 
                case "DateTime": 
                case "xs:dateTime": 
                case "TimeStamp": 
                case "date": {
                    result = "DateTimeType";
                    break;
                }
                default: {
                    result = dflt;
                }
            }
        }
        return result;
    }

    public String getIvmlValueType(boolean log) {
        String result = null;
        if (null == this.smeType) {
            this.smeType = AasSmeType.PROPERTY;
        }
        if (AasSmeType.PROPERTY == this.smeType) {
            result = AasField.mapPropertyType(this.valueType, this.valueType);
        }
        if (null == result && this.smeType != null) {
            switch (this.smeType) {
                case SUBMODEL_ELEMENT_LIST: 
                case SUBMODEL_ELEMENT_COLLECTION: {
                    if (null != this.valueType && this.valueType.length() > 0) {
                        result = this.valueType;
                        break;
                    }
                    result = "AasGenericSubmodelElementCollection";
                    break;
                }
                case MULTI_LANGUAGE_PROPERTY: {
                    result = "AasMultiLangStringType";
                    break;
                }
                case FILE: {
                    result = "AasFileResourceType";
                    break;
                }
                case REFERENCE: {
                    result = "AasReferenceType";
                    break;
                }
                case RELATION: {
                    result = "AasRelationType";
                    break;
                }
                case ENTITY: {
                    if (null != this.valueType && this.valueType.length() > 0) {
                        result = this.valueType;
                        break;
                    }
                    result = "AasGenericEntityType";
                    break;
                }
                case BLOB: {
                    result = "AasBlobType";
                    break;
                }
                case RANGE: {
                    result = "AasRangeType";
                    break;
                }
                default: {
                    result = "StringType";
                    if (!log) break;
                    AasField.getLogger().warn("No type mapping specified for valueType '{}' / smeType '{}'. Mapping to {}.", new Object[]{this.valueType, this.smeType, result});
                }
            }
        }
        return "refBy(" + result + ")";
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(AasField.class);
    }

    static {
        BASIC_TYPES.add("StringType");
        BASIC_TYPES.add("IntegerType");
        BASIC_TYPES.add("RealType");
        BASIC_TYPES.add("BooleanType");
        BASIC_TYPES.add("LongType");
        BASIC_TYPES.add("FloatType");
        BASIC_TYPES.add("DoubleType");
        BASIC_TYPES.add("UnsignedInteger64Type");
        BASIC_TYPES.add("AasBlobType");
        BASIC_TYPES.add("DateTimeType");
        BASIC_TYPES.add("AasLangStringType");
        BASIC_TYPES.add("AasMultiLangStringType");
        BASIC_TYPES.add("AasFileResourceType");
        BASIC_TYPES.add("AasReferenceType");
        BASIC_TYPES.add("AasRelationType");
        BASIC_TYPES.add("AasAnyURIType");
        BASIC_TYPES.add("AasRangeType");
        BASIC_TYPES.add("AasGenericSubmodelElementCollection");
        BASIC_TYPES.add("AasGenericEntityType");
    }
}

