/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.configuration.easyProducer.aas;

import de.iip_ecosphere.platform.support.Version;
import de.iip_ecosphere.platform.support.aas.IdentifierType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public class AasImports {
    private static final Set<String> KNOWN_TYPES = new HashSet<String>();
    private static Map<String, Import> imports = new HashMap<String, Import>();
    private static Map<String, String> specificType = new HashMap<String, String>();

    private static void addImport(String semanticId, String specificType, Import imp) {
        imports.put(semanticId, imp);
        if (null != specificType) {
            AasImports.specificType.put(semanticId, specificType);
        }
    }

    static Import getImport(String semanticId) {
        return null == semanticId ? null : imports.get(semanticId);
    }

    static String getSpecificType(String semanticId) {
        return null == semanticId ? null : specificType.get(semanticId);
    }

    static boolean isKnownType(String type, Set<Import> excludes) {
        boolean result = false;
        if (null == excludes) {
            result = null != type && KNOWN_TYPES.contains(type);
        } else {
            for (Import imp : imports.values()) {
                if (excludes.contains(imp) || !imp.isKnownType(type)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public static List<Import> sort(List<Import> imports) {
        Collections.sort(imports, (i1, i2) -> i1.getProjectName().compareTo(i2.getProjectName()));
        return imports;
    }

    public static Iterable<Import> imports() {
        return AasImports.sort(new ArrayList<Import>(new HashSet<Import>(imports.values())));
    }

    public static Stream<Import> importsStream() {
        return AasImports.sort(new ArrayList<Import>(new HashSet<Import>(imports.values()))).stream();
    }

    static {
        Import contactInformation = new Import("IDTA_02002_ContactInformations", new Version(new int[]{1, 0}), "RoleOfContactPerson", "TypeOfTelephone", "TypeOfFaxNumber", "TypeOfEmailAddress", "ContactInformations", "ContactInformation", "Phone", "Fax", "Email", "IPCommunication");
        AasImports.addImport(IdentifierType.compose((String)"iri:", (String)"https://admin-shell.io/zvei/nameplate/1/0/ContactInformations"), "ContactInformations", contactInformation);
        AasImports.addImport("irdi:0173-1#02-AAQ837#007", "ContactInformations", contactInformation);
        AasImports.addImport(IdentifierType.compose((String)"iri:", (String)"https://admin-shell.io/zvei/nameplate/1/0/ContactInformations/ContactInformation"), "ContactInformation", contactInformation);
        AasImports.addImport("irdi:0173-1#01-ADR448#007", "ContactInformation", contactInformation);
        AasImports.addImport(IdentifierType.compose((String)"iri:", (String)"https://admin-shell.io/zvei/nameplate/1/0/ContactInformations/ContactInformation/Phone"), "Phone", contactInformation);
        AasImports.addImport("irdi:0173-1#02-AAQ834#005", "Fax", contactInformation);
        AasImports.addImport("irdi:0173-1#02-AAQ836#005", "Email", contactInformation);
        AasImports.addImport(IdentifierType.compose((String)"iri:", (String)"iri:https://admin-shell.io/zvei/nameplate/1/0/ContactInformations/ContactInformation/IPCommunication/"), "IPCommunication", contactInformation);
    }

    public static class Import {
        private String projectName;
        private Version version;
        private Set<String> knownTypes = new HashSet<String>();

        private Import(String projectName, Version version, String ... knownTypes) {
            this.projectName = projectName;
            this.version = version;
            for (String s : knownTypes) {
                this.knownTypes.add(s);
                KNOWN_TYPES.add(s);
            }
        }

        public String getProjectName() {
            return this.projectName;
        }

        public Version getVersion() {
            return this.version;
        }

        public boolean isKnownType(String type) {
            return null != type && this.knownTypes.contains(type);
        }
    }
}

