/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.configuration.easyProducer.aas;

import de.iip_ecosphere.platform.configuration.easyProducer.aas.ReadExcelFile;
import de.iip_ecosphere.platform.support.logging.Logger;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import java.util.HashMap;
import java.util.Map;

enum AasSmeType {
    AAS(true),
    SUBMODEL(true),
    SUBMODEL_LIST(true),
    SUBMODEL_ELEMENT_COLLECTION(true),
    SUBMODEL_ELEMENT_LIST(true),
    SUBMODEL_ELEMENT(true),
    PROPERTY(false),
    MULTI_LANGUAGE_PROPERTY(false),
    LANG_STRING(false),
    ENTITY(true),
    RELATION(false),
    REFERENCE(false),
    BLOB(false),
    RANGE(false),
    OPERATION(false),
    FILE(false);

    private static final Map<String, AasSmeType> TYPE_TRANSLATION;
    private boolean isType;

    private AasSmeType(boolean isType) {
        this.isType = isType;
    }

    public boolean isType() {
        return this.isType;
    }

    public static AasSmeType toType(String data) {
        AasSmeType result = null;
        if (null != data) {
            result = TYPE_TRANSLATION.get(data);
            if (null == result) {
                int pos = data.indexOf(" ");
                if (pos > 0) {
                    data = data.substring(0, pos).trim();
                }
                if (null == (result = TYPE_TRANSLATION.get(data))) {
                    StringBuilder tmp = new StringBuilder(data);
                    for (int i = 1; i < tmp.length(); ++i) {
                        char c = tmp.charAt(i);
                        if (!Character.isUpperCase(c)) continue;
                        tmp.insert(i, "_");
                        ++i;
                    }
                    try {
                        result = AasSmeType.valueOf(tmp.toString().toUpperCase());
                        AasSmeType.getLogger().warn("Fallback AasType (add mapping) '{}' as type name '{}' enum value {}", new Object[]{data, tmp, result});
                    }
                    catch (IllegalArgumentException e) {
                        AasSmeType.getLogger().warn("Unknown AasType '{}' ('{}')", (Object)data, (Object)tmp);
                    }
                }
            }
        } else {
            AasSmeType.getLogger().warn("Unknown AasType: null");
        }
        return result;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(ReadExcelFile.class);
    }

    static {
        TYPE_TRANSLATION = new HashMap<String, AasSmeType>();
        TYPE_TRANSLATION.put("Property", PROPERTY);
        TYPE_TRANSLATION.put("Prop", PROPERTY);
        TYPE_TRANSLATION.put("MLP", MULTI_LANGUAGE_PROPERTY);
        TYPE_TRANSLATION.put("Range", RANGE);
        TYPE_TRANSLATION.put("File", FILE);
        TYPE_TRANSLATION.put("Blob", BLOB);
        TYPE_TRANSLATION.put("Ref", REFERENCE);
        TYPE_TRANSLATION.put("Rel", RELATION);
        TYPE_TRANSLATION.put("SMC", SUBMODEL_ELEMENT_COLLECTION);
        TYPE_TRANSLATION.put("langString", LANG_STRING);
        TYPE_TRANSLATION.put("Submodel", SUBMODEL);
        TYPE_TRANSLATION.put("SubmodelElementCollection", SUBMODEL_ELEMENT_COLLECTION);
        TYPE_TRANSLATION.put("SubmodelElementCollecttion", SUBMODEL_ELEMENT_COLLECTION);
        TYPE_TRANSLATION.put("SubmodelElementCollection (SMC)", SUBMODEL_ELEMENT_COLLECTION);
        TYPE_TRANSLATION.put("Submodel Element Collection (SMC)", SUBMODEL_ELEMENT_COLLECTION);
        TYPE_TRANSLATION.put("SME", SUBMODEL_ELEMENT);
        TYPE_TRANSLATION.put("Entity", ENTITY);
        TYPE_TRANSLATION.put("Opr", OPERATION);
        TYPE_TRANSLATION.put("Operation", OPERATION);
        TYPE_TRANSLATION.put("MultiLanguageProperty", MULTI_LANGUAGE_PROPERTY);
        TYPE_TRANSLATION.put("property", PROPERTY);
        TYPE_TRANSLATION.put("ReferenceElement", REFERENCE);
        TYPE_TRANSLATION.put("RelationshipElement", RELATION);
        TYPE_TRANSLATION.put("file", FILE);
        TYPE_TRANSLATION.put("SML", SUBMODEL_ELEMENT_LIST);
        TYPE_TRANSLATION.put("SubmodelElementList", SUBMODEL_ELEMENT_LIST);
        TYPE_TRANSLATION.put("SubmodelElementList (SML)", SUBMODEL_ELEMENT_LIST);
        TYPE_TRANSLATION.put("SubmodelList", SUBMODEL_LIST);
    }
}

