/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.configuration.easyProducer.aas;

import de.iip_ecosphere.platform.configuration.easyProducer.aas.AasField;
import de.iip_ecosphere.platform.configuration.easyProducer.aas.AasSpecSummary;
import de.iip_ecosphere.platform.configuration.easyProducer.aas.AasType;
import de.iip_ecosphere.platform.configuration.easyProducer.aas.ReadAasxFile;
import de.iip_ecosphere.platform.configuration.easyProducer.aas.ReadExcelFile;
import de.iip_ecosphere.platform.support.CollectionUtils;
import de.iip_ecosphere.platform.support.FileUtils;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class SpecComparator {
    private static final Map<File, SpecPair> SPECS = new TreeMap<File, SpecPair>((f1, f2) -> -f1.toString().compareTo(f2.toString()));
    private static final DecimalFormat PERCENT_FORMAT = new DecimalFormat("# %");

    private static void register(File file) {
        String name;
        File folder = file.getParentFile();
        SpecPair pair = SPECS.get(folder);
        if (null == pair) {
            pair = new SpecPair();
            SPECS.put(folder, pair);
        }
        if ((name = file.getName()).endsWith(".aasx") && !name.endsWith(".spec.aasx")) {
            pair.aasx = file;
        } else if (name.endsWith(".xlsx")) {
            if (name.endsWith(".mod.xlsx")) {
                if (pair.xlsx != null) {
                    pair.xlsx = file;
                }
            } else {
                pair.xlsx = file;
            }
        }
    }

    private static List<AasType> sortTypes(AasSpecSummary summary) {
        List result = CollectionUtils.toList(summary.types());
        Collections.sort(result, (t1, t2) -> t1.getIdShort().compareTo(t2.getIdShort()));
        return result;
    }

    private static void compare(AasSpecSummary pdf, AasSpecSummary aas) {
        List<AasType> pdfTypes = SpecComparator.sortTypes(pdf);
        HashMap<String, AasType> aasTypes = new HashMap<String, AasType>();
        for (AasType t : aas.types()) {
            aasTypes.put(t.getIdShort(), t);
        }
        int elementsInPdf = 0;
        int overlappingInAasx = 0;
        for (AasType p : pdfTypes) {
            AasType a = (AasType)aasTypes.get(p.getIdShort());
            elementsInPdf += 4;
            if (a == null) continue;
            if (p.getDescription() != null && a.getDescription() != null) {
                ++overlappingInAasx;
            }
            if (p.getSemanticId() != null && p.getSemanticId().equals(a.getSemanticId())) {
                ++overlappingInAasx;
            }
            if (p.getSmeType() != null && p.getSmeType() == a.getSmeType()) {
                ++overlappingInAasx;
            }
            if (p.isGeneric() && a.isGeneric()) {
                ++overlappingInAasx;
            }
            HashMap<String, AasField> aasFields = new HashMap<String, AasField>();
            for (AasField f : a.fields()) {
                aasFields.put(f.getIdShort(), f);
            }
            for (AasField pf : p.fields()) {
                AasField af = (AasField)aasFields.get(pf.getIdShort());
                elementsInPdf += 6;
                if (af == null) continue;
                if (pf.getDescription() != null && af.getDescription() != null) {
                    ++overlappingInAasx;
                }
                if (pf.getExampleValues() != null && af.getExampleValues() != null) {
                    ++overlappingInAasx;
                }
                if (pf.getSemanticId() != null && pf.getSemanticId().equals(af.getSemanticId())) {
                    ++overlappingInAasx;
                }
                if (pf.getValueType() != null && pf.getValueType().equals(af.getValueType())) {
                    ++overlappingInAasx;
                }
                if (pf.getLowerCardinality() == af.getLowerCardinality()) {
                    ++overlappingInAasx;
                }
                if (pf.getUpperCardinality() != af.getUpperCardinality()) continue;
                ++overlappingInAasx;
            }
        }
        double overlap = (double)overlappingInAasx / (double)elementsInPdf;
        System.out.println(" pdf: " + elementsInPdf + " aasx: " + overlappingInAasx + ": " + PERCENT_FORMAT.format(overlap));
    }

    public static void main(String[] args) {
        FileUtils.listFiles((File)new File("src/test/resources/idta"), f -> f.isDirectory() || f.isFile(), f -> SpecComparator.register(f));
        for (File f2 : SPECS.keySet()) {
            SpecPair pair = SPECS.get(f2);
            System.out.println(f2);
            if (pair.xlsx != null && pair.aasx != null) {
                try {
                    AasSpecSummary xlsx = ReadExcelFile.read(pair.xlsx.toString());
                    AasSpecSummary aasx = ReadAasxFile.read(pair.aasx.toString(), ReadAasxFile.getSpecNumber(pair.aasx));
                    SpecComparator.compare(xlsx, aasx);
                }
                catch (IOException e) {
                    System.out.println("Cannot compare files in " + String.valueOf(f2) + ": " + e.getMessage());
                }
                continue;
            }
            System.out.println("Cannot compare files in " + String.valueOf(f2) + ": One not found; xlsx: " + String.valueOf(pair.xlsx) + " aasx: " + String.valueOf(pair.aasx));
        }
    }

    private static class SpecPair {
        private File xlsx;
        private File aasx;

        private SpecPair() {
        }
    }
}

