/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.configuration.easyProducer.ivml;

import de.iip_ecosphere.platform.configuration.cfg.ConfigurationChangeType;
import de.iip_ecosphere.platform.configuration.easyProducer.ConfigurationManager;
import de.iip_ecosphere.platform.configuration.easyProducer.ConfigurationSetup;
import de.iip_ecosphere.platform.configuration.easyProducer.EasySetup;
import de.iip_ecosphere.platform.configuration.easyProducer.ModelInfo;
import de.iip_ecosphere.platform.configuration.easyProducer.PlatformInstantiator;
import de.iip_ecosphere.platform.configuration.easyProducer.ivml.AbstractIvmlModifier;
import de.iip_ecosphere.platform.configuration.easyProducer.ivml.GraphFormat;
import de.iip_ecosphere.platform.configuration.easyProducer.ivml.IvmlGraphMapper;
import de.iip_ecosphere.platform.configuration.easyProducer.ivml.IvmlUtils;
import de.iip_ecosphere.platform.configuration.easyProducer.ivml.TypeMapper;
import de.iip_ecosphere.platform.configuration.easyProducer.ivml.TypeVisitor;
import de.iip_ecosphere.platform.configuration.easyProducer.ivml.ValueVisitor;
import de.iip_ecosphere.platform.support.FileUtils;
import de.iip_ecosphere.platform.support.TaskRegistry;
import de.iip_ecosphere.platform.support.ZipUtils;
import de.iip_ecosphere.platform.support.aas.AasUtils;
import de.iip_ecosphere.platform.support.aas.AuthenticationDescriptor;
import de.iip_ecosphere.platform.support.aas.InvocablesCreator;
import de.iip_ecosphere.platform.support.aas.LangString;
import de.iip_ecosphere.platform.support.aas.Property;
import de.iip_ecosphere.platform.support.aas.ProtocolServerBuilder;
import de.iip_ecosphere.platform.support.aas.Registry;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.aas.SubmodelElementCollection;
import de.iip_ecosphere.platform.support.aas.SubmodelElementContainerBuilder;
import de.iip_ecosphere.platform.support.aas.SubmodelElementList;
import de.iip_ecosphere.platform.support.aas.Type;
import de.iip_ecosphere.platform.support.iip_aas.AasPartRegistry;
import de.iip_ecosphere.platform.support.json.JsonResultWrapper;
import de.iip_ecosphere.platform.support.json.JsonUtils;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.transport.status.TaskUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.instantiation.core.model.vilTypes.PseudoString;
import net.ssehub.easy.producer.core.mgmt.EasyExecutor;
import net.ssehub.easy.reasoning.core.reasoner.ReasoningResult;
import net.ssehub.easy.varModel.confModel.AssignmentState;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.ConfigurationException;
import net.ssehub.easy.varModel.confModel.IAssignmentState;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.management.VarModel;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.ContainableModelElement;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.FreezeBlock;
import net.ssehub.easy.varModel.model.IAttributableElement;
import net.ssehub.easy.varModel.model.IFreezable;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.IvmlDatatypeVisitor;
import net.ssehub.easy.varModel.model.ModelElement;
import net.ssehub.easy.varModel.model.ModelQuery;
import net.ssehub.easy.varModel.model.ModelQueryException;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.datatypes.Enum;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.IDatatypeVisitor;
import net.ssehub.easy.varModel.model.datatypes.IResolutionScope;
import net.ssehub.easy.varModel.model.datatypes.TypeQueries;
import net.ssehub.easy.varModel.model.values.ContainerValue;
import net.ssehub.easy.varModel.model.values.IValueVisitor;
import net.ssehub.easy.varModel.model.values.ReferenceValue;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;

public class AasIvmlMapper
extends AbstractIvmlModifier {
    public static final String OP_CHANGE_VALUES = "changeValues";
    public static final String OP_GET_GRAPH = "getGraph";
    public static final String OP_SET_GRAPH = "setGraph";
    public static final String OP_DELETE_GRAPH = "deleteGraph";
    public static final String OP_GET_VARIABLE_NAME = "getVariableName";
    public static final String OP_CREATE_VARIABLE = "createVariable";
    public static final String OP_CREATE_CONSTANT = "createConstantVariable";
    public static final String OP_DELETE_VARIABLE = "deleteVariable";
    public static final String OP_RENAME_VARIABLE = "renameVariable";
    public static final String OP_GEN_INTERFACES = "genInterfacesAsync";
    public static final String OP_GEN_APPS_NO_DEPS = "genAppsNoDepsAsync";
    public static final String OP_GEN_APPS = "genAppsAsync";
    public static final String OP_GET_TEMPLATES = "getTemplates";
    public static final String OP_INSTANTIATE_TEMPLATE = "instantiateTemplate";
    public static final String OP_GET_OPEN_TEMPLATE_VARIABLES = "getOpenTemplateVariables";
    public static final Predicate<AbstractVariable> FILTER_NO_CONSTRAINT_VARIABLES = v -> !TypeQueries.isConstraint((IDatatype)v.getType());
    public static final Predicate<AbstractVariable> FILTER_NO_ANY = v -> !"Any".equals(IvmlDatatypeVisitor.getUnqualifiedType((IDatatype)v.getType()));
    public static final String META_TYPE_NAME = "meta";
    public static final Function<String, String> SHORTID_PREFIX_META = n -> META_TYPE_NAME + PseudoString.firstToUpperCase((String)n);
    public static final String PROGRESS_COMPONENT_ID = "Configuration";
    protected static final String PRJ_NAME_ALLCONSTANTS = "AllConstants";
    protected static final String PRJ_NAME_ALLSERVICES = "AllServices";
    protected static final String PRJ_NAME_ALLTYPES = "AllTypes";
    protected static final String PRJ_NAME_TECHSETUP = "TechnicalSetup";
    private static final Map<String, String> PROJECT_MAPPING;
    private static final Map<String, String> PARENT_MAPPING;
    private static final TypeVisitor TYPE_VISITOR;
    private static final String[] TOP_FOLDERS;
    private Supplier<net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Configuration> cfgSupplier;
    private Function<String, String> metaShortId = SHORTID_PREFIX_META;
    private Predicate<AbstractVariable> variableFilter = FILTER_NO_CONSTRAINT_VARIABLES.and(FILTER_NO_ANY);
    private Map<String, SubmodelElementContainerBuilder> types = new HashMap<String, SubmodelElementContainerBuilder>();

    public AasIvmlMapper(Supplier<net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Configuration> cfgSupplier, IvmlGraphMapper graphMapper, AbstractIvmlModifier.ConfigurationChangeListener changeListener) {
        super(graphMapper, changeListener);
        if (null == cfgSupplier) {
            throw new IllegalArgumentException("cfgSupplier must not be null");
        }
        this.cfgSupplier = cfgSupplier;
    }

    private static String mapParent(IDecisionVariable var) {
        String result = var.getDeclaration().getParent().getName();
        String mapping = PARENT_MAPPING.get(result);
        if (mapping != null) {
            result = mapping;
        }
        return result;
    }

    public void setShortIdToMeta(Function<String, String> metaShortId) {
        if (null != metaShortId) {
            this.metaShortId = metaShortId;
        }
    }

    public void setVariableFilter(Predicate<AbstractVariable> variableFilter) {
        if (null != variableFilter) {
            this.variableFilter = variableFilter;
        }
    }

    public void mapByType(Submodel.SubmodelBuilder smBuilder, InvocablesCreator iCreator) {
        net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Configuration cfg = this.cfgSupplier.get();
        if (null != cfg) {
            for (String name : TOP_FOLDERS) {
                this.types.put(name, (SubmodelElementContainerBuilder)AasIvmlMapper.createTypeCollectionBuilder(smBuilder, name));
            }
            IDatatype primitiveType = null;
            try {
                primitiveType = ModelQuery.findType((IResolutionScope)cfg.getConfiguration().getProject(), (String)"PrimitiveType", null);
            }
            catch (ModelQueryException modelQueryException) {
                // empty catch block
            }
            TypeMapper mapper = new TypeMapper(cfg, this.variableFilter, this.types.get(META_TYPE_NAME), this.metaShortId);
            mapper.mapTypes();
            for (IDecisionVariable var : cfg.getConfiguration()) {
                String typeName;
                SubmodelElementContainerBuilder builder;
                if (!this.variableFilter.test(var.getDeclaration())) continue;
                IDatatype type = var.getDeclaration().getType();
                if (primitiveType != null && primitiveType.isAssignableFrom(type)) {
                    type = primitiveType;
                }
                if (null == (builder = this.types.get(typeName = IvmlDatatypeVisitor.getUnqualifiedType((IDatatype)this.mapType(type))))) {
                    builder = AasIvmlMapper.createTypeCollectionBuilder(smBuilder, typeName);
                    this.types.put(typeName, builder);
                }
                this.mapVariable(var, builder, null);
            }
            for (SubmodelElementContainerBuilder builder : this.types.values()) {
                builder.justBuild();
            }
            this.addOperations(smBuilder, iCreator);
        } else {
            LoggerFactory.getLogger(AasIvmlMapper.class).warn("No IVML configuration found. Cannot create IVML-AAS model elements/operations.");
        }
    }

    private IDatatype mapType(IDatatype type) {
        IDatatype result = DerivedDatatype.resolveToBasis((IDatatype)type);
        if (type instanceof Compound) {
            result = this.mapType((Compound)type);
        }
        return result;
    }

    private Compound mapType(Compound type) {
        Compound result = type;
        if (type.getRefinesCount() > 0) {
            for (int r = 0; r < type.getRefinesCount(); ++r) {
                Compound ref = type.getRefines(r);
                if (ref.getProject().getName().equals("MetaConcepts") || ref.getName().equals("VersionedElement")) continue;
                result = this.mapType(ref);
                break;
            }
        }
        return result;
    }

    private static SubmodelElementList.SubmodelElementListBuilder createTypeCollectionBuilder(Submodel.SubmodelBuilder smBuilder, String typeName) {
        return smBuilder.createSubmodelElementListBuilder(AasUtils.fixId((String)typeName));
    }

    public void bindOperations(ProtocolServerBuilder sBuilder) {
        AasIvmlMapper.bind(sBuilder);
    }

    private static void bind(ProtocolServerBuilder sBuilder) {
        sBuilder.defineOperation(OP_CHANGE_VALUES, (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)a -> {
            ConfigurationManager.getAasIvmlMapper().changeValues(AasUtils.readMap((Object[])a, (int)0, null));
            return null;
        }, ConfigurationManager.getAasOperationCompletedListener()));
        sBuilder.defineOperation(OP_GET_GRAPH, (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)a -> ConfigurationManager.getAasIvmlMapper().getGraph(AasUtils.readString((Object[])a, (int)0), AasUtils.readString((Object[])a, (int)1)), ConfigurationManager.getAasOperationCompletedListener()));
        sBuilder.defineOperation(OP_SET_GRAPH, (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)a -> ConfigurationManager.getAasIvmlMapper().setGraph(AasUtils.readString((Object[])a, (int)0), AasUtils.readString((Object[])a, (int)1), AasUtils.readString((Object[])a, (int)2), AasUtils.readString((Object[])a, (int)3), AasUtils.readString((Object[])a, (int)4)), ConfigurationManager.getAasOperationCompletedListener()));
        sBuilder.defineOperation(OP_DELETE_GRAPH, (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)a -> ConfigurationManager.getAasIvmlMapper().deleteGraph(AasUtils.readString((Object[])a, (int)0), AasUtils.readString((Object[])a, (int)1)), ConfigurationManager.getAasOperationCompletedListener()));
        sBuilder.defineOperation(OP_GET_VARIABLE_NAME, (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)a -> ConfigurationManager.getAasIvmlMapper().getVariableName(AasUtils.readString((Object[])a, (int)0), AasUtils.readString((Object[])a, (int)1), AasUtils.readString((Object[])a, (int)2))));
        sBuilder.defineOperation(OP_CREATE_CONSTANT, (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)a -> {
            ConfigurationManager.getAasIvmlMapper().createVariable(AasUtils.readString((Object[])a, (int)0), AasUtils.readString((Object[])a, (int)1), true, AasUtils.readString((Object[])a, (int)2));
            return null;
        }, ConfigurationManager.getAasOperationCompletedListener()));
        sBuilder.defineOperation(OP_CREATE_VARIABLE, (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)a -> {
            ConfigurationManager.getAasIvmlMapper().createVariable(AasUtils.readString((Object[])a, (int)0), AasUtils.readString((Object[])a, (int)1), false, AasUtils.readString((Object[])a, (int)2));
            return null;
        }, ConfigurationManager.getAasOperationCompletedListener()));
        sBuilder.defineOperation(OP_RENAME_VARIABLE, (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)a -> {
            ConfigurationManager.getAasIvmlMapper().renameVariable(AasUtils.readString((Object[])a), AasUtils.readString((Object[])a, (int)1));
            return null;
        }, ConfigurationManager.getAasOperationCompletedListener()));
        sBuilder.defineOperation(OP_DELETE_VARIABLE, (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)a -> {
            ConfigurationManager.getAasIvmlMapper().deleteVariable(AasUtils.readString((Object[])a));
            return null;
        }, ConfigurationManager.getAasOperationCompletedListener()));
        sBuilder.defineOperation(OP_GEN_APPS, (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)a -> TaskUtils.executeAsTask((String)PROGRESS_COMPONENT_ID, (JsonResultWrapper.ExceptionFunction & Serializable)p -> ConfigurationManager.getAasIvmlMapper().instantiate(InstantiationMode.APPS, AasUtils.readString((Object[])p), AasUtils.readString((Object[])p, (int)1)), (Object[])a)));
        sBuilder.defineOperation(OP_GEN_APPS_NO_DEPS, (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)a -> TaskUtils.executeAsTask((String)PROGRESS_COMPONENT_ID, (JsonResultWrapper.ExceptionFunction & Serializable)p -> ConfigurationManager.getAasIvmlMapper().instantiate(InstantiationMode.APPS_NO_DEPS, AasUtils.readString((Object[])p), null), (Object[])a)));
        sBuilder.defineOperation(OP_GEN_INTERFACES, (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)a -> TaskUtils.executeAsTask((String)PROGRESS_COMPONENT_ID, (JsonResultWrapper.ExceptionFunction & Serializable)p -> ConfigurationManager.getAasIvmlMapper().instantiate(InstantiationMode.INTERFACES, null, null), (Object[])a)));
        AasIvmlMapper.bindTemplateOperations(sBuilder);
    }

    private static void bindTemplateOperations(ProtocolServerBuilder sBuilder) {
        sBuilder.defineOperation(OP_GET_TEMPLATES, (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)a -> {
            ConfigurationManager.getAasIvmlMapper().getTemplates();
            return null;
        }, ConfigurationManager.getAasOperationCompletedListener()));
        sBuilder.defineOperation(OP_INSTANTIATE_TEMPLATE, (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)a -> {
            ConfigurationManager.getAasIvmlMapper().instantiateTemplate(AasUtils.readString((Object[])a), AasUtils.readString((Object[])a, (int)1), AasUtils.readMap((Object[])a, (int)1, null));
            return null;
        }, ConfigurationManager.getAasOperationCompletedListener()));
        sBuilder.defineOperation(OP_GET_OPEN_TEMPLATE_VARIABLES, (Function)new JsonResultWrapper((JsonResultWrapper.ExceptionFunction & Serializable)a -> {
            ConfigurationManager.getAasIvmlMapper().getOpenTemplateVariables(AasUtils.readString((Object[])a));
            return null;
        }, ConfigurationManager.getAasOperationCompletedListener()));
    }

    private Object instantiate(InstantiationMode mode, String appId, String codeFile) throws ExecutionException {
        ReasoningResult rRes;
        File f;
        TaskRegistry.TaskData lastTaskData = TaskUtils.getLastTaskData();
        if (null == lastTaskData) {
            lastTaskData = TaskRegistry.getTaskData();
        }
        TaskRegistry.TaskData beforeTaskData = ConfigurationManager.setTaskData(lastTaskData);
        if (InstantiationMode.APPS == mode && codeFile != null && codeFile.endsWith(".zip") && (f = new File(ConfigurationSetup.getSetup().getUploadFolder(), codeFile)).exists()) {
            f = AasIvmlMapper.fixZipConvention(f);
            LoggerFactory.getLogger(AasIvmlMapper.class).info("Integrating {} in {}", (Object)codeFile, (Object)f);
            System.setProperty("iip.easy.impl", f.getAbsolutePath());
        }
        System.setProperty("KEY_PROPERTY_TRACING", "TOP");
        PlatformInstantiator.setTraceFilter();
        ConfigurationManager.cleanGenTarget();
        long start = System.currentTimeMillis();
        if (null != appId) {
            System.setProperty("iip.easy.apps", appId);
        }
        if (null == (rRes = ConfigurationManager.validateAndPropagate())) {
            throw new ExecutionException("No valid IVML model loaded/found.", null);
        }
        EasyExecutor.printReasoningMessages((ReasoningResult)rRes);
        ConfigurationManager.setupContainerProperties();
        ConfigurationManager.instantiate(mode.getStartRuleName());
        if (null != appId) {
            System.setProperty("iip.easy.apps", "");
        }
        Object result = null;
        switch (mode.ordinal()) {
            case 0: {
                result = this.collectTemplates(start);
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        ConfigurationManager.setTaskData(beforeTaskData);
        return result;
    }

    private static File fixZipConvention(File file) {
        File result = file;
        HashSet folders = new HashSet();
        HashSet files = new HashSet();
        try {
            ZipUtils.listFiles((InputStream)new FileInputStream(file), f -> true, f -> {
                String path = f.toString();
                int pos = path.indexOf("/");
                if (pos > 0) {
                    folders.add(path.substring(0, pos));
                } else {
                    files.add(path);
                }
            });
        }
        catch (IOException e) {
            LoggerFactory.getLogger(AasIvmlMapper.class).warn("Cannot scan ZIP: {}", (Object)e.getMessage());
        }
        if (folders.size() == 1 && files.size() == 0) {
            Optional folder;
            String name = file.getName();
            if (name.endsWith(".zip")) {
                name = name.substring(0, name.length() - 4);
            }
            if ((folder = folders.stream().findAny()).isPresent() && !name.equals(folder.get())) {
                result = new File(FileUtils.getTempDirectory(), (String)folder.get() + ".zip");
                try {
                    Files.copy(file.toPath(), result.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    LoggerFactory.getLogger(AasIvmlMapper.class).info("Zip convention: Using {} instead of {}", (Object)result, (Object)file);
                }
                catch (IOException e) {
                    LoggerFactory.getLogger(AasIvmlMapper.class).warn("Cannot copy ZIP: {}", (Object)e.getMessage());
                    result = file;
                }
            }
        }
        return result;
    }

    private Object collectTemplates(long startTime) {
        ArrayList tmp = new ArrayList();
        ConfigurationSetup setup = ConfigurationSetup.getSetup();
        EasySetup easySetup = setup.getEasyProducer();
        File gen = easySetup.getGenTarget();
        FileUtils.listFiles((File)gen, f -> AasIvmlMapper.acceptTemplateFile(f, startTime), f -> {
            if (f.isFile()) {
                File target = new File(setup.getArtifactsFolder(), f.getName());
                try {
                    Files.copy(f.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    Object prefix = setup.getArtifactsUriPrefix();
                    if (null == prefix) {
                        prefix = "";
                    } else if (!((String)prefix).endsWith("/")) {
                        prefix = (String)prefix + "/";
                    }
                    tmp.add((String)prefix + f.getName());
                }
                catch (IOException e) {
                    LoggerFactory.getLogger(AasIvmlMapper.class).error("Cannot copy generated template {} to {}: {}", new Object[]{f, target, e.getMessage()});
                }
            }
        });
        return JsonUtils.toJson(tmp);
    }

    private static boolean acceptTemplateFile(File file, long startTime) {
        boolean accept = file.isDirectory();
        if (!accept && file.getName().endsWith(".zip")) {
            accept = file.getName().startsWith("impl.") || file.getName().startsWith("ApplicationInterfaces.");
        }
        return accept;
    }

    @Override
    protected Project getVariableTarget(Project root, IDatatype type, String name, List<String> meshes) throws ExecutionException {
        Project result = null;
        if (null != type) {
            String prjName;
            for (Map.Entry<String, String> ent : PROJECT_MAPPING.entrySet()) {
                try {
                    IDatatype serviceType = ModelQuery.findType((IResolutionScope)root, (String)ent.getKey(), null);
                    if (null == serviceType || !serviceType.isAssignableFrom(type) || (result = ModelQuery.findProject((Project)root, (String)ent.getValue())) == null) continue;
                    break;
                }
                catch (ModelQueryException e) {
                    LoggerFactory.getLogger(AasIvmlMapper.class).warn("Cannot find type {} when checking for target IVML project {}: {}", new Object[]{ent.getKey(), ent.getValue(), e.getMessage()});
                }
            }
            if (null == result && IvmlUtils.isOfCompoundType(type, "ServiceMesh")) {
                prjName = this.getMeshProjectName(name);
                result = this.findOrCreateProject(root, prjName, true);
                this.prepareMeshProject(result, root);
            }
            if (null == result && IvmlUtils.isOfCompoundType(type, "Application")) {
                prjName = this.getApplicationProjectName(name);
                result = this.findOrCreateProject(root, prjName, true);
                this.prepareApplicationProject(result, root, meshes);
            }
            if (null == result) {
                result = ModelQuery.findProject((Project)root, (String)PRJ_NAME_ALLCONSTANTS);
            }
        }
        if (null == result) {
            result = root;
        }
        return result;
    }

    @Override
    protected boolean isAllowedForModification(Project prj) {
        String name = prj.getName();
        return PRJ_NAME_ALLTYPES.equals(name) || PRJ_NAME_ALLCONSTANTS.equals(name) || PRJ_NAME_ALLSERVICES.equals(name) || PRJ_NAME_TECHSETUP.equals(name);
    }

    @Override
    protected String getIvmlSubpath(Project project) {
        String projectName = project.getName();
        String subpath = projectName.startsWith("ServiceMeshPart") ? "meshes" : (projectName.startsWith("ApplicationPart") ? "apps" : null);
        return subpath;
    }

    private File getIvmlConfigFolder(EasySetup ep) {
        File result = ep.getIvmlConfigFolder();
        if (null == result || result.toString().equals(".")) {
            result = ep.getBase();
        }
        return result;
    }

    @Override
    protected File createIvmlConfigPath(String subpath, Project project) {
        EasySetup ep = ConfigurationSetup.getSetup().getEasyProducer();
        File result = this.getIvmlConfigFolder(ep);
        if (subpath != null) {
            result = new File(result, subpath);
        }
        return new File(result, project.getName() + ".ivml");
    }

    public synchronized Object deleteGraph(String appName, String meshName) throws ExecutionException {
        Configuration cfg = this.getIvmlConfiguration();
        Project root = cfg.getProject();
        Project appProject = ModelQuery.findProject((Project)root, (String)this.getApplicationProjectName(appName));
        LoggerFactory.getLogger(this.getClass()).info("Deleting graph in IVML, app '{}' mesh '{}', found {}", new Object[]{appName, meshName, appProject != null});
        try {
            HashMap<Project, AbstractIvmlModifier.CopiedFile> copies = new HashMap<Project, AbstractIvmlModifier.CopiedFile>();
            if (AasIvmlMapper.isNonEmptyString(meshName)) {
                IDatatype appType;
                DecisionVariableDeclaration appVarDecl;
                IDatatype meshType;
                Project meshProject = ModelQuery.findProject((Project)root, (String)this.getMeshProjectName(meshName));
                DecisionVariableDeclaration meshVarDecl = ModelQuery.findDeclaration((IResolutionScope)meshProject, (ModelQuery.IDeclarationSelector)new ModelQuery.FirstDeclTypeSelector(meshType = ModelQuery.findType((IResolutionScope)root, (String)"ServiceMesh", null)));
                if (null != meshVarDecl && appProject != null && null != (appVarDecl = ModelQuery.findDeclaration((IResolutionScope)appProject, (ModelQuery.IDeclarationSelector)new ModelQuery.FirstDeclTypeSelector(appType = ModelQuery.findType((IResolutionScope)root, (String)"Application", null))))) {
                    IDecisionVariable var = cfg.getDecision((AbstractVariable)appVarDecl);
                    IDecisionVariable svc = var.getNestedElement("services");
                    this.deleteReferenceFromContainerValue(svc, (AbstractVariable)meshVarDecl);
                }
                File f = this.getIvmlFile(meshProject);
                copies.put(meshProject, AasIvmlMapper.copyToTmp(f));
                f.delete();
                this.notifyChange(meshProject, ConfigurationChangeType.DELETED);
            }
            if (null != appProject && null == meshName || meshName.length() == 0) {
                File f = this.getIvmlFile(appProject);
                copies.put(appProject, AasIvmlMapper.copyToTmp(f));
                f.delete();
                this.notifyChange(appProject, ConfigurationChangeType.DELETED);
            }
            this.reloadAndValidate(copies);
            LoggerFactory.getLogger(this.getClass()).info("Deleted graph in IVML, app '{}' mesh '{}'", (Object)appName, (Object)meshName);
        }
        catch (ModelQueryException e) {
            throw new ExecutionException(e);
        }
        return null;
    }

    private ContainerValue deleteReferenceFromContainerValue(IDecisionVariable var, AbstractVariable search) throws ExecutionException {
        ContainerValue val = null;
        if (null != var && var.getValue() instanceof ContainerValue) {
            val = (ContainerValue)var.getValue();
            int eltSize = val.getElementSize();
            for (int e = eltSize - 1; e >= 0; --e) {
                if (!(val.getElement(e) instanceof ReferenceValue) || ((ReferenceValue)val.getElement(e)).getValue() != search) continue;
                val.removeElement(e);
            }
            if (eltSize != val.getElementSize()) {
                var.unfreeze((IAssignmentState)AssignmentState.ASSIGNED);
                try {
                    var.setValue((Value)val, (IAssignmentState)AssignmentState.FROZEN);
                }
                catch (ConfigurationException e) {
                    throw new ExecutionException(e);
                }
            }
        }
        return val;
    }

    private static boolean isNonEmptyString(String string) {
        return string != null && string.length() > 0;
    }

    public synchronized Object setGraph(String appName, String appValueEx, String meshName, String format, String value) throws ExecutionException {
        boolean doMesh;
        boolean doApp = AasIvmlMapper.isNonEmptyString(appName) && AasIvmlMapper.isNonEmptyString(appValueEx);
        boolean bl = doMesh = AasIvmlMapper.isNonEmptyString(meshName) && AasIvmlMapper.isNonEmptyString(format) && AasIvmlMapper.isNonEmptyString(value);
        if (doApp || doMesh) {
            LoggerFactory.getLogger(this.getClass()).info("Setting graph in IVML app {} = {}, mesh '{}', format {}", new Object[]{appName, appValueEx, meshName, format});
            GraphFormat gFormat = this.getGraphFormat(format);
            try {
                ModelResults results = new ModelResults();
                if (doMesh) {
                    IvmlGraphMapper.IvmlGraph graph = gFormat.fromString(value, this.getMapper().getGraphFactory(), this);
                    this.createMeshProject(appName, meshName, graph, results);
                }
                if (doApp) {
                    this.createAppProject(appName, appValueEx, results);
                }
                File meshFile = null;
                File appFile = null;
                HashMap<Project, AbstractIvmlModifier.CopiedFile> copies = new HashMap<Project, AbstractIvmlModifier.CopiedFile>();
                if (doMesh) {
                    meshFile = this.getIvmlFile(results.meshProject);
                    copies.put(results.meshProject, AasIvmlMapper.copyToTmp(meshFile));
                }
                if (doApp) {
                    appFile = this.getIvmlFile(results.appProject);
                    copies.put(results.appProject, AasIvmlMapper.copyToTmp(appFile));
                }
                if (meshFile != null) {
                    AasIvmlMapper.saveTo(results.meshProject, meshFile);
                }
                if (appFile != null) {
                    AasIvmlMapper.saveTo(results.appProject, appFile);
                }
                this.reloadAndValidate(copies);
                LoggerFactory.getLogger(this.getClass()).info("Graph set in IVML app {} = {}, mesh {}, format {}", new Object[]{appName, appValueEx, meshName, format});
            }
            catch (ModelManagementException | ModelQueryException e) {
                LoggerFactory.getLogger(this.getClass()).info("Setting graph in IVML app {} = {}, mesh '{}', format {}: {}", new Object[]{appName, appValueEx, meshName, format, e.getMessage()});
                e.printStackTrace();
                throw new ExecutionException(e);
            }
            catch (ExecutionException e) {
                LoggerFactory.getLogger(this.getClass()).info("Setting graph in IVML app {} = {}, mesh '{}', format {}: {}", new Object[]{appName, appValueEx, meshName, format, e.getMessage()});
                e.printStackTrace();
                throw new ExecutionException(e);
            }
        } else {
            LoggerFactory.getLogger(this.getClass()).info("No model change as both, graph and mesh do not have a name");
        }
        return null;
    }

    private String getApplicationProjectName(String appName) {
        return "ApplicationPart" + AasIvmlMapper.toIdentifierFirstUpper(appName);
    }

    private void prepareApplicationProject(Project app, Project root, List<String> meshes) throws ExecutionException {
        try {
            AasIvmlMapper.addImport(app, "Applications", root, null);
            AasIvmlMapper.addImport(app, PRJ_NAME_ALLSERVICES, root, null);
            Project wildcardPrj = new Project("");
            if (null != meshes) {
                for (String modelName : meshes) {
                    Project tmp = ModelQuery.findProject((Project)root, (String)modelName);
                    if (null == tmp) continue;
                    AasIvmlMapper.addImport(wildcardPrj, modelName, root, tmp);
                }
            }
            AasIvmlMapper.addImport(app, "ServiceMeshPart*", root, wildcardPrj);
        }
        catch (ModelManagementException e) {
            throw new ExecutionException(e);
        }
        this.annotate(app);
    }

    private String getMeshProjectName(String meshName) {
        return "ServiceMeshPart" + AasIvmlMapper.toIdentifierFirstUpper(meshName);
    }

    private void prepareMeshProject(Project mesh, Project root) throws ExecutionException {
        try {
            AasIvmlMapper.addImport(mesh, "Applications", root, null);
            AasIvmlMapper.addImport(mesh, PRJ_NAME_ALLSERVICES, root, null);
        }
        catch (ModelManagementException e) {
            throw new ExecutionException(e);
        }
        this.annotate(mesh);
    }

    private void annotate(Project prj) throws ExecutionException {
        String attrBindingTime = "bindingTime";
        if (!IvmlUtils.hasAnnotation(prj, "bindingTime")) {
            try {
                Enum bindingTime = ModelQuery.findEnum((IResolutionScope)prj, (String)"BindingTime");
                Attribute attr = new Attribute("bindingTime", (IDatatype)bindingTime, (IModelElement)prj, (IAttributableElement)prj.getVariable());
                attr.setValue(this.createExpression((IDatatype)bindingTime, "BindingTime.compile", prj));
                prj.addBeforeFreeze((ContainableModelElement)attr);
            }
            catch (CSTSemanticException | ModelQueryException | ValueDoesNotMatchTypeException e) {
                throw new ExecutionException(e);
            }
        }
    }

    private void createAppProject(String appName, String appValueEx, ModelResults results) throws ModelQueryException, ModelManagementException, ExecutionException {
        Configuration cfg = this.getIvmlConfiguration();
        Project root = cfg.getProject();
        IDatatype applicationType = ModelQuery.findType((IResolutionScope)root, (String)"Application", null);
        String appProjectName = this.getApplicationProjectName(appName);
        results.appProject = this.findOrCreateProject(root, appProjectName, true);
        this.prepareApplicationProject(results.appProject, root, VarModel.INSTANCE.getMatchingModelNames("ServiceMeshPart*"));
        ArrayList<Object> meshes = new ArrayList<Object>();
        boolean replaced = false;
        if (results.appProject != null) {
            for (int e = 0; e < results.appProject.getElementCount(); ++e) {
                IDecisionVariable var;
                Value val;
                ContainableModelElement elt = results.appProject.getElement(e);
                if (!(elt instanceof DecisionVariableDeclaration) || !((val = (var = cfg.getDecision((AbstractVariable)((DecisionVariableDeclaration)elt))).getNestedElement("services").getValue()) instanceof ContainerValue)) continue;
                ContainerValue cValue = (ContainerValue)val;
                for (int v = 0; v < cValue.getElementSize(); ++v) {
                    Value mVal = cValue.getElement(v);
                    if (AasIvmlMapper.isRefWithName(appName, cfg, mVal)) {
                        replaced = true;
                        meshes.add(results.meshVar);
                        continue;
                    }
                    meshes.add(mVal);
                }
            }
        }
        if (!replaced) {
            meshes.add(results.meshVar);
        }
        DecisionVariableDeclaration appVar = new DecisionVariableDeclaration(AasIvmlMapper.toIdentifier(appName), applicationType, (IModelElement)results.appProject);
        results.appProject.add((ContainableModelElement)appVar);
        if (appValueEx.length() > 0) {
            this.setValue((AbstractVariable)appVar, appValueEx);
        }
        this.notifyChange(results.appProject, ConfigurationChangeType.CREATED);
    }

    private static boolean isRefWithName(String name, Configuration cfg, Value mVal) {
        boolean result = false;
        if (mVal instanceof ReferenceValue) {
            String var2Name;
            ReferenceValue rVal = (ReferenceValue)mVal;
            IDecisionVariable var2 = cfg.getDecision(rVal.getValue());
            Object var2n = AasIvmlMapper.getValue(var2.getNestedElement("name"));
            String string = var2Name = null == var2n ? "" : var2n.toString();
            if (var2Name.equals(name)) {
                result = true;
            }
        }
        return result;
    }

    @Override
    protected net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Configuration getVilConfiguration() {
        return this.cfgSupplier.get();
    }

    @Override
    protected Configuration getIvmlConfiguration() {
        return ConfigurationManager.getIvmlConfiguration();
    }

    @Override
    protected ReasoningResult validateAndPropagate(Predicate<Project> projectFilter) {
        return ConfigurationManager.validateAndPropagate(projectFilter);
    }

    @Override
    protected void reloadConfiguration() {
        ConfigurationManager.reload();
    }

    private Project findOrCreateProject(Project scope, String projectName, boolean find) {
        Project result;
        Project project = result = find ? ModelQuery.findProject((Project)scope, (String)projectName) : null;
        if (null == result) {
            result = new Project(projectName);
            IFreezable[] freezables = new IFreezable[]{result};
            FreezeBlock freeze = new FreezeBlock(freezables, null, null, (IModelElement)result);
            result.add((ContainableModelElement)freeze);
        }
        return result;
    }

    private String validateName(IvmlGraphMapper.IvmlGraphNode node, int count) {
        if (node.getName().length() == 0) {
            node.setName(String.valueOf(count));
        }
        return node.getName();
    }

    private static String toId(String string) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!Character.isJavaIdentifierPart(c)) {
                c = '_';
            }
            result.append(c);
        }
        return result.toString();
    }

    /*
     * WARNING - void declaration
     */
    private void createMeshProject(String appName, String meshName, IvmlGraphMapper.IvmlGraph graph, ModelResults results) throws ModelQueryException, ModelManagementException, ExecutionException {
        void var19_24;
        void var20_38;
        DecisionVariableDeclaration nodeVar;
        Configuration cfg = this.getIvmlConfiguration();
        Project root = cfg.getProject();
        String meshProjectName = this.getMeshProjectName(meshName);
        results.meshProject = this.findOrCreateProject(root, meshProjectName, false);
        this.prepareMeshProject(results.meshProject, root);
        IDatatype sourceType = ModelQuery.findType((IResolutionScope)root, (String)"MeshSource", null);
        IDatatype processorType = ModelQuery.findType((IResolutionScope)root, (String)"MeshProcessor", null);
        IDatatype sinkType = ModelQuery.findType((IResolutionScope)root, (String)"MeshSink", null);
        IDatatype connectorType = ModelQuery.findType((IResolutionScope)root, (String)"MeshConnector", null);
        IDatatype serviceType = ModelQuery.findType((IResolutionScope)root, (String)"ServiceBase", null);
        IDatatype meshType = ModelQuery.findType((IResolutionScope)root, (String)"ServiceMesh", null);
        ServiceMap services = AasIvmlMapper.collectServices(cfg, serviceType);
        HashMap<IvmlGraphMapper.IvmlGraphNode, DecisionVariableDeclaration> nodeMap = new HashMap<IvmlGraphMapper.IvmlGraphNode, DecisionVariableDeclaration>();
        HashMap<DecisionVariableDeclaration, Object> valueMap = new HashMap<DecisionVariableDeclaration, Object>();
        ArrayList<DecisionVariableDeclaration> sources = new ArrayList<DecisionVariableDeclaration>();
        for (IvmlGraphMapper.IvmlGraphNode ivmlGraphNode : graph.nodes()) {
            void var20_29;
            if (ivmlGraphNode.getInEdgesCount() == 0) {
                IDatatype iDatatype = sourceType;
            } else if (ivmlGraphNode.getOutEdgesCount() == 0) {
                IDatatype iDatatype = sinkType;
            } else {
                IDatatype iDatatype = processorType;
            }
            nodeVar = new DecisionVariableDeclaration(AasIvmlMapper.toId("node_" + this.validateName(ivmlGraphNode, nodeMap.size())), (IDatatype)var20_29, (IModelElement)results.meshProject);
            String string = "{pos_x=" + ivmlGraphNode.getXPos() + ",pos_y=" + ivmlGraphNode.getYPos() + ",impl=" + IvmlUtils.getVarNameSafe(AasIvmlMapper.findServiceVar(services, ivmlGraphNode.getImpl()), "null") + ",next = {";
            valueMap.put(nodeVar, string);
            results.meshProject.add((ContainableModelElement)nodeVar);
            nodeMap.put(ivmlGraphNode, nodeVar);
            if (var20_29 != sourceType || sources.contains(nodeVar)) continue;
            sources.add(nodeVar);
        }
        int edgeCounter = 0;
        for (IvmlGraphMapper.IvmlGraphNode ivmlGraphNode : graph.nodes()) {
            for (IvmlGraphMapper.IvmlGraphEdge ivmlGraphEdge : ivmlGraphNode.outEdges()) {
                Object edgeName = ivmlGraphEdge.getName();
                String edgeVarName = "conn_" + AasIvmlMapper.toIdentifier((String)edgeName);
                if (null == edgeName || ((String)edgeName).length() == 0) {
                    edgeName = ivmlGraphNode.getName() + " -> " + ivmlGraphEdge.getEnd().getName();
                    edgeVarName = "conn_" + edgeCounter++;
                }
                DecisionVariableDeclaration edgeVar = new DecisionVariableDeclaration(edgeVarName, connectorType, (IModelElement)results.meshProject);
                results.meshProject.add((ContainableModelElement)edgeVar);
                DecisionVariableDeclaration end = (DecisionVariableDeclaration)nodeMap.get(ivmlGraphEdge.getEnd());
                String valueEx = "{name=\"" + (String)edgeName + "\", next=refBy(" + AasIvmlMapper.toId(end.getName()) + ")}";
                this.setValue((AbstractVariable)edgeVar, valueEx);
                Object startNodeValueEx = (String)valueMap.get(nodeMap.get(ivmlGraphNode));
                if (!((String)startNodeValueEx).endsWith("{")) {
                    startNodeValueEx = (String)startNodeValueEx + ",";
                }
                startNodeValueEx = (String)startNodeValueEx + "refBy(" + edgeVarName + ")";
                valueMap.put((DecisionVariableDeclaration)nodeMap.get(ivmlGraphNode), startNodeValueEx);
            }
        }
        for (IvmlGraphMapper.IvmlGraphNode ivmlGraphNode : graph.nodes()) {
            nodeVar = (DecisionVariableDeclaration)nodeMap.get(ivmlGraphNode);
            this.setValue((AbstractVariable)nodeVar, (String)valueMap.get(nodeVar) + "}}");
        }
        results.meshVar = new DecisionVariableDeclaration(AasIvmlMapper.toIdentifier(meshName), meshType, (IModelElement)results.meshProject);
        results.meshProject.add((ContainableModelElement)results.meshVar);
        String string = "{description=\"" + meshName + "\", sources={";
        boolean bl = false;
        while (var20_38 < sources.size()) {
            void var19_26;
            if (var20_38 > 0) {
                String string2 = (String)var19_24 + ", ";
            }
            String string3 = (String)var19_26 + "refBy(" + ((DecisionVariableDeclaration)sources.get((int)var20_38)).getName() + ")";
            ++var20_38;
        }
        String string4 = (String)var19_24 + "}}";
        this.setValue((AbstractVariable)results.meshVar, string4);
        this.notifyChange(results.meshProject, ConfigurationChangeType.CREATED);
    }

    private static ServiceMap collectServices(Configuration cfg, IDatatype serviceType) {
        ServiceMap result = new ServiceMap();
        for (IDecisionVariable cVar : cfg) {
            if (!serviceType.isAssignableFrom(cVar.getDeclaration().getType())) continue;
            result.add(cVar);
        }
        return result;
    }

    private static AbstractVariable findServiceVar(ServiceMap services, String name) {
        AbstractVariable result = null;
        IDecisionVariable cVar = services.getService(name);
        if (null != cVar) {
            result = cVar.getDeclaration();
        }
        return result;
    }

    private void addOperations(Submodel.SubmodelBuilder smBuilder, InvocablesCreator iCreator) {
        AuthenticationDescriptor aDesc = AasPartRegistry.getSubmodelAuthentication();
        smBuilder.createOperationBuilder(OP_CHANGE_VALUES).addInputVariable("valueExprs", Type.STRING).setInvocable(iCreator.createInvocable(OP_CHANGE_VALUES)).build(aDesc);
        smBuilder.createOperationBuilder(OP_GET_GRAPH).addInputVariable("varName", Type.STRING).addInputVariable("format", Type.STRING).setInvocable(iCreator.createInvocable(OP_GET_GRAPH)).build(Type.STRING, aDesc);
        smBuilder.createOperationBuilder(OP_SET_GRAPH).addInputVariable("appName", Type.STRING).addInputVariable("appValExpr", Type.STRING).addInputVariable("serviceMeshName", Type.STRING).addInputVariable("format", Type.STRING).addInputVariable("val", Type.STRING).setInvocable(iCreator.createInvocable(OP_SET_GRAPH)).build(aDesc);
        smBuilder.createOperationBuilder(OP_DELETE_GRAPH).addInputVariable("appName", Type.STRING).addInputVariable("serviceMeshName", Type.STRING).setInvocable(iCreator.createInvocable(OP_DELETE_GRAPH)).build(aDesc);
        smBuilder.createOperationBuilder(OP_GET_VARIABLE_NAME).addInputVariable("type", Type.STRING).addInputVariable("elementName", Type.STRING).addInputVariable("elementVersion", Type.STRING).setInvocable(iCreator.createInvocable(OP_GET_VARIABLE_NAME)).build(Type.STRING, aDesc);
        smBuilder.createOperationBuilder(OP_CREATE_CONSTANT).addInputVariable("varName", Type.STRING).addInputVariable("type", Type.STRING).addInputVariable("valExpr", Type.STRING).setInvocable(iCreator.createInvocable(OP_CREATE_CONSTANT)).build(aDesc);
        smBuilder.createOperationBuilder(OP_CREATE_VARIABLE).addInputVariable("varName", Type.STRING).addInputVariable("type", Type.STRING).addInputVariable("valExpr", Type.STRING).setInvocable(iCreator.createInvocable(OP_CREATE_VARIABLE)).build(aDesc);
        smBuilder.createOperationBuilder(OP_RENAME_VARIABLE).addInputVariable("varName", Type.STRING).addInputVariable("newVarName", Type.STRING).setInvocable(iCreator.createInvocable(OP_RENAME_VARIABLE)).build(aDesc);
        smBuilder.createOperationBuilder(OP_DELETE_VARIABLE).addInputVariable("varName", Type.STRING).setInvocable(iCreator.createInvocable(OP_DELETE_VARIABLE)).build(aDesc);
        smBuilder.createOperationBuilder(OP_GEN_APPS).setInvocable(iCreator.createInvocable(OP_GEN_APPS)).addInputVariable("appId", Type.STRING).addInputVariable("codeFile", Type.STRING).build(Type.STRING, aDesc);
        smBuilder.createOperationBuilder(OP_GEN_APPS_NO_DEPS).setInvocable(iCreator.createInvocable(OP_GEN_APPS_NO_DEPS)).addInputVariable("appId", Type.STRING).build(Type.STRING, aDesc);
        smBuilder.createOperationBuilder(OP_GEN_INTERFACES).setInvocable(iCreator.createInvocable(OP_GEN_INTERFACES)).build(Type.STRING, aDesc);
        smBuilder.createOperationBuilder(OP_GET_TEMPLATES).setInvocable(iCreator.createInvocable(OP_GET_TEMPLATES)).build(Type.STRING, aDesc);
        smBuilder.createOperationBuilder(OP_INSTANTIATE_TEMPLATE).setInvocable(iCreator.createInvocable(OP_INSTANTIATE_TEMPLATE)).addInputVariable("varName", Type.STRING).addInputVariable("appName", Type.STRING).build(Type.STRING, aDesc);
        smBuilder.createOperationBuilder(OP_GET_OPEN_TEMPLATE_VARIABLES).setInvocable(iCreator.createInvocable(OP_GET_OPEN_TEMPLATE_VARIABLES)).addInputVariable("varName", Type.STRING).build(Type.STRING, aDesc);
    }

    static String getLang() {
        return ModelInfo.getLocale().getLanguage();
    }

    static String getStringValueEmptyNull(IDecisionVariable var) {
        String result = null;
        Object val = AasIvmlMapper.getValue(var);
        if (null != val && (result = val.toString()).length() == 0) {
            result = null;
        }
        return result;
    }

    void mapVariable(IDecisionVariable var, SubmodelElementContainerBuilder builder, String id) {
        if (this.variableFilter.test(var.getDeclaration())) {
            Object varBuilder;
            AbstractVariable decl = var.getDeclaration();
            String varName = decl.getName();
            IDatatype varType = null == var.getValue() ? decl.getType() : var.getValue().getType();
            IDatatype rVarType = DerivedDatatype.resolveToBasis((IDatatype)varType);
            String lang = AasIvmlMapper.getLang();
            String semanticId = null;
            String displayName = null;
            for (int a = 0; a < var.getAttributesCount(); ++a) {
                IDecisionVariable attribute = var.getAttribute(a);
                String attributeName = attribute.getDeclaration().getName();
                if ("semanticId".equals(attributeName)) {
                    semanticId = AasIvmlMapper.getStringValueEmptyNull(attribute);
                    continue;
                }
                if (!"displayName".equals(attributeName)) continue;
                displayName = AasIvmlMapper.getStringValueEmptyNull(attribute);
            }
            if (TypeQueries.isCompound((IDatatype)rVarType)) {
                varBuilder = builder.createSubmodelElementCollectionBuilder(AasUtils.fixId((String)varName));
                for (int member = 0; member < var.getNestedElementsCount(); ++member) {
                    IDecisionVariable elt = var.getNestedElement(member);
                    this.mapVariable(elt, (SubmodelElementContainerBuilder)varBuilder, null);
                }
            } else if (TypeQueries.isContainer((IDatatype)rVarType)) {
                boolean isSequence = TypeQueries.isSequence((IDatatype)rVarType);
                varBuilder = isSequence ? builder.createSubmodelElementListBuilder(AasUtils.fixId((String)varName)) : builder.createSubmodelElementCollectionBuilder(AasUtils.fixId((String)varName));
                for (int member = 0; member < var.getNestedElementsCount(); ++member) {
                    this.mapVariable(var.getNestedElement(member), (SubmodelElementContainerBuilder)varBuilder, "var_" + member);
                }
                Property.PropertyBuilder pb = varBuilder.createPropertyBuilder(AasUtils.fixId((String)this.metaShortId.apply("size"))).setDescription(new LangString[]{new LangString(lang, ModelInfo.getCommentSafe((ModelElement)decl))}).setValue(Type.INTEGER, (Object)var.getNestedElementsCount());
                AasIvmlMapper.setSemanticId(pb, semanticId);
                pb.build();
            } else {
                String propName = id == null ? varName : id;
                varBuilder = builder.createSubmodelElementCollectionBuilder(AasUtils.fixId((String)propName));
                Object aasValue = AasIvmlMapper.getValue(var);
                varType.accept((IDatatypeVisitor)TYPE_VISITOR);
                Type aasType = TYPE_VISITOR.getAasType();
                Property.PropertyBuilder pb = varBuilder.createPropertyBuilder(AasUtils.fixId((String)"varValue"));
                pb.setValue(aasType, aasValue);
                AasIvmlMapper.setSemanticId(pb, semanticId);
                pb.build();
            }
            this.addMetaProperties(var, varType, (SubmodelElementContainerBuilder)varBuilder, displayName);
            varBuilder.justBuild();
        }
    }

    private void addMetaProperties(IDecisionVariable var, IDatatype varType, SubmodelElementContainerBuilder varBuilder, String displayName) {
        varBuilder.createPropertyBuilder(AasUtils.fixId((String)this.metaShortId.apply("variable"))).setValue(Type.STRING, (Object)var.getDeclaration().getName()).build();
        varBuilder.createPropertyBuilder(AasUtils.fixId((String)this.metaShortId.apply("state"))).setValue(Type.STRING, (Object)var.getState().toString()).build();
        varBuilder.createPropertyBuilder(AasUtils.fixId((String)this.metaShortId.apply("constant"))).setValue(Type.BOOLEAN, (Object)var.getDeclaration().isConstant()).build();
        varBuilder.createPropertyBuilder(AasUtils.fixId((String)this.metaShortId.apply("template"))).setValue(Type.BOOLEAN, (Object)IvmlUtils.isInTemplate(var)).build();
        IDatatype type = var.getValue() != null ? var.getValue().getType() : varType;
        String declaredTypeName = IvmlDatatypeVisitor.getUnqualifiedType((IDatatype)var.getDeclaration().getType());
        String varName = var.getDeclaration().getName();
        varBuilder.createPropertyBuilder(AasUtils.fixId((String)this.metaShortId.apply("type"))).setValue(Type.STRING, (Object)IvmlDatatypeVisitor.getUnqualifiedType((IDatatype)type)).build();
        if (null == displayName && "OktoVersion".equals(declaredTypeName) && "ver".equals(varName)) {
            displayName = "version";
        }
        TypeMapper.addMetaDefault(var, varBuilder, this.metaShortId);
        TypeMapper.addTypeKind(varBuilder, DerivedDatatype.resolveToBasis((IDatatype)type), this.metaShortId);
        if (var.getDeclaration().getParent() instanceof Project) {
            varBuilder.createPropertyBuilder(AasUtils.fixId((String)this.metaShortId.apply("project"))).setValue(Type.STRING, (Object)AasIvmlMapper.mapParent(var)).build();
        }
        if (null != displayName) {
            varBuilder.createPropertyBuilder(AasUtils.fixId((String)this.metaShortId.apply("displayName"))).setValue(Type.STRING, (Object)displayName).build();
        }
        try {
            IDatatype serviceType = ModelQuery.findType((IResolutionScope)var.getConfiguration().getProject(), (String)"ServiceBase", null);
            if (null != serviceType && serviceType.isAssignableFrom(varType)) {
                String serviceId = IvmlUtils.getStringValue(var.getNestedElement("id"), "");
                Registry reg = AasPartRegistry.getIipAasRegistry();
                AasPartRegistry.addServiceAasEndpointProperty((Registry)reg, (SubmodelElementContainerBuilder)varBuilder, (String)this.metaShortId.apply("Aas"), (String)serviceId);
            }
        }
        catch (ModelQueryException e) {
            LoggerFactory.getLogger(AasIvmlMapper.class).warn("Cannot find type ServiceBase. No service will have a AAS URL. {}", (Object)e.getMessage());
        }
    }

    private static void setSemanticId(Property.PropertyBuilder pBuilder, String semanticId) {
        if (null != semanticId) {
            if (!((String)semanticId).startsWith("irdi:")) {
                semanticId = "irdi:" + (String)semanticId;
            }
            pBuilder.setSemanticId((String)semanticId);
        }
    }

    private static Object getValue(IDecisionVariable var) {
        Object aasValue = null;
        if (null != var && null != var.getValue()) {
            ValueVisitor valueVisitor = new ValueVisitor();
            var.getValue().accept((IValueVisitor)valueVisitor);
            aasValue = valueVisitor.getAasValue();
        }
        return aasValue;
    }

    static void deleteAasVariableMapping(Submodel sm, String typeName, String varName) {
        SubmodelElementCollection c = sm.getSubmodelElementCollection(AasUtils.fixId((String)typeName));
        if (null != c) {
            c.deleteElement(AasUtils.fixId((String)varName));
        }
    }

    void mapVariableToAas(Submodel.SubmodelBuilder smB, IDecisionVariable var) {
        SubmodelElementList.SubmodelElementListBuilder builder = AasIvmlMapper.createTypeCollectionBuilder(smB, AasIvmlMapper.getType(var));
        this.mapVariable(var, (SubmodelElementContainerBuilder)builder, null);
        builder.justBuild();
    }

    static {
        TYPE_VISITOR = new TypeVisitor();
        TOP_FOLDERS = new String[]{META_TYPE_NAME, "Dependency", "Manufacturer", "ServiceBase", "Server", "ServiceMesh", "Application"};
        HashMap<String, String> parentMap = new HashMap<String, String>();
        parentMap.put("Aas", PRJ_NAME_TECHSETUP);
        parentMap.put("Transport", PRJ_NAME_TECHSETUP);
        parentMap.put("Services", PRJ_NAME_TECHSETUP);
        parentMap.put("Resources", PRJ_NAME_TECHSETUP);
        parentMap.put("UI", PRJ_NAME_TECHSETUP);
        PARENT_MAPPING = Collections.unmodifiableMap(parentMap);
        HashMap<String, String> projectMap = new HashMap<String, String>();
        projectMap.put("ServiceBase", PRJ_NAME_ALLSERVICES);
        projectMap.put("Server", PRJ_NAME_ALLSERVICES);
        projectMap.put("Manufacturer", PRJ_NAME_ALLSERVICES);
        projectMap.put("Dependency", PRJ_NAME_ALLSERVICES);
        projectMap.put("DataType", PRJ_NAME_ALLTYPES);
        projectMap.put("DisplayRow", PRJ_NAME_ALLTYPES);
        projectMap.put("AliasType", PRJ_NAME_ALLTYPES);
        PROJECT_MAPPING = Collections.unmodifiableMap(projectMap);
    }

    private static enum InstantiationMode {
        APPS_NO_DEPS("generateAppsNoDeps"),
        APPS("generateApps"),
        INTERFACES("generateInterfaces");

        private String startRuleName;

        private InstantiationMode(String startRuleName) {
            this.startRuleName = startRuleName;
        }

        public String getStartRuleName() {
            return this.startRuleName;
        }
    }

    protected static class ModelResults {
        private Project meshProject;
        private DecisionVariableDeclaration meshVar;
        private Project appProject;

        protected ModelResults() {
        }
    }

    private static class ServiceMap {
        private Map<String, IDecisionVariable> nameToService = new HashMap<String, IDecisionVariable>();
        private Map<String, IDecisionVariable> idToService = new HashMap<String, IDecisionVariable>();

        private ServiceMap() {
        }

        public IDecisionVariable getService(String svc) {
            IDecisionVariable result = this.nameToService.get(svc);
            if (null == result) {
                result = this.idToService.get(svc);
            }
            return result;
        }

        private void add(IDecisionVariable var) {
            String id;
            String name = var.getDeclaration().getName();
            name = IvmlUtils.getStringValue(var.getNestedElement("name"), name);
            if (null != name) {
                this.nameToService.put(name, var);
            }
            if (null != (id = IvmlUtils.getStringValue(var.getNestedElement("id"), name))) {
                this.idToService.put(id, var);
            }
        }
    }
}

