/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.configuration.easyProducer.ivml;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import net.ssehub.easy.basics.messages.Status;
import net.ssehub.easy.reasoning.core.reasoner.Message;
import net.ssehub.easy.reasoning.core.reasoner.ReasoningResult;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.cst.AttributeVariable;
import net.ssehub.easy.varModel.cst.CompoundAccess;
import net.ssehub.easy.varModel.cst.ConstantValue;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.ContainerOperationCall;
import net.ssehub.easy.varModel.cst.IConstraintTreeVisitor;
import net.ssehub.easy.varModel.cst.Let;
import net.ssehub.easy.varModel.model.AbstractProjectVisitor;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.AttributeAssignment;
import net.ssehub.easy.varModel.model.Comment;
import net.ssehub.easy.varModel.model.CompoundAccessStatement;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.ContainableModelElement;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.FreezeBlock;
import net.ssehub.easy.varModel.model.IModelVisitor;
import net.ssehub.easy.varModel.model.ModelQuery;
import net.ssehub.easy.varModel.model.ModelQueryException;
import net.ssehub.easy.varModel.model.OperationDefinition;
import net.ssehub.easy.varModel.model.PartialEvaluationBlock;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.ProjectImport;
import net.ssehub.easy.varModel.model.ProjectInterface;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.datatypes.Enum;
import net.ssehub.easy.varModel.model.datatypes.EnumLiteral;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.IResolutionScope;
import net.ssehub.easy.varModel.model.datatypes.OrderedEnum;
import net.ssehub.easy.varModel.model.datatypes.Reference;
import net.ssehub.easy.varModel.model.datatypes.Sequence;
import net.ssehub.easy.varModel.model.datatypes.Set;
import net.ssehub.easy.varModel.model.datatypes.TypeQueries;
import net.ssehub.easy.varModel.model.filter.AbstractVariableInConstraintFinder;
import net.ssehub.easy.varModel.model.filter.FilterType;
import net.ssehub.easy.varModel.model.values.BooleanValue;
import net.ssehub.easy.varModel.model.values.EnumValue;
import net.ssehub.easy.varModel.model.values.IntValue;
import net.ssehub.easy.varModel.model.values.StringValue;
import net.ssehub.easy.varModel.model.values.Value;

public class IvmlUtils {
    public static boolean isOfCompoundType(IDecisionVariable var, String typeName) {
        return IvmlUtils.isOfCompoundType(var.getDeclaration(), typeName);
    }

    public static boolean isOfCompoundType(AbstractVariable var, String typeName) {
        return IvmlUtils.isOfCompoundType(var.getType(), typeName);
    }

    public static boolean isOfCompoundType(IDatatype type, String typeName) {
        return TypeQueries.isCompound((IDatatype)type) && typeName.equals(type.getName());
    }

    public static IDecisionVariable getNestedSafe(IDecisionVariable var, String nested) {
        return null == var ? null : var.getNestedElement(nested);
    }

    public static String getStringValue(IDecisionVariable var, String deflt) {
        Value val;
        String result = var == null ? deflt : (!((val = var.getValue()) instanceof StringValue) ? deflt : ((StringValue)val).getValue());
        return result;
    }

    public static String getStringValue(IDecisionVariable var, String nested, String deflt) {
        return IvmlUtils.getStringValue(null == var ? null : var.getNestedElement(nested), deflt);
    }

    public static int getIntValue(IDecisionVariable var, String nested, int deflt) {
        return IvmlUtils.getIntValue(null == var ? null : var.getNestedElement(nested), deflt);
    }

    public static boolean getBooleanValue(IDecisionVariable var, String nested, boolean deflt) {
        return IvmlUtils.getBooleanValue(null == var ? null : var.getNestedElement(nested), deflt);
    }

    public static EnumValue getEnumValue(IDecisionVariable var) {
        Value val;
        EnumValue result = null;
        if (var != null && (val = var.getValue()) instanceof EnumValue) {
            result = (EnumValue)val;
        }
        return result;
    }

    public static String toName(EnumValue value, String deflt) {
        String result = null == value ? deflt : value.getValue().getName();
        return result;
    }

    public static int getIntValue(IDecisionVariable var, int deflt) {
        Value val;
        int result = var == null ? deflt : (!((val = var.getValue()) instanceof IntValue) ? deflt : ((IntValue)val).getValue());
        return result;
    }

    public static boolean getBooleanValue(IDecisionVariable var, boolean deflt) {
        Value val;
        boolean result = var == null ? deflt : (!((val = var.getValue()) instanceof BooleanValue) ? deflt : ((BooleanValue)val).getValue());
        return result;
    }

    public static String getVarNameSafe(AbstractVariable var, String dflt) {
        return null == var ? dflt : var.getName();
    }

    public static Value getConstValue(ConstraintSyntaxTree cst) {
        Value result = null;
        if (cst instanceof ConstantValue) {
            result = ((ConstantValue)cst).getConstantValue();
        }
        return result;
    }

    public static int getIntValue(ConstraintSyntaxTree cst, int dflt) {
        int result = dflt;
        Value val = IvmlUtils.getConstValue(cst);
        if (val instanceof IntValue) {
            result = ((IntValue)val).getValue();
        }
        return result;
    }

    public static boolean analyzeReasoningResult(ReasoningResult res, boolean emitWarnings, boolean emitMessages) {
        boolean hasConflict = true;
        if (null != res) {
            hasConflict = res.hasConflict();
            int errorCount = 0;
            int templateErrorCount = 0;
            for (int m = 0; m < res.getMessageCount(); ++m) {
                Message msg = res.getMessage(m);
                Status status = msg.getStatus();
                boolean emit = true;
                if (status == Status.ERROR) {
                    ++errorCount;
                    boolean addressesTemplate = msg.getConflictProjects().stream().anyMatch(p -> IvmlUtils.isTemplate(p));
                    if (!addressesTemplate) {
                        for (java.util.Set s : msg.getProblemVariables()) {
                            for (IDecisionVariable v : s) {
                                addressesTemplate |= IvmlUtils.isInTemplate(v);
                            }
                        }
                    }
                    if (addressesTemplate) {
                        ++templateErrorCount;
                        emit = false;
                    }
                } else if (status == Status.WARNING) {
                    emit = emitWarnings;
                }
                if (!emit || !emitMessages) continue;
                System.out.println(msg.getDescription());
                if (!msg.getConflictComments().isEmpty()) {
                    System.out.println(msg.getConflictComments());
                }
                if (msg.getConflictSuggestions().isEmpty()) continue;
                System.out.println(msg.getConflictSuggestions());
            }
            if (templateErrorCount > 0 && templateErrorCount == errorCount) {
                hasConflict = false;
            }
        }
        return hasConflict;
    }

    public static java.util.Set<String> analyzeForTemplate(ReasoningResult res, String varName) {
        HashSet<String> openVars = new HashSet<String>();
        for (int m = 0; m < res.getMessageCount(); ++m) {
            Message msg = res.getMessage(m);
            Status status = msg.getStatus();
            if (status != Status.ERROR) continue;
            for (java.util.Set s : msg.getProblemVariables()) {
                for (IDecisionVariable v : s) {
                    String prefix;
                    if (!IvmlUtils.isInTemplate(v)) continue;
                    String name = v.getQualifiedName();
                    Project project = IvmlUtils.getProject(v);
                    if (project != null && name.startsWith(prefix = project.getName() + "::")) {
                        name = name.substring(prefix.length());
                    }
                    openVars.add(name.replace("::", "."));
                }
            }
        }
        return openVars;
    }

    public static IDecisionVariable dereference(IDecisionVariable var) {
        return Configuration.dereference((IDecisionVariable)var);
    }

    public static List<AbstractVariable> findTemplates(Project root) {
        ArrayList<AbstractVariable> result = new ArrayList<AbstractVariable>();
        HashSet<Project> projects = new HashSet<Project>();
        IvmlUtils.collectImports(root, projects);
        for (Project p : projects) {
            for (int e = 0; e < p.getElementCount(); ++e) {
                AbstractVariable var;
                ContainableModelElement elt = p.getElement(e);
                if (!(elt instanceof AbstractVariable) || !IvmlUtils.isTemplate(var = (AbstractVariable)elt)) continue;
                result.add(var);
            }
        }
        return result;
    }

    public static boolean containsVariable(Project prj, String varName) {
        boolean result = false;
        try {
            result = ModelQuery.findVariable((IResolutionScope)prj, (String)varName, null) != null;
        }
        catch (ModelQueryException modelQueryException) {
            // empty catch block
        }
        return result;
    }

    public static boolean isTemplate(Project prj) {
        return prj.getName().startsWith("TemplatePart");
    }

    public static boolean isTemplate(AbstractVariable var) {
        return IvmlUtils.isApplication(var) && IvmlUtils.isInTemplate(var);
    }

    public static boolean isApplication(AbstractVariable var) {
        return IvmlUtils.isOfCompoundType(var, "Application");
    }

    public static boolean isInTemplate(AbstractVariable var) {
        return IvmlUtils.isTemplate(var.getProject());
    }

    public static boolean isInTemplate(IDecisionVariable var) {
        boolean inTemplate = false;
        IDecisionVariable iter = var;
        while (!inTemplate && iter instanceof IDecisionVariable) {
            inTemplate = IvmlUtils.isTemplate(iter.getDeclaration().getProject());
            iter = iter.getParent();
        }
        return inTemplate;
    }

    public static Project getProject(IDecisionVariable var) {
        IDecisionVariable iter = var;
        while (iter.getParent() instanceof IDecisionVariable) {
            iter = iter.getParent();
        }
        return null == iter ? null : iter.getDeclaration().getProject();
    }

    public static java.util.Set<Project> findProjectsUsingVariable(Project root, AbstractVariable var) {
        HashSet<Project> usedIn = new HashSet<Project>();
        root.accept((IModelVisitor)new VariableInProjectFinder(root, var, usedIn));
        return usedIn;
    }

    public static void collectImports(Project prj, java.util.Set<Project> projects) {
        if (null != prj && !projects.contains(prj)) {
            projects.add(prj);
            for (int i = 0; i < prj.getImportsCount(); ++i) {
                ProjectImport imp = prj.getImport(i);
                IvmlUtils.collectImports((Project)imp.getResolved(), projects);
            }
        }
    }

    public static <E> void iterElements(Project prj, Class<E> cls, Consumer<E> consumer) {
        for (int e = 0; e < prj.getElementCount(); ++e) {
            ContainableModelElement elt = prj.getElement(e);
            if (!cls.isInstance(elt)) continue;
            consumer.accept(cls.cast(elt));
        }
    }

    public static boolean hasAnnotation(Project prj, String name) {
        boolean found = false;
        for (int e = 0; !found && e < prj.getElementCount(); ++e) {
            ContainableModelElement elt = prj.getElement(e);
            if (!(elt instanceof Attribute)) continue;
            Attribute attr = (Attribute)elt;
            found = attr.getName().equals(name);
        }
        return found;
    }

    private static class VariableInProjectFinder
    extends AbstractProjectVisitor {
        private VariableInConstraintFinder varFinder;
        private AbstractVariable toFind;
        private java.util.Set<Project> result;

        protected VariableInProjectFinder(Project originProject, AbstractVariable toFind, java.util.Set<Project> result) {
            super(originProject, FilterType.ALL);
            this.toFind = toFind;
            this.result = result;
            this.varFinder = new VariableInConstraintFinder(toFind, result);
        }

        public void visitDecisionVariableDeclaration(DecisionVariableDeclaration decl) {
            if (decl == this.toFind) {
                this.result.add(decl.getProject());
            }
            if (decl.getDefaultValue() != null) {
                decl.getDefaultValue().accept((IConstraintTreeVisitor)this.varFinder);
            }
        }

        public void visitAttribute(Attribute attribute) {
            if (attribute == this.toFind) {
                this.result.add(attribute.getProject());
            }
            if (attribute.getDefaultValue() != null) {
                attribute.getDefaultValue().accept((IConstraintTreeVisitor)this.varFinder);
            }
        }

        public void visitConstraint(Constraint constraint) {
            constraint.getConsSyntax().accept((IConstraintTreeVisitor)this.varFinder);
        }

        public void visitFreezeBlock(FreezeBlock freeze) {
            for (int f = 0; f < freeze.getFreezableCount(); ++f) {
                freeze.getFreezable(f).accept((IModelVisitor)this);
            }
        }

        public void visitOperationDefinition(OperationDefinition opdef) {
            opdef.getOperation().getFunction().accept((IConstraintTreeVisitor)this.varFinder);
        }

        public void visitPartialEvaluationBlock(PartialEvaluationBlock block) {
        }

        public void visitProjectInterface(ProjectInterface iface) {
        }

        public void visitComment(Comment comment) {
        }

        public void visitAttributeAssignment(AttributeAssignment assignment) {
            for (int c = 0; c < assignment.getConstraintsCount(); ++c) {
                assignment.getConstraint(c).accept((IModelVisitor)this);
            }
            for (int d = 0; d < assignment.getDeclarationCount(); ++d) {
                assignment.getDeclaration(d).accept((IModelVisitor)this);
            }
        }

        public void visitCompoundAccessStatement(CompoundAccessStatement access) {
            access.getCompoundVariable().accept((IModelVisitor)this);
        }

        public void visitEnum(Enum eenum) {
        }

        public void visitOrderedEnum(OrderedEnum eenum) {
        }

        public void visitCompound(Compound compound) {
            for (int c = 0; c < compound.getConstraintsCount(); ++c) {
                compound.getConstraint(c).accept((IModelVisitor)this);
            }
            for (int d = 0; d < compound.getDeclarationCount(); ++d) {
                compound.getDeclaration(d).accept((IModelVisitor)this);
            }
        }

        public void visitDerivedDatatype(DerivedDatatype datatype) {
            for (int c = 0; c < datatype.getConstraintCount(); ++c) {
                datatype.getConstraint(c).accept((IModelVisitor)this);
            }
        }

        public void visitEnumLiteral(EnumLiteral literal) {
        }

        public void visitReference(Reference reference) {
        }

        public void visitSequence(Sequence sequence) {
        }

        public void visitSet(Set set) {
        }
    }

    private static class VariableInConstraintFinder
    extends AbstractVariableInConstraintFinder {
        private AbstractVariable toFind;
        private java.util.Set<Project> result;

        protected VariableInConstraintFinder(AbstractVariable toFind, java.util.Set<Project> result) {
            super(true);
            this.toFind = toFind;
            this.result = result;
        }

        public void visitAnnotationVariable(AttributeVariable variable) {
            this.addVariable(variable.getVariable());
            if (null != variable.getQualifier()) {
                variable.getQualifier().accept((IConstraintTreeVisitor)this);
            }
        }

        public void visitLet(Let let) {
            let.getInitExpression().accept((IConstraintTreeVisitor)this);
            let.getInExpression().accept((IConstraintTreeVisitor)this);
        }

        public void visitContainerOperationCall(ContainerOperationCall call) {
            call.getContainer().accept((IConstraintTreeVisitor)this);
            call.getExpression().accept((IConstraintTreeVisitor)this);
        }

        public void visitCompoundAccess(CompoundAccess access) {
            this.addVariable(access.getResolvedSlot());
        }

        protected void addVariable(AbstractVariable declaration) {
            if (declaration == this.toFind) {
                this.result.add(declaration.getProject());
            }
        }
    }
}

