/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.configuration.easyProducer.opcua.data;

import de.iip_ecosphere.platform.configuration.easyProducer.opcua.data.BaseType;

public class VariableTypeType
extends BaseType {
    private String documentation;
    private String dataType;

    public VariableTypeType(String nodeId, String browseName, String displayName, String description, String documentation, String dataType) {
        super(nodeId, browseName, displayName, description, false);
        this.documentation = documentation;
        this.dataType = dataType;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public String getDataType() {
        return this.dataType;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("\tUAVariableTypeType " + this.getVarName() + " = {\n");
        builder.append("\t\tname = \"" + this.getVarName() + "\",\n");
        builder.append("\t\t" + VariableTypeType.formatNodeId(this.getNodeId()) + "\n");
        builder.append("\t\tnodeClass = NodeClass::UAVariableType,\n");
        builder.append("\t\tbrowseName = \"" + this.getBrowseName() + "\",\n");
        builder.append("\t\tdisplayName = \"" + this.getDisplayname() + "\",\n");
        builder.append("\t\tdocumentation = \"" + this.documentation + "\"");
        if (!this.dataType.equals("")) {
            if (!this.dataType.equals("opcType")) {
                builder.append(",\n\t\ttype = refBy(" + this.dataType + ")");
            } else {
                builder.append(",\n\t\ttype = refBy(opcUnknownDataType)");
            }
        }
        builder.append("\n\t};\n\n");
        return builder.toString();
    }
}

