/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hildesheim.sse.translation;

import net.ssehub.easy.varModel.cst.AttributeVariable;
import net.ssehub.easy.varModel.cst.BlockExpression;
import net.ssehub.easy.varModel.cst.Comment;
import net.ssehub.easy.varModel.cst.CompoundAccess;
import net.ssehub.easy.varModel.cst.CompoundInitializer;
import net.ssehub.easy.varModel.cst.ConstantValue;
import net.ssehub.easy.varModel.cst.ContainerInitializer;
import net.ssehub.easy.varModel.cst.ContainerOperationCall;
import net.ssehub.easy.varModel.cst.DeferInitExpression;
import net.ssehub.easy.varModel.cst.IConstraintTreeVisitor;
import net.ssehub.easy.varModel.cst.IfThen;
import net.ssehub.easy.varModel.cst.Let;
import net.ssehub.easy.varModel.cst.MultiAndExpression;
import net.ssehub.easy.varModel.cst.OCLFeatureCall;
import net.ssehub.easy.varModel.cst.Parenthesis;
import net.ssehub.easy.varModel.cst.Self;
import net.ssehub.easy.varModel.cst.UnresolvedExpression;
import net.ssehub.easy.varModel.cst.Variable;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.Container;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.Operation;
import net.ssehub.easy.varModel.model.datatypes.Sequence;

public class RefByCheckVisitor
implements IConstraintTreeVisitor {
    private boolean canBeDereferenced = false;

    public boolean canBeDereferenced() {
        return this.canBeDereferenced;
    }

    public void reset() {
        this.canBeDereferenced = false;
    }

    public void visitConstantValue(ConstantValue value) {
        this.canBeDereferenced = false;
    }

    public void visitVariable(Variable variable) {
        this.canBeDereferenced = true;
    }

    public void visitAnnotationVariable(AttributeVariable variable) {
        this.visitVariable((Variable)variable);
    }

    public void visitParenthesis(Parenthesis parenthesis) {
        parenthesis.getExpr().accept((IConstraintTreeVisitor)this);
    }

    public void visitComment(Comment comment) {
    }

    public void visitOclFeatureCall(OCLFeatureCall call) {
        Operation op = call.getResolvedOperation();
        this.canBeDereferenced = Sequence.AT == op || Sequence.INDEX_ACCESS == op;
    }

    public void visitDeferInitExpression(DeferInitExpression expression) {
        expression.getExpression().accept((IConstraintTreeVisitor)this);
    }

    public void visitMultiAndExpression(MultiAndExpression expression) {
        int e = 0;
        while (e < expression.getExpressionCount()) {
            expression.getExpression(e).accept((IConstraintTreeVisitor)this);
            ++e;
        }
    }

    public void visitLet(Let let) {
        let.getInExpression().accept((IConstraintTreeVisitor)this);
    }

    public void visitIfThen(IfThen ifThen) {
        ifThen.getIfExpr().accept((IConstraintTreeVisitor)this);
        if (ifThen.getThenExpr() != null) {
            boolean tmp = this.canBeDereferenced;
            ifThen.getThenExpr().accept((IConstraintTreeVisitor)this);
            this.canBeDereferenced &= tmp;
        }
    }

    public void visitContainerOperationCall(ContainerOperationCall call) {
        IDatatype ret = call.getResolvedOperation().getReturns();
        this.canBeDereferenced = Container.TYPE.isAssignableFrom(ret) || Compound.TYPE.isAssignableFrom(ret);
    }

    public void visitCompoundAccess(CompoundAccess access) {
        this.canBeDereferenced = true;
    }

    public void visitUnresolvedExpression(UnresolvedExpression expression) {
        this.canBeDereferenced = false;
    }

    public void visitCompoundInitializer(CompoundInitializer initializer) {
        this.canBeDereferenced = false;
    }

    public void visitContainerInitializer(ContainerInitializer initializer) {
        this.canBeDereferenced = false;
    }

    public void visitSelf(Self self) {
        this.canBeDereferenced = true;
    }

    public void visitBlockExpression(BlockExpression block) {
        int e = 0;
        int n = block.getExpressionCount();
        while (e < n) {
            block.getExpression(e).accept((IConstraintTreeVisitor)this);
            ++e;
        }
    }
}

