/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hildesheim.sse.validation;

import de.uni_hildesheim.sse.Config;
import de.uni_hildesheim.sse.ModelUtility;
import de.uni_hildesheim.sse.ivml.VariabilityUnit;
import de.uni_hildesheim.sse.validation.AbstractIvmlValidator;
import java.io.Writer;
import java.net.URI;
import net.ssehub.easy.dslCore.TranslationResult;
import net.ssehub.easy.dslCore.validation.ValidationUtils;
import net.ssehub.easy.varModel.management.VarModel;
import net.ssehub.easy.varModel.model.Project;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;

public class IvmlValidator
extends AbstractIvmlValidator {
    private ValidationUtils.IModelValidationCallback<VariabilityUnit, Project> callback = new ValidationUtils.IModelValidationCallback<VariabilityUnit, Project>(){

        public TranslationResult<Project> createModel(VariabilityUnit unit, URI uri) {
            return ModelUtility.INSTANCE.createVarModel(unit, uri, false);
        }

        public void message(ValidationUtils.MessageType type, String message, EObject source, EStructuralFeature feature, int identifier) {
            switch (type) {
                case ERROR: {
                    IvmlValidator.this.error(message, source, feature, identifier);
                    break;
                }
                case INFO: {
                    IvmlValidator.this.info(message, source, feature, identifier);
                    break;
                }
                case WARNING: {
                    IvmlValidator.this.warning(message, source, feature, identifier);
                    break;
                }
            }
        }

        public void print(TranslationResult<Project> result, Writer out) {
            ModelUtility.INSTANCE.print(result, out, true, false);
        }

        public boolean isValidationEnabled(URI uri) {
            return VarModel.INSTANCE.locations().getLocationFor(uri) != null;
        }
    };

    @Check(value=CheckType.NORMAL)
    public void checkModel(VariabilityUnit unit) {
        ValidationUtils.checkModelFromValidation((EObject)unit, this.callback, (boolean)Config.isDebuggingEnabled());
    }
}

