/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.core.mgmt;

import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.execution.Executor;
import net.ssehub.easy.instantiation.core.model.vilTypes.IProjectDescriptor;
import net.ssehub.easy.producer.core.mgmt.IVilExecutionListener;
import net.ssehub.easy.producer.core.mgmt.PLPInfo;
import net.ssehub.easy.producer.core.mgmt.ProjectDescriptor;
import net.ssehub.easy.producer.core.mgmt.VilArgumentProvider;
import net.ssehub.easy.producer.core.persistence.internal.Activator;

public class VilExecutionThread
implements Runnable {
    private Executor executor;
    private PLPInfo plp;
    private ProgressObserver observer;
    private boolean successful;
    private List<IVilExecutionListener> listeners;

    public VilExecutionThread(PLPInfo plp) {
        this.plp = plp;
        this.listeners = new ArrayList<IVilExecutionListener>();
    }

    protected Executor createExecutor(boolean forceSelfInstantiate) {
        boolean selfFront = Boolean.valueOf(System.getProperty("easy.instantiate.selfFront", "false"));
        ProjectDescriptor me = new ProjectDescriptor(this.plp);
        Executor executor = new Executor(this.plp.getBuildScript()).addTarget((IProjectDescriptor)me).addConfiguration(this.plp.getConfiguration());
        int predCount = this.plp.getMemberController().getPredecessorsCount();
        if (predCount == 0 || forceSelfInstantiate) {
            executor.addSource((IProjectDescriptor)me);
        } else {
            IProjectDescriptor[] pred = new IProjectDescriptor[predCount + 1];
            int i = 0;
            if (selfFront) {
                pred[i++] = me;
            }
            for (PLPInfo p : this.plp.getMemberController().getPredecessors()) {
                pred[i++] = new ProjectDescriptor(p);
            }
            if (!selfFront) {
                pred[i++] = me;
            }
            executor.addSources(pred);
        }
        VilArgumentProvider.provideArguments(this.plp, executor);
        return executor;
    }

    public void addListener(IVilExecutionListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(IVilExecutionListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    public void startInstantiation(ProgressObserver observer, boolean waitFor) {
        this.startInstantiation(observer, waitFor, false);
    }

    public void startInstantiation(ProgressObserver observer, boolean waitFor, boolean forceSelfInstantiate) {
        if (this.executor == null) {
            this.successful = true;
            this.observer = observer != null ? observer : ProgressObserver.NO_OBSERVER;
            this.executor = this.createExecutor(forceSelfInstantiate);
            Thread executionThread = new Thread(this);
            executionThread.start();
            if (waitFor) {
                try {
                    executionThread.join();
                }
                catch (InterruptedException e) {
                    Activator.getLogger(VilExecutionThread.class).exception((Exception)e);
                }
            }
        }
    }

    public void abortInstantiation() {
        if (this.executor != null) {
            this.successful = false;
            this.executor.stop();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        block8: {
            informFinished = false;
            try {
                try {
                    this.executor.execute(this.observer, true);
                    informFinished = true;
                    break block8;
                }
                catch (VilException e) {
                    i = 0;
                    ** while (i < this.listeners.size())
                }
lbl-1000:
                // 1 sources

                {
                    this.listeners.get(i).vilExecutionAborted(this.plp, e);
                    ++i;
                    continue;
lbl13:
                    // 1 sources

                }
            }
            finally {
                this.executor = null;
                this.observer = null;
                this.plp.refresh();
            }
        }
        if (informFinished) {
            i = 0;
            while (i < this.listeners.size()) {
                this.listeners.get(i).vilExecutionFinished(this.plp, this.successful);
                ++i;
            }
        }
    }
}

